/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubListIterableWrapper;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaOneToOneMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.EmbeddedIdAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.IdAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ManyToManyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.OwnableRelationshipMappingAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TableAnnotation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.UpdateAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.BidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.UnidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPACheckSum;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaArtifactFactory {
    private static final JpaArtifactFactory INSTANCE = new JpaArtifactFactory();
    private static final int MAX_NUM_OF_ITERATIONS = 25;
    private static final int PAUSE_DURATION = 200;
    private static final String COLLECTION_TYPE = "java.util.Collection";
    private static final String LIST_TYPE = "java.util.List";
    private static final String SET_TYPE = "java.util.Set";
    private static final String MAP_TYPE = "java.util.Map";

    public static synchronized JpaArtifactFactory instance() {
        return INSTANCE;
    }

    public void addOneToOneUnidirectionalRelation(IFeatureProvider fp, JavaPersistentType jpt, JavaPersistentAttribute attribute) {
        this.addOneToOneRelation(fp, jpt, attribute, null, null, 1);
    }

    public void addOneToOneBidirectionalRelation(IFeatureProvider fp, JavaPersistentType jpt1, JavaPersistentAttribute attribute1, JavaPersistentType jpt2, JavaPersistentAttribute attribute2) {
        this.addOneToOneRelation(fp, jpt1, attribute1, jpt2, attribute2, 2);
    }

    public void addOneToOneRelation(IFeatureProvider fp, JavaPersistentType ownerJPT, JavaPersistentAttribute ownerAttibute, JavaPersistentType referencedJPT, JavaPersistentAttribute referencedAttribute, int direction) {
        if (ownerJPT.getAttributeNamed(ownerAttibute.getName()) == null) {
            this.refreshEntityModel(fp, ownerJPT);
        }
        JavaPersistentAttribute attr = (JavaPersistentAttribute)ownerJPT.resolveAttribute(ownerAttibute.getName());
        attr.getResourceAttribute().setPrimaryAnnotation("javax.persistence.OneToOne", (Iterable)new ArrayListIterable((Object[])new String[0]));
        if (direction == 2) {
            JpaArtifactFactory.instance().refreshEntityModel(null, referencedJPT);
            JavaPersistentAttribute attr2 = (JavaPersistentAttribute)referencedJPT.resolveAttribute(referencedAttribute.getName());
            attr2.setMappingKey("oneToOne");
            attr2.getJpaProject().getRootContextNode().update();
            JavaOneToOneMapping mapping = (JavaOneToOneMapping)attr2.getMapping();
            OneToOneAnnotation annotation = mapping.getMappingAnnotation();
            if (annotation == null) {
                JpaArtifactFactory.instance().refreshEntityModel(null, referencedJPT);
                annotation = ((JavaOneToOneMapping)attr2.getMapping()).getMappingAnnotation();
            }
            annotation.setMappedBy(ownerAttibute.getName());
        }
    }

    public void addOneToManyUnidirectionalRelation(IFeatureProvider fp, JavaPersistentType jpt, JavaPersistentAttribute attribute, boolean isMap) {
        this.addOneToManyRelation(fp, jpt, attribute, null, null, 1, isMap);
    }

    public void addOneToManyBidirectionalRelation(IFeatureProvider fp, JavaPersistentType jpt1, JavaPersistentAttribute attribute1, JavaPersistentType jpt2, JavaPersistentAttribute attribute2, boolean isMap) {
        this.addOneToManyRelation(fp, jpt1, attribute1, jpt2, attribute2, 2, isMap);
    }

    public void addManyToOneBidirectionalRelation(IFeatureProvider fp, JavaPersistentType jpt1, JavaPersistentAttribute attribute1, JavaPersistentType jpt2, JavaPersistentAttribute attribute2, boolean isMap) {
        this.addManyToOneRelation(fp, jpt1, attribute1, jpt2, attribute2, 2, isMap);
    }

    public void addOneToManyRelation(IFeatureProvider fp, JavaPersistentType singleSideJPT, JavaPersistentAttribute singleSideAttibute, JavaPersistentType manySideJPT, JavaPersistentAttribute manySideAttribute, int direction, boolean isMap) {
        this.refreshEntityModel(fp, singleSideJPT);
        JavaPersistentAttribute resolvedSingleSideAttribute = (JavaPersistentAttribute)singleSideJPT.resolveAttribute(singleSideAttibute.getName());
        resolvedSingleSideAttribute.setMappingKey("oneToMany");
        if (direction == 2) {
            resolvedSingleSideAttribute.getJpaProject().getRootContextNode().update();
            JpaArtifactFactory.instance().refreshEntityModel(null, singleSideJPT);
            JavaAttributeMapping mapping = resolvedSingleSideAttribute.getMapping();
            if (!mapping.getClass().isInstance(JavaOneToManyMapping.class)) {
                return;
            }
            OneToManyAnnotation annotation = ((JavaOneToManyMapping)mapping).getMappingAnnotation();
            if (annotation == null) {
                JpaArtifactFactory.instance().refreshEntityModel(null, singleSideJPT);
                mapping = resolvedSingleSideAttribute.getMapping();
                annotation = ((JavaOneToManyMapping)mapping).getMappingAnnotation();
            }
            if (annotation == null) {
                JpaArtifactFactory.instance().refreshEntityModel(null, singleSideJPT);
                annotation = ((JavaOneToManyMapping)resolvedSingleSideAttribute.getMapping()).getMappingAnnotation();
            }
            annotation.setMappedBy(manySideAttribute.getName());
        }
        if (isMap) {
            singleSideAttibute.getResourceAttribute().addAnnotation("javax.persistence.MapKey");
        }
        if (direction == 2) {
            if (manySideJPT.getAttributeNamed(manySideAttribute.getName()) == null) {
                this.refreshEntityModel(fp, manySideJPT);
            }
            JavaPersistentAttribute resolvedManySideAttribute = (JavaPersistentAttribute)manySideJPT.resolveAttribute(manySideAttribute.getName());
            resolvedManySideAttribute.setMappingKey("manyToOne");
        } else {
            this.addJoinColumnIfNecessary(resolvedSingleSideAttribute, singleSideJPT, fp);
        }
    }

    private void addJoinColumnIfNecessary(JavaPersistentAttribute jpa, JavaPersistentType jpt, IFeatureProvider fp) {
        if (JPAEditorUtil.checkJPAFacetVersion(jpa.getJpaProject(), "1.0") || JPADiagramPropertyPage.shouldOneToManyUnidirBeOldStyle(jpa.getJpaProject().getProject())) {
            return;
        }
        JavaPersistentAttribute[] ids = this.getIds(jpt);
        if (ids.length == 0) {
            return;
        }
        String tableName = this.getTableName(jpt);
        if (ids.length == 1) {
            if (this.isSimpleId(ids[0])) {
                JoinColumnAnnotation an = (JoinColumnAnnotation)jpa.getResourceAttribute().addAnnotation(0, "javax.persistence.JoinColumn");
                String idColName = this.getColumnName(ids[0]);
                an.setName(String.valueOf(tableName) + "_" + idColName);
                an.setReferencedColumnName(idColName);
            } else {
                Hashtable<String, String> atNameToColName = this.getOverriddenColNames(ids[0]);
                PersistenceUnit pu = this.getPersistenceUnit(jpt);
                String embeddableTypeName = ids[0].getTypeName();
                Embeddable emb = pu.getEmbeddable(embeddableTypeName);
                for (AttributeMapping am : emb.getAllAttributeMappings()) {
                    JoinColumnAnnotation jc = (JoinColumnAnnotation)jpa.getResourceAttribute().addAnnotation(jpa.getResourceAttribute().getAnnotationsSize("javax.persistence.JoinColumn"), "javax.persistence.JoinColumn");
                    JavaPersistentAttribute at = (JavaPersistentAttribute)am.getPersistentAttribute();
                    String idColName = atNameToColName.get(at.getName());
                    idColName = idColName != null ? idColName : this.getColumnName(at);
                    jc.setName(String.valueOf(tableName) + "_" + idColName);
                    jc.setReferencedColumnName(idColName);
                }
            }
        } else {
            JavaPersistentAttribute[] javaPersistentAttributeArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                JavaPersistentAttribute idAt = javaPersistentAttributeArray[n2];
                JoinColumnAnnotation jc = (JoinColumnAnnotation)jpa.getResourceAttribute().addAnnotation(jpa.getResourceAttribute().getAnnotationsSize("javax.persistence.JoinColumn"), "javax.persistence.JoinColumn");
                String idColName = this.getColumnName(idAt);
                jc.setName(String.valueOf(tableName) + "_" + idColName);
                jc.setReferencedColumnName(idColName);
                ++n2;
            }
        }
    }

    private Hashtable<String, String> getOverriddenColNames(JavaPersistentAttribute embIdAt) {
        Hashtable<String, String> res = new Hashtable<String, String>();
        AttributeOverrideAnnotation aon = (AttributeOverrideAnnotation)embIdAt.getResourceAttribute().getAnnotation(0, "javax.persistence.AttributeOverride");
        if (aon != null) {
            ColumnAnnotation colAn = aon.getColumn();
            if (colAn == null) {
                return res;
            }
            String colName = colAn.getName();
            if (colName == null) {
                return res;
            }
            res.put(aon.getName(), colName);
            return res;
        }
        SubListIterableWrapper it = new SubListIterableWrapper(embIdAt.getResourceAttribute().getAnnotations("javax.persistence.AttributeOverride"));
        for (AttributeOverrideAnnotation an : it) {
            String colName;
            ColumnAnnotation colAn = an.getColumn();
            if (colAn == null || (colName = colAn.getName()) == null) continue;
            res.put(an.getName(), colName);
        }
        return res;
    }

    public void addManyToOneUnidirectionalRelation(IFeatureProvider fp, JavaPersistentType jpt, JavaPersistentAttribute attribute) {
        this.addManyToOneRelation(fp, jpt, attribute, null, null, 1, false);
    }

    public void addManyToOneRelation(IFeatureProvider fp, JavaPersistentType manySideJPT, JavaPersistentAttribute manySideAttribute, JavaPersistentType singleSideJPT, JavaPersistentAttribute singleSideAttibute, int direction, boolean isMap) {
        this.refreshEntityModel(fp, manySideJPT);
        JavaPersistentAttribute resolvedManySideAttribute = manySideJPT.getAttributeNamed(manySideAttribute.getName());
        resolvedManySideAttribute.setMappingKey("manyToOne");
        if (direction == 1) {
            return;
        }
        JavaPersistentAttribute resolvedSingleSideAttribute = singleSideJPT.getAttributeNamed(singleSideAttibute.getName());
        resolvedSingleSideAttribute.setMappingKey("oneToMany");
        this.refreshEntityModel(fp, singleSideJPT);
        JavaOneToManyMapping mapping = (JavaOneToManyMapping)resolvedSingleSideAttribute.getMapping();
        OneToManyAnnotation a = mapping.getMappingAnnotation();
        if (a == null) {
            return;
        }
        a.setMappedBy(manySideAttribute.getName());
        if (isMap) {
            singleSideAttibute.getResourceAttribute().addAnnotation("javax.persistence.MapKey");
        }
    }

    public void addManyToManyBidirectionalRelation(IFeatureProvider fp, JavaPersistentType jpt1, JavaPersistentAttribute attribute1, JavaPersistentType jpt2, JavaPersistentAttribute attribute2, boolean isMap) {
        this.addManyToManyRelation(fp, jpt1, attribute1, jpt2, attribute2, 2, isMap);
    }

    public void addManyToManyUnidirectionalRelation(IFeatureProvider fp, JavaPersistentType annotatedJPT, JavaPersistentAttribute annotatedAttribute, boolean isMap) {
        this.addManyToManyRelation(fp, annotatedJPT, annotatedAttribute, null, null, 1, isMap);
    }

    public void addManyToManyRelation(IFeatureProvider fp, JavaPersistentType ownerSideJPT, JavaPersistentAttribute ownerSideAttribute, JavaPersistentType inverseSideJPT, JavaPersistentAttribute inverseSideAttibute, int direction, boolean isMap) {
        if (ownerSideJPT.getAttributeNamed(ownerSideAttribute.getName()) == null) {
            this.refreshEntityModel(fp, ownerSideJPT);
        }
        JavaPersistentAttribute resolvedOwnerSideAttribute = (JavaPersistentAttribute)ownerSideJPT.resolveAttribute(ownerSideAttribute.getName());
        resolvedOwnerSideAttribute.setMappingKey("manyToMany");
        if (isMap) {
            resolvedOwnerSideAttribute.getResourceAttribute().addAnnotation("javax.persistence.MapKey");
        }
        if (direction == 2) {
            JpaArtifactFactory.instance().refreshEntityModel(null, inverseSideJPT);
            JavaPersistentAttribute resolvedInverseSideAttribute = (JavaPersistentAttribute)inverseSideJPT.resolveAttribute(inverseSideAttibute.getName());
            resolvedInverseSideAttribute.setMappingKey("manyToMany");
            resolvedInverseSideAttribute.getJpaProject().getRootContextNode().update();
            JavaManyToManyMapping mapping = (JavaManyToManyMapping)resolvedInverseSideAttribute.getMapping();
            ManyToManyAnnotation a = mapping.getMappingAnnotation();
            if (mapping == null || a == null) {
                JpaArtifactFactory.instance().refreshEntityModel(null, inverseSideJPT);
                mapping = (JavaManyToManyMapping)resolvedInverseSideAttribute.getMapping();
                a = mapping.getMappingAnnotation();
            }
            if (a == null) {
                return;
            }
            a.setMappedBy(ownerSideAttribute.getName());
            if (isMap) {
                resolvedInverseSideAttribute.getResourceAttribute().addAnnotation("javax.persistence.MapKey");
            }
        }
    }

    public void restoreEntityClass(JavaPersistentType jpt, IJPAEditorFeatureProvider fp) {
        fp.restoreEntity(jpt);
    }

    public void forceSaveEntityClass(final JavaPersistentType jpt, IJPAEditorFeatureProvider fp) {
        final ICompilationUnit cu = fp.getCompilationUnit(jpt);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                block3: {
                    try {
                        if (cu.isWorkingCopy()) {
                            cu.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        cu.save((IProgressMonitor)new NullProgressMonitor(), true);
                    }
                    catch (JavaModelException e) {
                        if (!cu.getResource().getProject().isAccessible() || !cu.getResource().isAccessible()) break block3;
                        JPADiagramEditorPlugin.logError("Cannot save entity '" + jpt.getName() + "'", e);
                    }
                }
            }
        });
    }

    public boolean deleteEntityClass(JavaPersistentType jpt, IJPAEditorFeatureProvider fp) {
        ICompilationUnit cu = fp.getCompilationUnit(jpt);
        try {
            JpaProject jpaProject = jpt.getJpaProject();
            jpaProject.updateAndWait();
            JPAEditorUtil.discardWorkingCopy(cu);
            cu.delete(true, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannot delete the JPA entity class", e);
            return false;
        }
    }

    public void deletePersistenceTypeResource(PersistentType type) throws CoreException {
        JpaProject proj = type.getJpaProject();
        String typeName = type.getName();
        IResource entityResource = type.getResource();
        entityResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
        int cnt = 0;
        JavaPersistentType jpt = this.getContextPersistentType(proj, typeName);
        while (jpt != null && cnt < 25) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Sleep interrupted", e);
            }
            ++cnt;
        }
    }

    public JavaPersistentType getContextPersistentType(JpaProject jpaProject, String fullyQualifiedTypeName) {
        PersistenceUnit unit = this.getPersistenceUnit(jpaProject);
        for (ClassRef ref : unit.getClassRefs()) {
            JavaPersistentType jpt = ref.getJavaPersistentType();
            if (jpt == null || !jpt.getName().equals(fullyQualifiedTypeName)) continue;
            return ref.getJavaPersistentType();
        }
        return null;
    }

    public String getEntityName(JavaPersistentType jpt) {
        if (jpt == null) {
            return "";
        }
        JavaResourceType jrpt = this.convertJPTToJRT(jpt);
        if (jrpt == null) {
            return "";
        }
        String name = null;
        JavaTypeMapping mapping = jpt.getMapping();
        if (mapping != null && JavaEntity.class.isInstance(mapping)) {
            name = ((JavaEntity)mapping).getSpecifiedName();
        }
        if (name == null) {
            name = jpt.getName();
        }
        return name;
    }

    public boolean hasNameAnnotation(JavaPersistentType jpt) {
        if (jpt == null) {
            return false;
        }
        JavaResourceType jrpt = this.convertJPTToJRT(jpt);
        if (jrpt == null) {
            return false;
        }
        JavaEntity mapping = (JavaEntity)jpt.getMapping();
        if (mapping != null) {
            return mapping.getSpecifiedName() != null;
        }
        return false;
    }

    public boolean hasEntityAnnotation(JavaPersistentType jpt) {
        return jpt.getMapping() instanceof JavaEntity;
    }

    public String getSpecifiedEntityName(JavaPersistentType jpt) {
        JavaEntity gje = (JavaEntity)jpt.getMapping();
        return gje.getSpecifiedName();
    }

    public void renameEntity(JavaPersistentType jpt, String newName) {
        JavaEntity gje = (JavaEntity)jpt.getMapping();
        gje.setSpecifiedName(newName);
    }

    public JavaPersistentAttribute addAttribute(IJPAEditorFeatureProvider fp, JavaPersistentType jpt, JavaPersistentType attributeType, String attributeName, String actName, boolean isCollection, ICompilationUnit cu1, ICompilationUnit cu2) {
        return this.addAttribute(fp, jpt, attributeType, null, attributeName, actName, isCollection, cu1, cu2);
    }

    public JavaPersistentAttribute addAttribute(IJPAEditorFeatureProvider fp, JavaPersistentType jpt, JavaPersistentType attributeType, String mapKeyType, String attributeName, String actName, boolean isCollection, ICompilationUnit cu1, ICompilationUnit cu2) {
        IType type = null;
        try {
            JPAEditorUtil.createImport(cu1, cu2.getType(attributeType.getName()).getElementName());
            type = cu1.findPrimaryType();
            this.refreshEntityModel(fp, jpt);
            if (this.doesAttributeExist(jpt, actName)) {
                return (JavaPersistentAttribute)jpt.resolveAttribute(attributeName);
            }
            if (isCollection) {
                Properties props;
                IProject project = jpt.getJpaProject().getProject();
                if (JPADiagramPropertyPage.isCollectionType(project, props = fp.loadProperties(project))) {
                    this.createContentType(attributeType, actName, cu1, type, COLLECTION_TYPE);
                    type.createMethod(this.genGetterWithAppropriateType(attributeName, JPAEditorUtil.returnSimpleName(attributeType.getName()), actName, COLLECTION_TYPE), null, false, (IProgressMonitor)new NullProgressMonitor());
                    type.createMethod(this.genSetterWithAppropriateType(attributeName, JPAEditorUtil.returnSimpleName(attributeType.getName()), actName, COLLECTION_TYPE), null, false, (IProgressMonitor)new NullProgressMonitor());
                } else if (JPADiagramPropertyPage.isListType(project, props)) {
                    this.createContentType(attributeType, actName, cu1, type, LIST_TYPE);
                    type.createMethod(this.genGetterWithAppropriateType(attributeName, JPAEditorUtil.returnSimpleName(attributeType.getName()), actName, LIST_TYPE), null, false, (IProgressMonitor)new NullProgressMonitor());
                    type.createMethod(this.genSetterWithAppropriateType(attributeName, JPAEditorUtil.returnSimpleName(attributeType.getName()), actName, LIST_TYPE), null, false, (IProgressMonitor)new NullProgressMonitor());
                } else if (JPADiagramPropertyPage.isSetType(project, props)) {
                    this.createContentType(attributeType, actName, cu1, type, SET_TYPE);
                    type.createMethod(this.genGetterWithAppropriateType(attributeName, JPAEditorUtil.returnSimpleName(attributeType.getName()), actName, SET_TYPE), null, false, (IProgressMonitor)new NullProgressMonitor());
                    type.createMethod(this.genSetterWithAppropriateType(attributeName, JPAEditorUtil.returnSimpleName(attributeType.getName()), actName, SET_TYPE), null, false, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    mapKeyType = this.createContentType(mapKeyType, attributeType, actName, cu1, type, MAP_TYPE);
                    type.createMethod(this.genGetterWithAppropriateType(attributeName, mapKeyType, JPAEditorUtil.returnSimpleName(attributeType.getName()), actName, MAP_TYPE), null, false, (IProgressMonitor)new NullProgressMonitor());
                    type.createMethod(this.genSetterWithAppropriateType(attributeName, mapKeyType, JPAEditorUtil.returnSimpleName(attributeType.getName()), actName, MAP_TYPE), null, false, (IProgressMonitor)new NullProgressMonitor());
                }
            } else {
                type.createField("  private " + JPAEditorUtil.returnSimpleName(attributeType.getName()) + " " + JPAEditorUtil.decapitalizeFirstLetter(actName) + ";", null, false, (IProgressMonitor)new NullProgressMonitor());
                type.createMethod(this.genGetterContents(attributeName, JPAEditorUtil.returnSimpleName(attributeType.getName()), null, actName, null, isCollection), null, false, (IProgressMonitor)new NullProgressMonitor());
                type.createMethod(this.genSetterContents(attributeName, JPAEditorUtil.returnSimpleName(attributeType.getName()), null, actName, isCollection), null, false, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannnot create a new attribute with name " + attributeName, e);
        }
        if (jpt.getAttributeNamed(attributeName) == null) {
            this.refreshEntityModel(fp, jpt);
        }
        JavaPersistentAttribute res = this.getAttributeFromEntity(jpt, actName);
        return res;
    }

    private void createContentType(JavaPersistentType attributeType, String actName, ICompilationUnit cu1, IType type, String collectionType) throws JavaModelException {
        this.createContentType(null, attributeType, actName, cu1, type, collectionType);
    }

    private String createContentType(String mapKeyType, JavaPersistentType attributeType, String actName, ICompilationUnit cu1, IType type, String collectionType) throws JavaModelException {
        if (mapKeyType != null) {
            mapKeyType = JPAEditorUtil.createImport(cu1, mapKeyType);
        }
        JPAEditorUtil.createImport(cu1, collectionType);
        type.createField("  private " + JPAEditorUtil.returnSimpleName(collectionType) + "<" + (mapKeyType != null ? String.valueOf(mapKeyType) + ", " : "") + JPAEditorUtil.returnSimpleName(attributeType.getName()) + "> " + JPAEditorUtil.decapitalizeFirstLetter(actName) + ";", null, false, (IProgressMonitor)new NullProgressMonitor());
        return mapKeyType;
    }

    public void refreshEntityModel(IFeatureProvider fp, JavaPersistentType jpt) {
        if (this.convertJPTToJRT(jpt) == null) {
            return;
        }
        if (fp == null) {
            jpt.update();
            return;
        }
        Shape el = (Shape)fp.getPictogramElementForBusinessObject((Object)jpt);
        if (JPACheckSum.INSTANCE().isEntityModelChanged(el, jpt.getJpaProject())) {
            try {
                jpt.update();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
    }

    public boolean isCollection(ContainerShape entityShape, IJPAEditorFeatureProvider fp, String attrTxt) {
        Object ob = fp.getBusinessObjectForPictogramElement((PictogramElement)entityShape);
        if (ob instanceof JavaPersistentType) {
            JavaPersistentType jpt = (JavaPersistentType)ob;
            ICompilationUnit cu = fp.getCompilationUnit(jpt);
            IType type = cu.getType(JPAEditorUtil.returnSimpleName(jpt.getName()));
            IField field = type.getField(attrTxt);
            int cnt = 0;
            while (cnt < 20 && !field.exists()) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    JPADiagramEditorPlugin.logError("Sleep interrupted", e);
                }
                field = type.getField(attrTxt);
                ++cnt;
            }
            if (field.exists()) {
                try {
                    if (field.getTypeSignature().contains("List") || field.getTypeSignature().contains("Set") || field.getTypeSignature().contains("Collection") || field.getTypeSignature().contains("Map") || field.getTypeSignature().endsWith("[]")) {
                        return true;
                    }
                }
                catch (JavaModelException e) {
                    JPADiagramEditorPlugin.logError(String.valueOf(JPAEditorMessages.JpaArtifactFactory_CanNotCheckReturnType) + " " + attrTxt + "\"", e);
                }
            }
        }
        return false;
    }

    public boolean isGetterMethodReturnTypeCollection(ContainerShape entityShape, IJPAEditorFeatureProvider fp, String attrTxt) {
        Object ob = fp.getBusinessObjectForPictogramElement((PictogramElement)entityShape);
        if (ob instanceof JavaPersistentType) {
            JavaPersistentType jpt = (JavaPersistentType)ob;
            ICompilationUnit cu = fp.getCompilationUnit(jpt);
            IType type = cu.getType(JPAEditorUtil.returnSimpleName(jpt.getName()));
            String attrNameWithCapitalLetter = String.valueOf(attrTxt.substring(0, 1).toUpperCase(Locale.ENGLISH)) + attrTxt.substring(1);
            String methodName = "get" + attrNameWithCapitalLetter;
            IMethod method = type.getMethod(methodName, new String[0]);
            try {
                if (method.getReturnType().contains("List") || method.getReturnType().contains("Set") || method.getReturnType().contains("Collection") || method.getReturnType().contains("Map") || method.getReturnType().endsWith("[]")) {
                    return true;
                }
            }
            catch (JavaModelException e) {
                JPADiagramEditorPlugin.logError(String.valueOf(JPAEditorMessages.JpaArtifactFactory_CanNotCheckReturnType) + " " + attrTxt + "\"", e);
            }
        }
        return false;
    }

    public String createNewAttribute(JavaPersistentType jpt, boolean isCollection, IJPAEditorFeatureProvider fp) {
        ICompilationUnit ijl = fp.getCompilationUnit(jpt);
        String attrTypeName = "java.lang.String";
        String newAttrName = this.genUniqueAttrName(jpt, attrTypeName, fp);
        return this.addNewAttribute(jpt, ijl, newAttrName, attrTypeName, "@Basic", newAttrName, isCollection, fp);
    }

    public JavaPersistentAttribute createANewAttribute(JavaPersistentType jpt, String attrName, String attrTypeName, String[] attrTypeElementNames, String actName, List<String> annotations, boolean isCollection, boolean isMethodAnnotated, IJPAEditorFeatureProvider fp) {
        ICompilationUnit ijl = fp.getCompilationUnit(jpt);
        return this.addANewAttribute(jpt, ijl, attrName, attrTypeName, attrTypeElementNames, actName, annotations, isCollection, isMethodAnnotated, fp);
    }

    private JavaPersistentAttribute addANewAttribute(JavaPersistentType jpt, ICompilationUnit cu, String attrName, String attrTypeName, String[] attrTypeElementNames, String actName, List<String> annotations, boolean isCollection, boolean isMethodAnnotated, IJPAEditorFeatureProvider fp) {
        JavaPersistentAttribute attr = null;
        try {
            attr = this.makeNewAttribute(fp, jpt, cu, attrName, attrTypeName, attrTypeElementNames, actName, annotations, isCollection, isMethodAnnotated);
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannot create a new attribute with name " + attrName, e);
        }
        return attr;
    }

    public String addNewAttribute(JavaPersistentType jpt, ICompilationUnit cu, String attrName, String attrTypeName, String annotation, String actName, boolean isCollection, IJPAEditorFeatureProvider fp) {
        try {
            LinkedList<String> annotations = new LinkedList<String>();
            annotations.add(annotation);
            boolean isMethodAnnotated = JpaArtifactFactory.instance().isMethodAnnotated(jpt);
            this.makeNewAttribute(fp, jpt, cu, attrName, attrTypeName, null, actName, annotations, isCollection, isMethodAnnotated);
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannot create a new attribute with name " + attrName, e);
        }
        return attrName;
    }

    public JavaPersistentAttribute makeNewAttribute(IFeatureProvider fp, JavaPersistentType jpt, ICompilationUnit cu, String attrName, String attrTypeName, String[] attrTypes, String actName, List<String> annotations, boolean isCollection, boolean isMethodAnnotated) throws JavaModelException {
        IType type = cu.findPrimaryType();
        String contents = "";
        boolean bl = isMethodAnnotated = annotations != null && !annotations.isEmpty() ? isMethodAnnotated : INSTANCE.isMethodAnnotated(jpt);
        if (!isMethodAnnotated && annotations != null) {
            for (String an : annotations) {
                contents = String.valueOf(contents) + "   " + an + "\n";
            }
        }
        if (annotations != null && annotations.contains("@Basic") && !cu.getImport("javax.persistence.*").exists() && !cu.getImport("javax.persistence.Basic").exists()) {
            JPAEditorUtil.createImports(cu, "javax.persistence.Basic");
        }
        boolean shouldAddImport = true;
        IImportDeclaration[] importDeclarations = cu.getImports();
        String attrShortTypeName = JPAEditorUtil.returnSimpleName(attrTypeName);
        IImportDeclaration[] iImportDeclarationArray = importDeclarations;
        int n = importDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration importDecl = iImportDeclarationArray[n2];
            String importedDeclarationFQN = importDecl.getElementName();
            String importedDeclarationShortName = JPAEditorUtil.returnSimpleName(importedDeclarationFQN);
            if (attrShortTypeName.equals(importedDeclarationShortName) && !attrTypeName.equals(importedDeclarationFQN)) {
                shouldAddImport = false;
            }
            ++n2;
        }
        if (shouldAddImport) {
            JPAEditorUtil.createImports(cu, attrTypeName);
            attrTypeName = JPAEditorUtil.returnSimpleName(attrTypeName);
        }
        if (attrTypes != null && attrTypes.length > 0) {
            JPAEditorUtil.createImports(cu, attrTypes);
        }
        contents = String.valueOf(contents) + "    private " + attrTypeName + (attrTypes == null ? "" : "<" + JPAEditorUtil.createCommaSeparatedListOfSimpleTypeNames(attrTypes) + ">") + " " + attrName + ";";
        type.createMethod(this.genSetterContents(attrName, attrTypeName, attrTypes, actName, isCollection), null, false, (IProgressMonitor)new NullProgressMonitor());
        if (isMethodAnnotated) {
            type.createMethod(this.genGetterContents(attrName, attrTypeName, attrTypes, actName, annotations, isCollection), null, false, (IProgressMonitor)new NullProgressMonitor());
            type.createField(contents, null, false, (IProgressMonitor)new NullProgressMonitor());
        } else {
            type.createField(contents, null, false, (IProgressMonitor)new NullProgressMonitor());
            type.createMethod(this.genGetterContents(attrName, attrTypeName, attrTypes, actName, null, isCollection), null, false, (IProgressMonitor)new NullProgressMonitor());
        }
        int cnt = 0;
        this.refreshEntityModel(fp, jpt);
        JavaPersistentAttribute jpa = jpt.getAttributeNamed(attrName);
        while (jpa == null && cnt < 25) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError(e);
            }
            jpa = jpt.getAttributeNamed(attrName);
            ++cnt;
        }
        return this.getAttributeFromEntity(jpt, attrName);
    }

    public void deleteAttribute(JavaPersistentType jpt, String attributeName, IJPAEditorFeatureProvider fp) {
        IField attributeField;
        boolean isMethodAnnotated;
        String attrNameWithCapitalLetter = String.valueOf(attributeName.substring(0, 1).toUpperCase(Locale.ENGLISH)) + attributeName.substring(1);
        ICompilationUnit compUnit = fp.getCompilationUnit(jpt);
        IType javaType = compUnit.findPrimaryType();
        String typeSignature = null;
        String getterPrefix = "get";
        String methodName = String.valueOf(getterPrefix) + attrNameWithCapitalLetter;
        IMethod getAttributeMethod = javaType.getMethod(methodName, new String[0]);
        if (!getAttributeMethod.exists()) {
            JavaPersistentAttribute jpa = jpt.getAttributeNamed(attributeName);
            String typeName = jpa.getResourceAttribute().getTypeName();
            if ("boolean".equals(typeName)) {
                getterPrefix = "is";
                methodName = String.valueOf(getterPrefix) + attrNameWithCapitalLetter;
                getAttributeMethod = javaType.getMethod(methodName, new String[0]);
            }
            try {
                if (getAttributeMethod == null || getAttributeMethod.exists()) {
                    // empty if block
                }
                typeSignature = getAttributeMethod.getReturnType();
            }
            catch (JavaModelException e1) {
                JPADiagramEditorPlugin.logError("Cannot obtain the type of the getter with name " + methodName + "()", e1);
            }
        }
        if (typeSignature == null) {
            methodName = null;
        }
        if (isMethodAnnotated = JpaArtifactFactory.instance().isMethodAnnotated(jpt)) {
            try {
                attributeField = javaType.getField(attributeName);
                if (attributeField != null && !attributeField.exists()) {
                    attributeField = javaType.getField(JPAEditorUtil.revertFirstLetterCase(attributeName));
                }
                if (attributeField != null && attributeField.exists()) {
                    attributeField.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (JavaModelException e) {
                JPADiagramEditorPlugin.logError("Cannot remove the attribute field with name " + attributeName, e);
            }
            try {
                methodName = String.valueOf(getterPrefix) + attrNameWithCapitalLetter;
                if (getAttributeMethod != null) {
                    typeSignature = getAttributeMethod.getReturnType();
                    if (getAttributeMethod.exists()) {
                        getAttributeMethod.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
            catch (JavaModelException e) {
                JPADiagramEditorPlugin.logError("Cannot remove the attribute getter with name " + methodName + "()", e);
            }
        } else {
            try {
                methodName = String.valueOf(getterPrefix) + attrNameWithCapitalLetter;
                if (getAttributeMethod.exists()) {
                    typeSignature = getAttributeMethod.getReturnType();
                    getAttributeMethod.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (JavaModelException e) {
                JPADiagramEditorPlugin.logError("Cannot remove the attribute getter with name " + methodName + "()", e);
            }
            try {
                attributeField = javaType.getField(attributeName);
                if (attributeField != null && !attributeField.exists()) {
                    attributeField = javaType.getField(JPAEditorUtil.revertFirstLetterCase(attributeName));
                }
                if (attributeField != null && attributeField.exists()) {
                    attributeField.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (JavaModelException e) {
                JPADiagramEditorPlugin.logError("Cannot remove the attribute field with name " + attributeName, e);
            }
        }
        try {
            methodName = "set" + attrNameWithCapitalLetter;
            IMethod setAttributeMethod = javaType.getMethod(methodName, new String[]{typeSignature});
            if (setAttributeMethod != null && setAttributeMethod.exists()) {
                setAttributeMethod.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            JPADiagramEditorPlugin.logError("Cannot remove the attribute setter with name " + methodName + "(...)", e);
        }
        this.refreshEntityModel(fp, jpt);
        ReadOnlyPersistentAttribute at = jpt.resolveAttribute(attributeName);
        int c = 0;
        while (at != null && c < 25) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Thread.sleep() interrupted", e);
            }
            at = jpt.getAttributeNamed(attributeName);
            ++c;
        }
    }

    private String genUniqueAttrName(JavaPersistentType jpt, String attrTypeName, IJPAEditorFeatureProvider fp) {
        String name2;
        ICompilationUnit ijl = fp.getCompilationUnit(jpt);
        IType type = null;
        type = ijl.findPrimaryType();
        HashSet<String> attrNames = new HashSet<String>();
        for (String name2 : jpt.getAttributeNames()) {
            attrNames.add(name2);
        }
        name2 = null;
        int i = 1;
        while (i < 10000000) {
            name2 = "attribute" + i;
            String attrNameWithCapitalLetter = JPAEditorUtil.capitalizeFirstLetter(name2);
            String getterName = "get" + attrNameWithCapitalLetter;
            String setterName = "set" + attrNameWithCapitalLetter;
            if (!attrNames.contains(name2)) {
                IField fld = type.getField(name2);
                IMethod getter = type.getMethod(getterName, new String[0]);
                IMethod setter1 = type.getMethod(setterName, new String[]{attrTypeName});
                IMethod setter2 = type.getMethod(setterName, new String[]{"QSet<Q" + attrTypeName + ";>;"});
                IMethod setter3 = type.getMethod(setterName, new String[]{"QCollection<Q" + attrTypeName + ";>;"});
                IMethod setter4 = type.getMethod(setterName, new String[]{"QSet;"});
                IMethod setter5 = type.getMethod(setterName, new String[]{"QCollection;"});
                if (!fld.exists() && !getter.exists() && !setter1.exists() && !setter2.exists() && !setter3.exists() && !setter4.exists() && !setter5.exists()) break;
            }
            ++i;
        }
        return name2;
    }

    public Annotation[] getAnnotations(JavaPersistentAttribute persistentAttribite) {
        JavaResourceAttribute jrpt = persistentAttribite.getResourceAttribute();
        Annotation[] res = new Annotation[jrpt.getAnnotationsSize()];
        int c = 0;
        Iterator iterator = jrpt.getAnnotations().iterator();
        while (iterator.hasNext()) {
            Annotation annotation;
            res[c] = annotation = (Annotation)iterator.next();
            ++c;
        }
        return res;
    }

    public HashSet<String> getAnnotationNames(JavaPersistentAttribute persistentAttribite) {
        JavaResourceAttribute jrpt = persistentAttribite.getResourceAttribute();
        HashSet<String> res = new HashSet<String>();
        for (Annotation annotation : jrpt.getAnnotations()) {
            res.add(JPAEditorUtil.returnSimpleName(annotation.getAnnotationName()));
        }
        return res;
    }

    public List<String> getAnnotationStrings(JavaPersistentAttribute persistentAttribite) {
        JavaPersistentType jpt = (JavaPersistentType)persistentAttribite.getParent();
        CompilationUnit jdtCU = jpt.getJavaResourceType().getJavaResourceCompilationUnit().buildASTRoot();
        JavaResourceAttribute jrpt = persistentAttribite.getResourceAttribute();
        LinkedList<String> res = new LinkedList<String>();
        for (Annotation an : jrpt.getAnnotations()) {
            org.eclipse.jdt.core.dom.Annotation jdtAn = an.getAstAnnotation(jdtCU);
            res.add(jdtAn.toString());
        }
        return res;
    }

    private boolean isNonOwner(JavaPersistentAttribute at) {
        JavaAttributeMapping jam = at.getMapping();
        JpaArtifactFactory.instance().refreshEntityModel(null, (JavaPersistentType)at.getParent());
        jam = at.getMapping();
        if (!(jam.getMappingAnnotation() instanceof OwnableRelationshipMappingAnnotation)) {
            return false;
        }
        OwnableRelationshipMappingAnnotation nom = (OwnableRelationshipMappingAnnotation)jam.getMappingAnnotation();
        return nom.getMappedBy() != null;
    }

    public Collection<IRelation> produceAllRelations(JavaPersistentType newJPT, IJPAEditorFeatureProvider fp) {
        Collection<IRelation> res = this.produceRelations(newJPT, fp);
        Iterator<IRelation> it = res.iterator();
        HashSet<JavaPersistentType> checkedEntities = new HashSet<JavaPersistentType>();
        while (it.hasNext()) {
            IRelation rel = it.next();
            checkedEntities.add(rel.getOwner());
            checkedEntities.add(rel.getInverse());
        }
        EList shapes = fp.getDiagramTypeProvider().getDiagram().getChildren();
        for (Shape sh : shapes) {
            JavaPersistentType jpt = (JavaPersistentType)fp.getBusinessObjectForPictogramElement((PictogramElement)sh);
            if (jpt == null) continue;
            Collection<IRelation> rels = this.produceRelations(jpt, newJPT, fp);
            res.addAll(rels);
        }
        return res;
    }

    private Collection<IRelation> produceRelations(JavaPersistentType newJPT, IJPAEditorFeatureProvider fp) {
        HashSet<IRelation> res = new HashSet<IRelation>();
        for (JavaPersistentAttribute at : newJPT.getAttributes()) {
            IRelation rel = this.produceRelation(at, fp);
            if (rel == null) continue;
            res.add(rel);
        }
        return res;
    }

    public boolean isRelationAnnotated(JavaPersistentAttribute jpa) {
        HashSet<String> anNames = this.getAnnotationNames(jpa);
        for (String anName : anNames) {
            if (!JPAEditorConstants.RELATION_ANNOTATIONS.contains(anName)) continue;
            return true;
        }
        return false;
    }

    public IRelation produceRelation(JavaPersistentAttribute persistentAttribite, IJPAEditorFeatureProvider fp) {
        Annotation[] ans;
        JavaResourceAttribute jrpa = persistentAttribite.getResourceAttribute();
        IRelation res = null;
        Annotation[] annotationArray = ans = this.getAnnotations(persistentAttribite);
        int n = ans.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation an = annotationArray[n2];
            String annotationName = JPAEditorUtil.returnSimpleName(an.getAnnotationName());
            if (JPAEditorConstants.RELATION_ANNOTATIONS.contains(annotationName)) {
                String relTypeName = this.getRelTypeName((RelationshipMappingAnnotation)an, jrpa);
                JavaPersistentType relJPT = (JavaPersistentType)fp.getBusinessObjectForKey(relTypeName);
                if (relJPT != null) {
                    res = this.produceRelation(persistentAttribite, an, relJPT, fp);
                }
                return res;
            }
            ++n2;
        }
        return res;
    }

    private Collection<IRelation> produceRelations(JavaPersistentType jpt1, JavaPersistentType jpt2, IJPAEditorFeatureProvider fp) {
        HashSet<IRelation> resSet = new HashSet<IRelation>();
        IRelation res = null;
        for (JavaPersistentAttribute at : jpt1.getAttributes()) {
            IResource r = at.getParent().getResource();
            if (!r.exists()) {
                throw new RuntimeException();
            }
            try {
                Annotation[] ans;
                JavaResourceAttribute jrpa = at.getResourceAttribute();
                Annotation[] annotationArray = ans = this.getAnnotations(at);
                int n = ans.length;
                int n2 = 0;
                while (n2 < n) {
                    JavaPersistentType relJPT;
                    String relTypeName;
                    Annotation an = annotationArray[n2];
                    String annotationName = JPAEditorUtil.returnSimpleName(an.getAnnotationName());
                    if (JPAEditorConstants.RELATION_ANNOTATIONS.contains(annotationName) && (relTypeName = this.getRelTypeName((RelationshipMappingAnnotation)an, jrpa)).equals(jpt2.getName()) && (res = this.produceRelation(at, an, relJPT = (JavaPersistentType)fp.getBusinessObjectForKey(jpt2.getName()), fp)) != null) {
                        resSet.add(res);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException();
            }
        }
        return resSet;
    }

    public JavaPersistentType getJPT(String name, PersistenceUnit pu) {
        pu.getJpaProject().updateAndWait();
        JavaPersistentType jpt = (JavaPersistentType)pu.getPersistentType(name);
        int cnt = 0;
        while (jpt == null && cnt < 25) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Sleep interrupted", e);
            }
            jpt = (JavaPersistentType)pu.getPersistentType(name);
            ++cnt;
        }
        return jpt;
    }

    public Set<JavaPersistentAttribute> getRelatedAttributes(JavaPersistentType jpt) {
        HashSet<JavaPersistentAttribute> res = new HashSet<JavaPersistentAttribute>();
        Iterator it = jpt.getJpaProject().getJpaFiles().iterator();
        PersistenceUnit pu = INSTANCE.getPersistenceUnit(jpt.getJpaProject());
        while (it.hasNext()) {
            Set<JavaPersistentAttribute> relAts;
            String name;
            JavaPersistentType jpt1;
            JavaResourceCompilationUnit jrcu;
            JavaResourceAbstractType jrt;
            JpaFile jpaFile = (JpaFile)it.next();
            JptResourceModel rm = jpaFile.getResourceModel();
            if (rm == null || !JavaResourceCompilationUnit.class.isInstance(rm) || (jrt = (jrcu = (JavaResourceCompilationUnit)rm).getPrimaryType()) == null || (jpt1 = (JavaPersistentType)pu.getPersistentType(name = jrt.getQualifiedName())) == null || (relAts = this.getRelAttributes(jpt, jpt1)) == null) continue;
            res.addAll(relAts);
        }
        return res;
    }

    private Set<JavaPersistentAttribute> getRelAttributes(JavaPersistentType jpt, JavaPersistentType relJPT) {
        HashSet<JavaPersistentAttribute> res = new HashSet<JavaPersistentAttribute>();
        for (JavaPersistentAttribute at : relJPT.getAttributes()) {
            IResource r = at.getParent().getResource();
            if (!r.exists()) {
                throw new RuntimeException();
            }
            Annotation[] ans = this.getAnnotations(at);
            String annotationName = null;
            Annotation[] annotationArray = ans;
            int n = ans.length;
            int n2 = 0;
            while (n2 < n) {
                String relTypeName;
                Annotation an = annotationArray[n2];
                annotationName = JPAEditorUtil.returnSimpleName(an.getAnnotationName());
                if (JPAEditorConstants.RELATION_ANNOTATIONS.contains(annotationName) && (relTypeName = this.getRelTypeName((RelationshipMappingAnnotation)an, at.getResourceAttribute())).equals(jpt.getName())) {
                    res.add(at);
                }
                ++n2;
            }
        }
        return res;
    }

    public void renameEntityClass(JavaPersistentType jpt, String newEntityName, IJPAEditorFeatureProvider fp) {
        this.renameEntityClass(fp.getCompilationUnit(jpt), newEntityName);
    }

    private void renameEntityClass(ICompilationUnit cu, String newName) {
        IType javaType = cu.findPrimaryType();
        this.renameType(javaType, newName);
    }

    private void renameType(IType type, String newName) {
        if (!type.exists()) {
            return;
        }
        String oldName = type.getElementName();
        try {
            RenameSupport s = RenameSupport.create((IType)type, (String)newName, (int)1);
            IWorkbenchWindow ww = JPADiagramEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            Shell sh = ww.getShell();
            s.perform(sh, (IRunnableContext)ww);
        }
        catch (Exception e1) {
            JPADiagramEditorPlugin.logError("Cannot rename the type " + oldName, e1);
        }
    }

    public JavaPersistentAttribute renameAttribute(JavaPersistentType jpt, String oldName, String newName, String inverseEntityName, IJPAEditorFeatureProvider fp) throws InterruptedException {
        newName = JPAEditorUtil.decapitalizeFirstLetter(newName);
        if (JpaArtifactFactory.instance().isMethodAnnotated(jpt)) {
            newName = JPAEditorUtil.produceValidAttributeName(newName);
        }
        newName = JPAEditorUtil.produceUniqueAttributeName(jpt, newName);
        PersistenceUnit pu = null;
        JavaPersistentAttribute oldAt = jpt.getAttributeNamed(oldName);
        fp.addAddIgnore((JavaPersistentType)oldAt.getParent(), newName);
        JavaResourceAttribute jra = oldAt.getResourceAttribute();
        fp.addRemoveIgnore((JavaPersistentType)oldAt.getParent(), jra.getName());
        IRelation rel = fp.getRelationRelatedToAttribute(oldAt);
        String inverseJPAName = null;
        JavaPersistentType inverseJPT = null;
        if (BidirectionalRelation.class.isInstance(rel) && (inverseJPT = rel.getInverse()) != oldAt.getParent()) {
            pu = INSTANCE.getPersistenceUnit(jpt);
            inverseJPAName = rel.getInverseAttributeName();
        }
        ICompilationUnit cu = fp.getCompilationUnit(jpt);
        this.renameAttribute(cu, oldName, newName, fp, this.isMethodAnnotated(jpt));
        this.refreshEntityModel(fp, jpt);
        JavaPersistentAttribute newAt = jpt.getAttributeNamed(newName);
        if (newAt == null) {
            newAt = jpt.getAttributeNamed(JPAEditorUtil.revertFirstLetterCase(newName));
        }
        for (int c = 0; newAt == null && c < 25; ++c) {
            try {
                Thread.sleep(200L);
                newAt = jpt.getAttributeNamed(newName);
                if (newAt != null) continue;
                newAt = (JavaPersistentAttribute)jpt.resolveAttribute(JPAEditorUtil.revertFirstLetterCase(newName));
                continue;
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Thread.sleep() interrupted", e);
                return null;
            }
        }
        if (newAt == null) {
            JPADiagramEditorPlugin.logError("The attribute " + newName + " could not be resolved", new NullPointerException());
        }
        fp.addRemoveIgnore(jpt, oldAt.getName());
        try {
            fp.replaceAttribute(oldAt, newAt);
        }
        catch (Exception exception) {
            return newAt;
        }
        if (inverseJPAName != null) {
            fp.addAttribForUpdate(pu, String.valueOf(inverseEntityName) + ";" + inverseJPAName + ";" + newAt.getName());
            this.refreshEntityModel(fp, inverseJPT);
            Annotation a = rel.getInverseAnnotatedAttribute().getMapping().getMappingAnnotation();
            if (OwnableRelationshipMappingAnnotation.class.isInstance(a)) {
                boolean exce = true;
                int cnt = 0;
                while (exce && cnt < 25) {
                    try {
                        Thread.sleep(250L);
                        a = rel.getInverseAnnotatedAttribute().getMapping().getMappingAnnotation();
                        ((OwnableRelationshipMappingAnnotation)a).setMappedBy(newAt.getName());
                        exce = false;
                    }
                    catch (Exception exception) {}
                    ++cnt;
                }
            }
        }
        if (rel != null) {
            this.updateRelation(jpt, fp, rel);
        }
        return newAt;
    }

    private void updateRelation(JavaPersistentType jpt, IJPAEditorFeatureProvider fp, IRelation rel) {
        UpdateAttributeFeature updateFeature = new UpdateAttributeFeature(fp);
        if (jpt.equals(rel.getInverse())) {
            updateFeature.reconnect(rel.getOwner());
        } else {
            updateFeature.reconnect(rel.getInverse());
        }
    }

    public JavaPersistentAttribute renameAttribute(JavaPersistentAttribute jpa, String newName, String newEntityName, IJPAEditorFeatureProvider fp) throws InterruptedException {
        return this.renameAttribute((JavaPersistentType)jpa.getParent(), jpa.getName(), newName, newEntityName, fp);
    }

    private void renameAttribute(ICompilationUnit cu, String oldName, String newName, IJPAEditorFeatureProvider fp, boolean isMethodAnnotated) throws InterruptedException {
        IMethod setter;
        String getterPrefix;
        String methodName;
        IMethod getter;
        IType javaType = cu.findPrimaryType();
        if (javaType == null) {
            return;
        }
        IField attributeField = null;
        String typeSignature = null;
        if (isMethodAnnotated) {
            attributeField = javaType.getField(oldName);
            if (!attributeField.exists()) {
                attributeField = javaType.getField(JPAEditorUtil.revertFirstLetterCase(oldName));
            }
        } else {
            attributeField = javaType.getField(oldName);
        }
        if (!(getter = javaType.getMethod(methodName = String.valueOf(getterPrefix = "get") + JPAEditorUtil.capitalizeFirstLetter(oldName), new String[0])).exists()) {
            getterPrefix = "is";
        }
        methodName = String.valueOf(getterPrefix) + JPAEditorUtil.capitalizeFirstLetter(oldName);
        getter = javaType.getMethod(methodName, new String[0]);
        if (isMethodAnnotated) {
            try {
                typeSignature = getter.getReturnType();
            }
            catch (JavaModelException e1) {
                JPADiagramEditorPlugin.logError("Cannot obtain type signature of the getter of the attribute " + oldName, e1);
                return;
            }
            if (typeSignature == null || !"Z".equals(typeSignature) && !getterPrefix.equals("get")) {
                JPADiagramEditorPlugin.logError("Cannot obtain type signature of the getter of the attribute " + oldName, new NullPointerException());
                return;
            }
        } else {
            try {
                typeSignature = attributeField.getTypeSignature();
            }
            catch (JavaModelException e) {
                JPADiagramEditorPlugin.logError("Cannot obtain type signature of the field of the attribute " + oldName, e);
                return;
            }
        }
        if ((setter = javaType.getMethod(methodName = "set" + JPAEditorUtil.capitalizeFirstLetter(oldName), new String[]{typeSignature})).exists()) {
            this.renameSetter(setter, newName);
        }
        if (isMethodAnnotated) {
            if (attributeField.exists()) {
                this.renameField(attributeField, newName, isMethodAnnotated);
            }
            if (getter.exists()) {
                this.renameGetter(getter, newName);
            }
        } else {
            if (getter.exists()) {
                this.renameGetter(getter, newName);
            }
            if (attributeField.exists()) {
                this.renameField(attributeField, newName, isMethodAnnotated);
            }
        }
    }

    private void renameField(IField field, String newName, boolean isMethodAnnotated) throws InterruptedException {
        if (!field.exists()) {
            return;
        }
        String oldName = field.getElementName();
        if (oldName.equals(newName)) {
            return;
        }
        try {
            RenameSupport s = RenameSupport.create((IField)field, (String)(isMethodAnnotated ? JPAEditorUtil.decapitalizeFirstLetter(newName) : newName), (int)1);
            try {
                IWorkbenchWindow ww = JPADiagramEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                Shell sh = ww.getShell();
                s.perform(sh, (IRunnableContext)ww);
            }
            catch (InvocationTargetException e) {
                JPADiagramEditorPlugin.logError("Cannot rename the field of the attribute " + oldName, e);
            }
        }
        catch (CoreException e1) {
            JPADiagramEditorPlugin.logError("Cannot rename the field of the attribute " + oldName, e1);
        }
    }

    private void renameGetter(IMethod getter, String newName) throws InterruptedException {
        if (!getter.exists()) {
            return;
        }
        String oldName = getter.getElementName();
        String getterType = null;
        try {
            getterType = getter.getReturnType();
        }
        catch (JavaModelException e2) {
            JPADiagramEditorPlugin.logError("Can't obtain getter type", e2);
        }
        String newGetterName = String.valueOf("Z".equals(getterType) ? "is" : "get") + JPAEditorUtil.capitalizeFirstLetter(newName);
        if (oldName.equals(newGetterName)) {
            return;
        }
        try {
            RenameSupport s = RenameSupport.create((IMethod)getter, (String)newGetterName, (int)1);
            try {
                IWorkbenchWindow ww = JPADiagramEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                Shell sh = ww.getShell();
                s.perform(sh, (IRunnableContext)ww);
            }
            catch (InvocationTargetException e) {
                JPADiagramEditorPlugin.logError("Cannot rename the getter of the attribute " + oldName, e);
            }
        }
        catch (CoreException e1) {
            JPADiagramEditorPlugin.logError("Cannot rename the getter of the attribute " + oldName, e1);
        }
    }

    private void renameSetter(IMethod setter, String newName) throws InterruptedException {
        String newSetterName;
        if (!setter.exists()) {
            return;
        }
        String oldName = setter.getElementName();
        if (oldName.equals(newSetterName = "set" + JPAEditorUtil.capitalizeFirstLetter(newName))) {
            return;
        }
        try {
            RenameSupport s = RenameSupport.create((IMethod)setter, (String)newSetterName, (int)1);
            try {
                IWorkbenchWindow ww = JPADiagramEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                Shell sh = ww.getShell();
                s.perform(sh, (IRunnableContext)ww);
            }
            catch (InvocationTargetException e) {
                JPADiagramEditorPlugin.logError("Cannot rename the setter of the attribute " + oldName, e);
            }
        }
        catch (CoreException e1) {
            JPADiagramEditorPlugin.logError("Cannot rename the setter of the attribute " + oldName, e1);
        }
    }

    private IRelation produceRelation(JavaPersistentAttribute persistentAttribite, Annotation an, JavaPersistentType relJPT, IJPAEditorFeatureProvider fp) {
        Hashtable<JavaPersistentAttribute, Annotation> ht = this.getRelAttributeAnnotation(persistentAttribite, relJPT);
        if (ht == null) {
            return this.produceUniDirRelation((JavaPersistentType)persistentAttribite.getParent(), persistentAttribite, an, relJPT, fp);
        }
        JavaPersistentAttribute relAt = ht.keys().nextElement();
        Annotation relAn = ht.get(relAt);
        return this.produceBiDirRelation((JavaPersistentType)persistentAttribite.getParent(), persistentAttribite, an, relJPT, relAt, relAn, fp);
    }

    private Hashtable<JavaPersistentAttribute, Annotation> getRelAttributeAnnotation(JavaPersistentAttribute jpa, JavaPersistentType relJPT) {
        JavaPersistentType jpt = (JavaPersistentType)jpa.getParent();
        JpaArtifactFactory.instance().refreshEntityModel(null, jpt);
        for (JavaPersistentAttribute relEntAt : relJPT.getAttributes()) {
            Annotation[] ans;
            IResource r = relEntAt.getParent().getResource();
            if (!r.exists()) {
                throw new RuntimeException();
            }
            JavaResourceAttribute relJRA = relEntAt.getResourceAttribute();
            Annotation[] annotationArray = ans = this.getAnnotations(relEntAt);
            int n = ans.length;
            int n2 = 0;
            while (n2 < n) {
                String relTypeName;
                Annotation an = annotationArray[n2];
                String annotationName = JPAEditorUtil.returnSimpleName(an.getAnnotationName());
                if (JPAEditorConstants.RELATION_ANNOTATIONS.contains(annotationName) && (relTypeName = this.getRelTypeName((RelationshipMappingAnnotation)an, relJRA)).equals(jpt.getName())) {
                    JavaAttributeMapping mp = relEntAt.getMapping();
                    if (mp.getMappingAnnotation() == null) {
                        JpaArtifactFactory.instance().refreshEntityModel(null, (JavaPersistentType)relEntAt.getParent());
                        mp = relEntAt.getMapping();
                    }
                    if (OwnableRelationshipMappingAnnotation.class.isInstance(mp.getMappingAnnotation())) {
                        String mappedBy = ((OwnableRelationshipMappingAnnotation)mp.getMappingAnnotation()).getMappedBy();
                        if (jpa.getName().equals(mappedBy)) {
                            Hashtable<JavaPersistentAttribute, Annotation> ht = new Hashtable<JavaPersistentAttribute, Annotation>();
                            ht.put(relEntAt, an);
                            return ht;
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private UnidirectionalRelation produceUniDirRelation(JavaPersistentType jpt, JavaPersistentAttribute at, Annotation an, JavaPersistentType relJPT, IJPAEditorFeatureProvider fp) {
        if (this.isNonOwner(at) || !JPAEditorUtil.getCompilationUnit((JavaPersistentType)at.getParent()).exists()) {
            return null;
        }
        String annotationName = JPAEditorUtil.returnSimpleName(an.getAnnotationName());
        UnidirectionalRelation res = null;
        String attrName = at.getName();
        if (annotationName.equals("OneToOne")) {
            if (!fp.doesRelationExist(jpt, relJPT, attrName, IRelation.RelType.ONE_TO_ONE, IRelation.RelDir.UNI)) {
                res = new OneToOneUniDirRelation(fp, jpt, relJPT, attrName, false, fp.getCompilationUnit(jpt), fp.getCompilationUnit(relJPT));
            }
        } else if (annotationName.equals("OneToMany")) {
            if (!fp.doesRelationExist(jpt, relJPT, attrName, IRelation.RelType.ONE_TO_MANY, IRelation.RelDir.UNI)) {
                res = new OneToManyUniDirRelation(fp, jpt, relJPT, attrName, false, fp.getCompilationUnit(jpt), fp.getCompilationUnit(relJPT));
            }
        } else if (annotationName.equals("ManyToOne")) {
            if (!fp.doesRelationExist(jpt, relJPT, attrName, IRelation.RelType.MANY_TO_ONE, IRelation.RelDir.UNI)) {
                res = new ManyToOneUniDirRelation(fp, jpt, relJPT, attrName, false, fp.getCompilationUnit(jpt), fp.getCompilationUnit(relJPT));
            }
        } else if (annotationName.equals("ManyToMany") && !fp.doesRelationExist(jpt, relJPT, attrName, IRelation.RelType.MANY_TO_MANY, IRelation.RelDir.UNI)) {
            res = new ManyToManyUniDirRelation(fp, jpt, relJPT, attrName, false, fp.getCompilationUnit(jpt), fp.getCompilationUnit(relJPT));
        }
        if (res != null) {
            res.setAnnotatedAttribute(at);
        }
        return res;
    }

    private BidirectionalRelation produceBiDirRelation(JavaPersistentType jpt, JavaPersistentAttribute at, Annotation an, JavaPersistentType relJPT, JavaPersistentAttribute relAt, Annotation relAn, IJPAEditorFeatureProvider fp) {
        JpaArtifactFactory.instance().refreshEntityModel(null, (JavaPersistentType)relAt.getParent());
        String annotationName = JPAEditorUtil.returnSimpleName(an.getAnnotationName());
        String relAnnotationName = JPAEditorUtil.returnSimpleName(relAn.getAnnotationName());
        if (!this.annotationNamesMatch(annotationName, relAnnotationName)) {
            return null;
        }
        if (annotationName.equals("OneToMany")) {
            return this.produceBiDirRelation(relJPT, relAt, relAn, jpt, at, an, fp);
        }
        if (this.isNonOwner(at) && this.isNonOwner(relAt)) {
            return null;
        }
        if (annotationName.equals("ManyToOne") && (this.isNonOwner(at) || !this.isNonOwner(relAt))) {
            return null;
        }
        if (annotationName.equals("ManyToMany")) {
            if (!this.isNonOwner(at) && !this.isNonOwner(relAt)) {
                return null;
            }
            if (this.isNonOwner(at)) {
                return this.produceBiDirRelation(relJPT, relAt, relAn, jpt, at, an, fp);
            }
        }
        String ownerAttrName = at.getName();
        String inverseAttrName = relAt.getName();
        JavaAttributeMapping m = relAt.getMapping();
        if (m != null) {
            if (m.getMappingAnnotation() == null) {
                JpaArtifactFactory.instance().refreshEntityModel(null, (JavaPersistentType)relAt.getParent());
                m = relAt.getMapping();
            }
            if (m.getMappingAnnotation() instanceof OwnableRelationshipMappingAnnotation) {
                String mappedBy = ((OwnableRelationshipMappingAnnotation)m.getMappingAnnotation()).getMappedBy();
                if (mappedBy == null) {
                    return null;
                }
                if (!mappedBy.equals(ownerAttrName)) {
                    return null;
                }
            }
        }
        BidirectionalRelation res = null;
        if (annotationName.equals("OneToOne")) {
            if (!fp.doesRelationExist(jpt, relJPT, ownerAttrName, IRelation.RelType.ONE_TO_ONE, IRelation.RelDir.BI)) {
                res = new OneToOneBiDirRelation(fp, jpt, relJPT, ownerAttrName, inverseAttrName, false, fp.getCompilationUnit(jpt), fp.getCompilationUnit(relJPT));
            }
        } else if (annotationName.equals("ManyToOne")) {
            if (!fp.doesRelationExist(jpt, relJPT, ownerAttrName, IRelation.RelType.MANY_TO_ONE, IRelation.RelDir.BI)) {
                res = new ManyToOneBiDirRelation(fp, jpt, relJPT, ownerAttrName, inverseAttrName, false, fp.getCompilationUnit(jpt), fp.getCompilationUnit(relJPT));
            }
        } else if (annotationName.equals("ManyToMany") && !fp.doesRelationExist(jpt, relJPT, ownerAttrName, IRelation.RelType.MANY_TO_MANY, IRelation.RelDir.BI)) {
            res = new ManyToManyBiDirRelation(fp, jpt, relJPT, ownerAttrName, inverseAttrName, false, fp.getCompilationUnit(jpt), fp.getCompilationUnit(relJPT));
        }
        if (res != null) {
            res.setOwnerAnnotatedAttribute(at);
            res.setInverseAnnotatedAttribute(relAt);
        }
        return res;
    }

    private boolean annotationNamesMatch(String an1Name, String an2Name) {
        if (an1Name.equals("OneToOne") && an2Name.equals("OneToOne")) {
            return true;
        }
        if (an1Name.equals("OneToMany") && an2Name.equals("ManyToOne")) {
            return true;
        }
        if (an1Name.equals("ManyToOne") && an2Name.equals("OneToMany")) {
            return true;
        }
        return an1Name.equals("ManyToMany") && an2Name.equals("ManyToMany");
    }

    private String genGetterContents(String attrName, String attrType, String[] attrTypeElementNames, String actName, List<String> annotations, boolean isCollection) {
        String attrNameWithCapitalA = String.valueOf(actName.substring(0, 1).toUpperCase(Locale.ENGLISH)) + actName.substring(1);
        String contents = "";
        if (annotations != null) {
            for (String an : annotations) {
                contents = String.valueOf(contents) + "   " + an + "\n";
            }
        }
        contents = isCollection ? String.valueOf(contents) + "    public Collection<" + attrType + "> get" + attrNameWithCapitalA + "() {\n" + "        return " + JPAEditorUtil.decapitalizeFirstLetter(actName) + ";\n" + "    }\n" : String.valueOf(contents) + "    public " + attrType + (attrTypeElementNames == null ? "" : "<" + JPAEditorUtil.createCommaSeparatedListOfSimpleTypeNames(attrTypeElementNames) + ">") + (attrType.equals("boolean") ? " is" : " get") + attrNameWithCapitalA + "() {\n" + "        return " + JPAEditorUtil.decapitalizeFirstLetter(actName) + ";\n" + "    }\n";
        return contents;
    }

    private String genSetterContents(String attrName, String attrType, String[] attrTypeElementNames, String actName, boolean isCollection) {
        String attrNameWithCapitalA = String.valueOf(actName.substring(0, 1).toUpperCase(Locale.ENGLISH)) + actName.substring(1);
        String contents = "";
        contents = isCollection ? "    public void set" + attrNameWithCapitalA + "(Collection<" + attrType + "> param) " + "{\n" + "        this." + JPAEditorUtil.decapitalizeFirstLetter(actName) + " = param;\n" + "    }\n" : "    public void set" + attrNameWithCapitalA + "(" + attrType + (attrTypeElementNames == null ? "" : "<" + JPAEditorUtil.createCommaSeparatedListOfSimpleTypeNames(attrTypeElementNames) + ">") + " param) {\n" + "        this." + JPAEditorUtil.decapitalizeFirstLetter(actName) + " = param;\n" + "    }\n";
        return contents;
    }

    private String genGetterWithAppropriateType(String attrName, String attrType, String actName, String type) {
        return this.genGetterWithAppropriateType(attrName, null, attrType, actName, type);
    }

    private String genGetterWithAppropriateType(String attrName, String mapKeyType, String attrType, String actName, String type) {
        String attrNameWithCapitalA = String.valueOf(actName.substring(0, 1).toUpperCase(Locale.ENGLISH)) + actName.substring(1);
        String contents = "    public " + JPAEditorUtil.returnSimpleName(type) + "<" + (mapKeyType != null ? String.valueOf(mapKeyType) + ", " : "") + attrType + "> " + "get" + attrNameWithCapitalA + "() {\n" + "        return " + JPAEditorUtil.decapitalizeFirstLetter(actName) + ";\n" + "    }\n";
        return contents;
    }

    private String genSetterWithAppropriateType(String attrName, String attrType, String actName, String type) {
        return this.genSetterWithAppropriateType(attrName, null, attrType, actName, type);
    }

    private String genSetterWithAppropriateType(String attrName, String mapKeyType, String attrType, String actName, String type) {
        String attrNameWithCapitalA = String.valueOf(actName.substring(0, 1).toUpperCase(Locale.ENGLISH)) + actName.substring(1);
        String contents = "    public void set" + attrNameWithCapitalA + "(" + JPAEditorUtil.returnSimpleName(type) + "<" + (mapKeyType != null ? String.valueOf(mapKeyType) + ", " : "") + attrType + "> param) " + "{\n" + "        this." + JPAEditorUtil.decapitalizeFirstLetter(actName) + " = param;\n" + "    }\n";
        return contents;
    }

    private JavaPersistentAttribute getAttributeFromEntity(JavaPersistentType jpt, String attributeName) {
        this.refreshEntityModel(null, jpt);
        JavaPersistentAttribute at = jpt.getAttributeNamed(attributeName);
        if (at == null) {
            jpt.getJavaResourceType().synchronizeWith(jpt.getJavaResourceType().getJavaResourceCompilationUnit().buildASTRoot());
            jpt.update();
        }
        int c = 0;
        while (at == null && c < 25) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Cannot get the attribute " + attributeName + " from " + jpt.getName(), e);
            }
            at = jpt.getAttributeNamed(attributeName);
            ++c;
        }
        return at;
    }

    private boolean doesAttributeExist(JavaPersistentType jpt, String name) throws JavaModelException {
        boolean exists = false;
        if (jpt.resolveAttribute(name) != null) {
            return true;
        }
        return exists;
    }

    public JavaResourceType convertJPTToJRT(JavaPersistentType jpt) {
        if (jpt == null) {
            return null;
        }
        return (JavaResourceType)jpt.getJpaProject().getJavaResourceType(jpt.getName(), JavaResourceAnnotatedElement.Kind.TYPE);
    }

    public PersistenceUnit getPersistenceUnit(JpaFile jpaFile) {
        JpaProject jpaProject = jpaFile.getJpaProject();
        if (jpaProject == null) {
            return null;
        }
        return this.getPersistenceUnit(jpaProject);
    }

    public PersistenceUnit getPersistenceUnit(JpaProject project) {
        if (project.getRootContextNode().getPersistenceXml() == null) {
            return null;
        }
        return (PersistenceUnit)project.getRootContextNode().getPersistenceXml().getPersistence().getPersistenceUnits().iterator().next();
    }

    public PersistenceUnit getPersistenceUnit(JavaPersistentType jpt) {
        return jpt.getPersistenceUnit();
    }

    public boolean isMethodAnnotated(JavaPersistentAttribute attr) {
        return attr.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD;
    }

    public boolean isMethodAnnotated(JavaPersistentType jpt) {
        ListIterator li = jpt.getAttributes().iterator();
        if (!li.hasNext()) {
            return false;
        }
        return this.isMethodAnnotated((JavaPersistentAttribute)li.next());
    }

    public void remakeRelations(IJPAEditorFeatureProvider fp, ContainerShape cs, JavaPersistentType jpt) {
        if (cs == null) {
            cs = (ContainerShape)fp.getPictogramElementForBusinessObject(jpt);
        }
        if (cs == null) {
            return;
        }
        this.removeOldRelations(fp, cs);
        this.addNewRelations(fp, jpt);
    }

    public String getTableName(JavaPersistentType jpt) {
        if (jpt == null) {
            return null;
        }
        JavaResourceType jrt = this.convertJPTToJRT(jpt);
        if (jrt == null) {
            return null;
        }
        TableAnnotation tan = (TableAnnotation)jrt.getAnnotation("javax.persistence.Table");
        String tableName = null;
        tableName = tan == null ? JPAEditorUtil.returnSimpleName(jpt.getName()) : tan.getName();
        if (tableName == null) {
            tableName = JPAEditorUtil.returnSimpleName(jpt.getName());
        }
        return tableName;
    }

    public void setTableName(JavaPersistentType jpt, String tableName) {
        if (jpt == null) {
            return;
        }
        JavaResourceType jrt = this.convertJPTToJRT(jpt);
        if (jrt == null) {
            return;
        }
        TableAnnotation ta = (TableAnnotation)jrt.getAnnotation("javax.persistence.Table");
        if (ta != null) {
            ta.setName(tableName);
        }
    }

    private void removeOldRelations(IJPAEditorFeatureProvider fp, ContainerShape cs) {
        HashSet<RemoveContext> ctxs = new HashSet<RemoveContext>();
        for (Connection conn : Graphiti.getPeService().getAllConnections((AnchorContainer)cs)) {
            RemoveContext ctx = new RemoveContext((PictogramElement)conn);
            ctxs.add(ctx);
        }
        for (RemoveContext ctx : ctxs) {
            RemoveRelationFeature ft = new RemoveRelationFeature(fp);
            ft.remove((IRemoveContext)ctx);
        }
    }

    private void addNewRelations(IJPAEditorFeatureProvider fp, JavaPersistentType jpt) {
        HashSet<IRelation> selfRels = new HashSet<IRelation>();
        Collection<IRelation> newRels = JpaArtifactFactory.instance().produceAllRelations(jpt, fp);
        for (IRelation rel : newRels) {
            if (rel.getOwner() == rel.getInverse()) {
                selfRels.add(rel);
                continue;
            }
            this.addNewRelation(fp, rel);
        }
        for (IRelation rel : selfRels) {
            this.addNewRelation(fp, rel);
        }
    }

    private void addNewRelation(IJPAEditorFeatureProvider fp, IRelation rel) {
        AddConnectionContext ctx = new AddConnectionContext(JPAEditorUtil.getAnchor(rel.getOwner(), fp), JPAEditorUtil.getAnchor(rel.getInverse(), fp));
        ctx.setNewObject((Object)rel);
        ctx.setTargetContainer((ContainerShape)fp.getDiagramTypeProvider().getDiagram());
        this.refreshEntityModel(fp, rel.getOwner());
        this.refreshEntityModel(fp, rel.getInverse());
        AddRelationFeature ft = new AddRelationFeature(fp);
        ft.add((IAddContext)ctx);
    }

    private String getRelTypeName(RelationshipMappingAnnotation an, JavaResourceAttribute jra) {
        String relTypeName = null;
        try {
            boolean isMap = jra.getTypeName().equals(MAP_TYPE);
            relTypeName = jra.getTypeTypeArgumentName(isMap ? 1 : 0);
        }
        catch (Exception exception) {}
        if (relTypeName == null) {
            relTypeName = an.getFullyQualifiedTargetEntityClassName();
        }
        if (relTypeName == null) {
            relTypeName = JPAEditorUtil.getAttributeTypeName(jra);
        }
        return relTypeName;
    }

    public JpaProject getJpaProject(IProject project) throws CoreException {
        return JptJpaCorePlugin.getJpaProject((IProject)project);
    }

    public String getIdType(JavaPersistentType jpt) {
        IdClassAnnotation an = (IdClassAnnotation)jpt.getJavaResourceType().getAnnotation("javax.persistence.IdClass");
        if (an != null) {
            return an.getFullyQualifiedClassName();
        }
        JavaPersistentAttribute[] ids = this.getIds(jpt);
        if (ids.length == 0) {
            return null;
        }
        String type = ids[0].getTypeName();
        String wrapper = JPAEditorUtil.getPrimitiveWrapper(type);
        return wrapper != null ? wrapper : type;
    }

    public JavaPersistentAttribute[] getIds(JavaPersistentType jpt) {
        ArrayList<JavaPersistentAttribute> res = new ArrayList<JavaPersistentAttribute>();
        for (JavaPersistentAttribute at : jpt.getAttributes()) {
            if (!this.isId(at)) continue;
            res.add(at);
        }
        JavaPersistentAttribute[] ret = new JavaPersistentAttribute[res.size()];
        return res.toArray(ret);
    }

    public boolean isId(JavaPersistentAttribute jpa) {
        return this.isSimpleId(jpa) || this.isEmbeddedId(jpa);
    }

    public boolean isSimpleId(JavaPersistentAttribute jpa) {
        IdAnnotation an = (IdAnnotation)jpa.getResourceAttribute().getAnnotation("javax.persistence.Id");
        return an != null;
    }

    public boolean isEmbeddedId(JavaPersistentAttribute jpa) {
        EmbeddedIdAnnotation an = (EmbeddedIdAnnotation)jpa.getResourceAttribute().getAnnotation("javax.persistence.EmbeddedId");
        return an != null;
    }

    public String getColumnName(JavaPersistentAttribute jpa) {
        String columnName = null;
        ColumnAnnotation an = (ColumnAnnotation)jpa.getResourceAttribute().getAnnotation("javax.persistence.Column");
        if (an != null) {
            columnName = an.getName();
        }
        if (columnName == null) {
            columnName = jpa.getName();
        }
        return columnName;
    }
}

