/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.SequenceGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaSequenceGenerator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaGenerator;
import org.eclipse.jpt.jpa.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.jpa.db.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaSequenceGenerator<A extends SequenceGeneratorAnnotation>
extends AbstractJavaGenerator<A>
implements JavaSequenceGenerator {
    protected String specifiedSequenceName;
    protected String defaultSequenceName;

    protected AbstractJavaSequenceGenerator(JavaJpaContextNode parent, A generatorAnnotation) {
        super(parent, generatorAnnotation);
        this.specifiedSequenceName = generatorAnnotation.getSequenceName();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedSequenceName_(((SequenceGeneratorAnnotation)this.generatorAnnotation).getSequenceName());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultSequenceName(this.buildDefaultSequenceName());
    }

    @Override
    protected int buildDefaultInitialValue() {
        return 1;
    }

    @Override
    public String getSequenceName() {
        return this.specifiedSequenceName != null ? this.specifiedSequenceName : this.defaultSequenceName;
    }

    @Override
    public String getSpecifiedSequenceName() {
        return this.specifiedSequenceName;
    }

    @Override
    public void setSpecifiedSequenceName(String name) {
        ((SequenceGeneratorAnnotation)this.generatorAnnotation).setSequenceName(name);
        this.setSpecifiedSequenceName_(name);
    }

    protected void setSpecifiedSequenceName_(String name) {
        String old = this.specifiedSequenceName;
        this.specifiedSequenceName = name;
        this.firePropertyChanged("specifiedSequenceName", old, name);
    }

    @Override
    public String getDefaultSequenceName() {
        return this.defaultSequenceName;
    }

    protected void setDefaultSequenceName(String name) {
        String old = this.defaultSequenceName;
        this.defaultSequenceName = name;
        this.firePropertyChanged("defaultSequenceName", old, name);
    }

    protected String buildDefaultSequenceName() {
        return null;
    }

    @Override
    protected Iterable<String> getConnectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getConnectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.sequenceNameTouches(pos, astRoot)) {
            return this.getJavaCandidateSequences(filter);
        }
        return null;
    }

    protected boolean sequenceNameTouches(int pos, CompilationUnit astRoot) {
        return ((SequenceGeneratorAnnotation)this.generatorAnnotation).sequenceNameTouches(pos, astRoot);
    }

    protected Iterable<String> getJavaCandidateSequences(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateSequences(filter));
    }

    protected Iterable<String> getCandidateSequences(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateSequences(), filter);
    }

    protected Iterable<String> getCandidateSequences() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedSequenceIdentifiers() : EmptyIterable.instance();
    }

    public Class<SequenceGenerator> getType() {
        return SequenceGenerator.class;
    }

    @Override
    public boolean isIdentical(Generator generator) {
        return super.isIdentical(generator) && StringTools.stringsAreEqual((String)this.getSpecifiedSequenceName(), (String)((SequenceGenerator)generator).getSpecifiedSequenceName());
    }
}

