/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyReferenceTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.VirtualReferenceTable;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualJoinColumn;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaVirtualTable;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaVirtualReferenceTable<T extends ReadOnlyReferenceTable>
extends AbstractJavaVirtualTable<T>
implements VirtualReferenceTable {
    protected final AbstractJpaNode.ContextListContainer<JavaVirtualJoinColumn, ReadOnlyJoinColumn> specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    protected final JavaReadOnlyJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();
    protected JavaVirtualJoinColumn defaultJoinColumn;

    protected AbstractJavaVirtualReferenceTable(JavaJpaContextNode parent, ReadOnlyTable.Owner owner, T overridenTable) {
        super(parent, owner, overridenTable);
    }

    @Override
    public void update() {
        super.update();
        this.updateSpecifiedJoinColumns();
        this.updateDefaultJoinColumn();
    }

    public ListIterable<JavaVirtualJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    public ListIterable<JavaVirtualJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer.getContextElements();
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.getContextElementsSize();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public JavaVirtualJoinColumn getSpecifiedJoinColumn(int index) {
        return this.specifiedJoinColumnContainer.getContextElement(index);
    }

    protected void updateSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.update();
    }

    protected ListIterable<ReadOnlyJoinColumn> getOverriddenJoinColumns() {
        return new SuperListIterableWrapper(((ReadOnlyReferenceTable)this.getOverriddenTable()).getSpecifiedJoinColumns());
    }

    protected void moveSpecifiedJoinColumn(int index, JavaVirtualJoinColumn joinColumn) {
        this.specifiedJoinColumnContainer.moveContextElement(index, joinColumn);
    }

    protected JavaVirtualJoinColumn addSpecifiedJoinColumn(int index, JoinColumn joinColumn) {
        return (JavaVirtualJoinColumn)this.specifiedJoinColumnContainer.addContextElement(index, joinColumn);
    }

    protected void removeSpecifiedJoinColumn(JavaVirtualJoinColumn joinColumn) {
        this.specifiedJoinColumnContainer.removeContextElement(joinColumn);
    }

    protected AbstractJpaNode.ContextListContainer<JavaVirtualJoinColumn, ReadOnlyJoinColumn> buildSpecifiedJoinColumnContainer() {
        return new SpecifiedJoinColumnContainer();
    }

    @Override
    public JavaVirtualJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaVirtualJoinColumn joinColumn) {
        JavaVirtualJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<JavaVirtualJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(((ReadOnlyReferenceTable)this.getOverriddenTable()).getDefaultJoinColumn()));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns();
    }

    protected JavaVirtualJoinColumn buildJoinColumn(ReadOnlyJoinColumn joinColumn) {
        return this.buildJoinColumn(this.joinColumnOwner, joinColumn);
    }

    protected JavaVirtualJoinColumn buildJoinColumn(JavaReadOnlyJoinColumn.Owner columnOwner, ReadOnlyJoinColumn joinColumn) {
        return this.getJpaFactory().buildJavaVirtualJoinColumn(this, columnOwner, joinColumn);
    }

    protected abstract JavaReadOnlyJoinColumn.Owner buildJoinColumnOwner();

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        boolean continueValidating = this.buildTableValidator(astRoot).validate(messages, reporter);
        if (continueValidating) {
            this.validateJoinColumns(messages, reporter, astRoot);
        }
    }

    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.validateNodes((Iterable<? extends JavaJpaContextNode>)this.getJoinColumns(), messages, reporter, astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedJoinColumnContainer
    extends AbstractJpaNode.ContextListContainer<JavaVirtualJoinColumn, ReadOnlyJoinColumn> {
        protected SpecifiedJoinColumnContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedJoinColumns";
        }

        @Override
        protected JavaVirtualJoinColumn buildContextElement(ReadOnlyJoinColumn resourceElement) {
            return AbstractJavaVirtualReferenceTable.this.buildJoinColumn(resourceElement);
        }

        @Override
        protected ListIterable<ReadOnlyJoinColumn> getResourceElements() {
            return AbstractJavaVirtualReferenceTable.this.getOverriddenJoinColumns();
        }

        @Override
        protected ReadOnlyJoinColumn getResourceElement(JavaVirtualJoinColumn contextElement) {
            return contextElement.getOverriddenColumn();
        }
    }
}

