/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmGeneratedValue;
import org.eclipse.jpt.jpa.core.context.orm.OrmGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTemporalConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlContextNodeFactory;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TableColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.NamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.NullOrmConverter;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.IdMapping2_0;
import org.eclipse.jpt.jpa.core.resource.orm.Attributes;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlGeneratedValue;
import org.eclipse.jpt.jpa.core.resource.orm.XmlGeneratorContainer;
import org.eclipse.jpt.jpa.core.resource.orm.XmlId;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmIdMapping<X extends XmlId>
extends AbstractOrmAttributeMapping<X>
implements OrmIdMapping,
IdMapping2_0 {
    protected final OrmColumn column = this.buildColumn();
    protected final OrmGeneratorContainer generatorContainer = this.buildGeneratorContainer();
    protected OrmGeneratedValue generatedValue = this.buildGeneratedValue();
    protected OrmConverter converter = this.buildConverter();
    protected boolean derived;
    protected static final OrmConverter.Adapter[] CONVERTER_ADAPTER_ARRAY = new OrmConverter.Adapter[]{OrmTemporalConverter.BasicAdapter.instance()};
    protected static final Iterable<OrmConverter.Adapter> CONVERTER_ADAPTERS = new ArrayIterable((Object[])CONVERTER_ADAPTER_ARRAY);

    protected AbstractOrmIdMapping(OrmPersistentAttribute parent, X xmlMapping) {
        super(parent, xmlMapping);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.column.synchronizeWithResourceModel();
        this.generatorContainer.synchronizeWithResourceModel();
        this.syncGeneratedValue();
        this.syncConverter();
    }

    @Override
    public void update() {
        super.update();
        this.column.update();
        this.generatorContainer.update();
        if (this.generatedValue != null) {
            this.generatedValue.update();
        }
        this.converter.update();
        this.setDerived(this.buildDerived());
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    protected OrmColumn buildColumn() {
        return this.getContextNodeFactory().buildOrmColumn(this, this);
    }

    @Override
    public OrmGeneratorContainer getGeneratorContainer() {
        return this.generatorContainer;
    }

    protected OrmGeneratorContainer buildGeneratorContainer() {
        return this.getContextNodeFactory().buildOrmGeneratorContainer(this, (XmlGeneratorContainer)((Object)this.xmlAttributeMapping));
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return this.generatorContainer.getGenerators();
    }

    @Override
    public OrmGeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }

    @Override
    public OrmGeneratedValue addGeneratedValue() {
        if (this.generatedValue != null) {
            throw new IllegalStateException("generated value already exists: " + this.generatedValue);
        }
        XmlGeneratedValue xmlGeneratedValue = this.buildXmlGeneratedValue();
        OrmGeneratedValue value = this.buildGeneratedValue(xmlGeneratedValue);
        this.setGeneratedValue(value);
        ((XmlId)this.xmlAttributeMapping).setGeneratedValue(xmlGeneratedValue);
        return value;
    }

    protected XmlGeneratedValue buildXmlGeneratedValue() {
        return OrmFactory.eINSTANCE.createXmlGeneratedValue();
    }

    @Override
    public void removeGeneratedValue() {
        if (this.generatedValue == null) {
            throw new IllegalStateException("generated value does not exist");
        }
        this.setGeneratedValue(null);
        ((XmlId)this.xmlAttributeMapping).setGeneratedValue(null);
    }

    protected void setGeneratedValue(OrmGeneratedValue value) {
        OrmGeneratedValue old = this.generatedValue;
        this.generatedValue = value;
        this.firePropertyChanged("generatedValue", old, value);
    }

    protected OrmGeneratedValue buildGeneratedValue() {
        XmlGeneratedValue xmlGeneratedValue = ((XmlId)this.xmlAttributeMapping).getGeneratedValue();
        return xmlGeneratedValue == null ? null : this.buildGeneratedValue(xmlGeneratedValue);
    }

    protected OrmGeneratedValue buildGeneratedValue(XmlGeneratedValue xmlGeneratedValue) {
        return this.getContextNodeFactory().buildOrmGeneratedValue(this, xmlGeneratedValue);
    }

    protected void syncGeneratedValue() {
        XmlGeneratedValue xmlGeneratedValue = ((XmlId)this.xmlAttributeMapping).getGeneratedValue();
        if (xmlGeneratedValue == null) {
            if (this.generatedValue != null) {
                this.setGeneratedValue(null);
            }
        } else if (this.generatedValue != null && this.generatedValue.getXmlGeneratedValue() == xmlGeneratedValue) {
            this.generatedValue.synchronizeWithResourceModel();
        } else {
            this.setGeneratedValue(this.buildGeneratedValue(xmlGeneratedValue));
        }
    }

    @Override
    public OrmConverter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(Class<? extends Converter> converterType) {
        if (this.converter.getType() != converterType) {
            this.clearXmlConverterValues();
            OrmConverter.Adapter converterAdapter = this.getConverterAdapter(converterType);
            this.setConverter_(this.buildConverter(converterAdapter));
            this.converter.initialize();
        }
    }

    protected OrmConverter buildConverter(OrmConverter.Adapter converterAdapter) {
        return converterAdapter != null ? converterAdapter.buildNewConverter(this, this.getContextNodeFactory()) : this.buildNullConverter();
    }

    protected void setConverter_(OrmConverter converter) {
        OrmConverter old = this.converter;
        this.converter = converter;
        this.firePropertyChanged("converter", old, converter);
    }

    protected void clearXmlConverterValues() {
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            adapter.clearXmlValue(this.xmlAttributeMapping);
        }
    }

    protected OrmConverter buildConverter() {
        OrmXmlContextNodeFactory factory = this.getContextNodeFactory();
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            OrmConverter ormConverter = adapter.buildConverter(this, factory);
            if (ormConverter == null) continue;
            return ormConverter;
        }
        return this.buildNullConverter();
    }

    protected void syncConverter() {
        OrmConverter.Adapter adapter = this.getXmlConverterAdapter();
        if (adapter == null) {
            if (this.converter.getType() != null) {
                this.setConverter_(this.buildNullConverter());
            }
        } else if (this.converter.getType() == adapter.getConverterType()) {
            this.converter.synchronizeWithResourceModel();
        } else {
            this.setConverter_(adapter.buildNewConverter(this, this.getContextNodeFactory()));
        }
    }

    protected OrmConverter.Adapter getXmlConverterAdapter() {
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            if (!adapter.isActive(this.xmlAttributeMapping)) continue;
            return adapter;
        }
        return null;
    }

    protected OrmConverter buildNullConverter() {
        return new NullOrmConverter(this);
    }

    protected OrmConverter.Adapter getConverterAdapter(Class<? extends Converter> converterType) {
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter.getConverterType() != converterType) continue;
            return adapter;
        }
        return null;
    }

    protected Iterable<OrmConverter.Adapter> getConverterAdapters() {
        return CONVERTER_ADAPTERS;
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    protected void setDerived(boolean derived) {
        boolean old = this.derived;
        this.derived = derived;
        this.firePropertyChanged("derived", old, derived);
    }

    protected boolean buildDerived() {
        return this.isJpa2_0Compatible() && this.buildDerived_();
    }

    protected boolean buildDerived_() {
        return this.getTypeMapping().attributeIsDerivedId(this.name);
    }

    @Override
    public String getKey() {
        return "id";
    }

    @Override
    public int getXmlSequence() {
        return 0;
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmIdMapping(this);
    }

    @Override
    protected void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromOrmColumnMapping(oldMapping);
        this.column.initializeFrom(oldMapping.getColumn());
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.column.getName();
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public void addXmlAttributeMappingTo(Attributes resourceAttributes) {
        resourceAttributes.getIds().add((Object)((XmlId)this.xmlAttributeMapping));
    }

    @Override
    public void removeXmlAttributeMappingFrom(Attributes resourceAttributes) {
        resourceAttributes.getIds().remove((Object)this.xmlAttributeMapping);
    }

    @Override
    public String getDefaultColumnName(ReadOnlyNamedColumn column) {
        return this.derived && !this.isColumnSpecified() ? null : this.name;
    }

    @Override
    public String getDefaultTableName() {
        return this.derived && !this.isColumnSpecified() ? null : this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return this.getTypeMapping().resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public Iterable<String> getCandidateTableNames() {
        return this.getTypeMapping().getAllAssociatedTableNames();
    }

    @Override
    public XmlColumn getXmlColumn() {
        return ((XmlId)this.xmlAttributeMapping).getColumn();
    }

    @Override
    public XmlColumn buildXmlColumn() {
        XmlColumn xmlColumn = OrmFactory.eINSTANCE.createXmlColumn();
        ((XmlId)this.xmlAttributeMapping).setColumn(xmlColumn);
        return xmlColumn;
    }

    @Override
    public void removeXmlColumn() {
        ((XmlId)this.xmlAttributeMapping).setColumn(null);
    }

    protected boolean isColumnSpecified() {
        return this.getXmlColumn() != null;
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return new CompositeIterable(new Iterable[]{super.createRenameTypeEdits(originalType, newName), this.createConverterRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createConverterRenameTypeEdits(IType originalType, String newName) {
        return this.converter != null ? this.converter.createRenameTypeEdits(originalType, newName) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return new CompositeIterable(new Iterable[]{super.createMoveTypeEdits(originalType, newPackage), this.createConverterMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createConverterMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.converter != null ? this.converter.createMoveTypeEdits(originalType, newPackage) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return new CompositeIterable(new Iterable[]{super.createRenamePackageEdits(originalPackage, newName), this.createConverterRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createConverterRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.converter != null ? this.converter.createRenamePackageEdits(originalPackage, newName) : EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.isColumnSpecified() || !this.derived) {
            this.column.validate(messages, reporter);
        }
        if (this.isColumnSpecified() && this.derived) {
            messages.add(this.buildColumnSpecifiedAndDerivedMessage());
        }
        if (this.generatedValue != null) {
            this.generatedValue.validate(messages, reporter);
        }
        this.generatorContainer.validate(messages, reporter);
        this.converter.validate(messages, reporter);
    }

    protected IMessage buildColumnSpecifiedAndDerivedMessage() {
        return this.buildMessage("ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_COLUMN_SPECIFIED", EMPTY_STRING_ARRAY, this.column.getValidationTextRange());
    }

    protected IMessage buildMessage(String msgID, String[] parms, TextRange textRange) {
        return DefaultJpaValidationMessages.buildMessage(1, msgID, (String[])ArrayTools.add((Object[])parms, (int)0, (Object)this.buildAttributeDescription()), this, textRange);
    }

    protected String buildAttributeDescription() {
        return NLS.bind((String)this.getAttributeDescriptionTemplate(), (Object)this.getPersistentAttribute().getName());
    }

    protected String getAttributeDescriptionTemplate() {
        return JpaValidationDescriptionMessages.ATTRIBUTE_DESC;
    }

    @Override
    public JptValidator buildColumnValidator(ReadOnlyNamedColumn col, NamedColumnTextRangeResolver textRangeResolver) {
        return new NamedColumnValidator((ReadOnlyPersistentAttribute)this.getPersistentAttribute(), (ReadOnlyBaseColumn)col, (TableColumnTextRangeResolver)textRangeResolver, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
    }
}

