/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.QueryHint;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlQuery;
import org.eclipse.jpt.jpa.core.resource.orm.XmlQueryHint;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmQuery<X extends XmlQuery>
extends AbstractOrmXmlContextNode
implements OrmQuery {
    protected final X xmlQuery;
    protected String name;
    protected String query;
    protected final AbstractJpaNode.ContextListContainer<OrmQueryHint, XmlQueryHint> queryHintContainer;

    protected AbstractOrmQuery(XmlContextNode parent, X xmlQuery) {
        super(parent);
        this.xmlQuery = xmlQuery;
        this.name = xmlQuery.getName();
        this.query = this.getUnescapedQuery();
        this.queryHintContainer = this.buildHintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.xmlQuery.getName());
        this.setQuery_(this.getUnescapedQuery());
        this.syncHints();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getHints());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName_(name);
        this.xmlQuery.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        this.setQuery_(query);
        this.xmlQuery.setQuery(query);
    }

    protected void setQuery_(String query) {
        String old = this.query;
        this.query = query;
        this.firePropertyChanged("query", old, query);
    }

    protected String getUnescapedQuery() {
        String queryString = this.xmlQuery.getQuery();
        if (StringTools.stringIsNotEmpty((String)queryString)) {
            queryString = ExpressionTools.unescape((CharSequence)queryString, (int[])new int[1]);
        }
        return queryString;
    }

    @Override
    public ListIterable<OrmQueryHint> getHints() {
        return this.queryHintContainer.getContextElements();
    }

    @Override
    public int getHintsSize() {
        return this.queryHintContainer.getContextElementsSize();
    }

    @Override
    public OrmQueryHint addHint() {
        return this.addHint(this.getHintsSize());
    }

    @Override
    public OrmQueryHint addHint(int index) {
        XmlQueryHint xmlHint = this.buildXmlQueryHint();
        OrmQueryHint hint = (OrmQueryHint)this.queryHintContainer.addContextElement(index, xmlHint);
        this.xmlQuery.getHints().add(index, (Object)xmlHint);
        return hint;
    }

    protected XmlQueryHint buildXmlQueryHint() {
        return OrmFactory.eINSTANCE.createXmlQueryHint();
    }

    @Override
    public void removeHint(QueryHint hint) {
        this.removeHint(this.queryHintContainer.indexOfContextElement((OrmQueryHint)hint));
    }

    @Override
    public void removeHint(int index) {
        this.queryHintContainer.removeContextElement(index);
        this.xmlQuery.getHints().remove(index);
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.queryHintContainer.moveContextElement(targetIndex, sourceIndex);
        this.xmlQuery.getHints().move(targetIndex, sourceIndex);
    }

    protected OrmQueryHint buildHint(XmlQueryHint xmlHint) {
        return this.getContextNodeFactory().buildOrmQueryHint(this, xmlHint);
    }

    protected void syncHints() {
        this.queryHintContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlQueryHint> getXmlHints() {
        return new LiveCloneListIterable(this.xmlQuery.getHints());
    }

    protected AbstractJpaNode.ContextListContainer<OrmQueryHint, XmlQueryHint> buildHintContainer() {
        HintContainer container = new HintContainer();
        container.initialize();
        return container;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateName(messages);
        this.validateQuery(messages, reporter);
    }

    protected void validateName(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_NAME_UNDEFINED", EMPTY_STRING_ARRAY, this, this.getNameTextRange()));
        }
    }

    protected void validateQuery(List<IMessage> messages, IReporter reporter) {
        if (StringTools.stringIsEmpty((String)this.query)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_STATEMENT_UNDEFINED", new String[]{this.name}, this, this.getNameTextRange()));
        } else {
            this.validateQuery_(messages, reporter);
        }
    }

    protected abstract void validateQuery_(List<IMessage> var1, IReporter var2);

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlQuery.getValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.xmlQuery.getNameTextRange());
    }

    @Override
    public TextRange getQueryTextRange() {
        return this.getValidationTextRange(this.xmlQuery.getQueryTextRange());
    }

    @Override
    public boolean isIdentical(Query query) {
        return StringTools.stringsAreEqual((String)this.getName(), (String)query.getName()) && StringTools.stringsAreEqual((String)this.getQuery(), (String)query.getQuery()) && this.hintsAreIdentical(query.getHints());
    }

    private boolean hintsAreIdentical(ListIterable<? extends QueryHint> hints) {
        boolean isIdentical = true;
        if (this.getHintsSize() != CollectionTools.size(hints)) {
            return false;
        }
        int i = 0;
        while (i < this.getHintsSize()) {
            if (!((OrmQueryHint)CollectionTools.get(this.getHints(), (int)i)).isIdentical((QueryHint)CollectionTools.get(hints, (int)i))) {
                isIdentical = false;
            }
            ++i;
        }
        return isIdentical;
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    public X getXmlQuery() {
        return this.xmlQuery;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HintContainer
    extends AbstractJpaNode.ContextListContainer<OrmQueryHint, XmlQueryHint> {
        protected HintContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "hints";
        }

        @Override
        protected OrmQueryHint buildContextElement(XmlQueryHint resourceElement) {
            return AbstractOrmQuery.this.buildHint(resourceElement);
        }

        @Override
        protected ListIterable<XmlQueryHint> getResourceElements() {
            return AbstractOrmQuery.this.getXmlHints();
        }

        @Override
        protected XmlQueryHint getResourceElement(OrmQueryHint contextElement) {
            return contextElement.getXmlQueryHint();
        }
    }
}

