/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.SequenceGenerator;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlSequenceGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmSequenceGenerator
extends AbstractOrmGenerator<XmlSequenceGenerator>
implements OrmSequenceGenerator {
    protected String specifiedSequenceName;
    protected String defaultSequenceName;

    protected AbstractOrmSequenceGenerator(XmlContextNode parent, XmlSequenceGenerator xmlSequenceGenerator) {
        super(parent, xmlSequenceGenerator);
        this.specifiedSequenceName = xmlSequenceGenerator.getSequenceName();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedSequenceName_(((XmlSequenceGenerator)this.xmlGenerator).getSequenceName());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultSequenceName(this.buildDefaultSequenceName());
    }

    @Override
    protected int buildDefaultInitialValue() {
        return 1;
    }

    @Override
    public String getSequenceName() {
        return this.specifiedSequenceName != null ? this.specifiedSequenceName : this.defaultSequenceName;
    }

    @Override
    public String getSpecifiedSequenceName() {
        return this.specifiedSequenceName;
    }

    @Override
    public void setSpecifiedSequenceName(String specifiedSequenceName) {
        this.setSpecifiedSequenceName_(specifiedSequenceName);
        ((XmlSequenceGenerator)this.xmlGenerator).setSequenceName(specifiedSequenceName);
    }

    protected void setSpecifiedSequenceName_(String specifiedSequenceName) {
        String old = this.specifiedSequenceName;
        this.specifiedSequenceName = specifiedSequenceName;
        this.firePropertyChanged("specifiedSequenceName", old, specifiedSequenceName);
    }

    @Override
    public String getDefaultSequenceName() {
        return this.defaultSequenceName;
    }

    protected void setDefaultSequenceName(String defaultSequenceName) {
        String old = this.defaultSequenceName;
        this.defaultSequenceName = defaultSequenceName;
        this.firePropertyChanged("defaultSequenceName", old, defaultSequenceName);
    }

    protected String buildDefaultSequenceName() {
        return null;
    }

    public Class<SequenceGenerator> getType() {
        return SequenceGenerator.class;
    }

    @Override
    public boolean isIdentical(Generator generator) {
        return super.isIdentical(generator) && StringTools.stringsAreEqual((String)this.getSpecifiedSequenceName(), (String)((SequenceGenerator)generator).getSpecifiedSequenceName());
    }
}

