/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualRelationship;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.JoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmVirtualReferenceTable;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmVirtualJoinTable
extends AbstractOrmVirtualReferenceTable<ReadOnlyJoinTable>
implements OrmVirtualJoinTable {
    protected final AbstractJpaNode.ContextListContainer<OrmVirtualJoinColumn, ReadOnlyJoinColumn> specifiedInverseJoinColumnContainer = this.buildSpecifiedInverseJoinColumnContainer();
    protected final OrmReadOnlyJoinColumn.Owner inverseJoinColumnOwner = this.buildInverseJoinColumnOwner();
    protected OrmVirtualJoinColumn defaultInverseJoinColumn;

    public GenericOrmVirtualJoinTable(OrmVirtualJoinTableRelationshipStrategy parent, ReadOnlyTable.Owner owner, ReadOnlyJoinTable overriddenTable) {
        super(parent, owner, overriddenTable);
    }

    @Override
    public void update() {
        super.update();
        this.updateSpecifiedInverseJoinColumns();
        this.updateDefaultInverseJoinColumn();
    }

    @Override
    public ListIterable<OrmVirtualJoinColumn> getInverseJoinColumns() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumns() : this.getDefaultInverseJoinColumns();
    }

    @Override
    public int getInverseJoinColumnsSize() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumnsSize() : this.getDefaultInverseJoinColumnsSize();
    }

    @Override
    public ListIterable<OrmVirtualJoinColumn> getSpecifiedInverseJoinColumns() {
        return this.specifiedInverseJoinColumnContainer.getContextElements();
    }

    @Override
    public int getSpecifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumnContainer.getContextElementsSize();
    }

    @Override
    public boolean hasSpecifiedInverseJoinColumns() {
        return this.getSpecifiedInverseJoinColumnsSize() != 0;
    }

    @Override
    public OrmVirtualJoinColumn getSpecifiedInverseJoinColumn(int index) {
        return this.specifiedInverseJoinColumnContainer.getContextElement(index);
    }

    protected void updateSpecifiedInverseJoinColumns() {
        this.specifiedInverseJoinColumnContainer.update();
    }

    protected ListIterable<ReadOnlyJoinColumn> getOverriddenInverseJoinColumns() {
        return new SuperListIterableWrapper(((ReadOnlyJoinTable)this.getOverriddenTable()).getSpecifiedInverseJoinColumns());
    }

    protected void moveSpecifiedInverseJoinColumn(int index, OrmVirtualJoinColumn joinColumn) {
        this.specifiedInverseJoinColumnContainer.moveContextElement(index, joinColumn);
    }

    protected OrmVirtualJoinColumn addSpecifiedInverseJoinColumn(int index, ReadOnlyJoinColumn joinColumn) {
        return (OrmVirtualJoinColumn)this.specifiedInverseJoinColumnContainer.addContextElement(index, joinColumn);
    }

    protected void removeSpecifiedInverseJoinColumn(OrmVirtualJoinColumn joinColumn) {
        this.specifiedInverseJoinColumnContainer.removeContextElement(joinColumn);
    }

    protected AbstractJpaNode.ContextListContainer<OrmVirtualJoinColumn, ReadOnlyJoinColumn> buildSpecifiedInverseJoinColumnContainer() {
        return new SpecifiedInverseJoinColumnContainer();
    }

    @Override
    public OrmVirtualJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(OrmVirtualJoinColumn joinColumn) {
        OrmVirtualJoinColumn old = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = joinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmVirtualJoinColumn> getDefaultInverseJoinColumns() {
        return this.defaultInverseJoinColumn != null ? new SingleElementListIterable((Object)this.defaultInverseJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultInverseJoinColumn() {
        if (this.buildsDefaultInverseJoinColumn()) {
            if (this.defaultInverseJoinColumn == null) {
                this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(((ReadOnlyJoinTable)this.getOverriddenTable()).getDefaultInverseJoinColumn()));
            } else {
                this.defaultInverseJoinColumn.update();
            }
        } else {
            this.setDefaultInverseJoinColumn(null);
        }
    }

    protected boolean buildsDefaultInverseJoinColumn() {
        return !this.hasSpecifiedInverseJoinColumns();
    }

    @Override
    public OrmVirtualJoinTableRelationshipStrategy getParent() {
        return (OrmVirtualJoinTableRelationshipStrategy)super.getParent();
    }

    protected OrmVirtualJoinTableRelationshipStrategy getRelationshipStrategy() {
        return this.getParent();
    }

    @Override
    protected OrmReadOnlyJoinColumn.Owner buildJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    protected OrmReadOnlyJoinColumn.Owner buildInverseJoinColumnOwner() {
        return new InverseJoinColumnOwner();
    }

    protected OrmVirtualJoinColumn buildInverseJoinColumn(ReadOnlyJoinColumn joinColumn) {
        return this.buildJoinColumn(this.inverseJoinColumnOwner, joinColumn);
    }

    @Override
    protected String buildDefaultName() {
        return this.getRelationshipStrategy().getJoinTableDefaultName();
    }

    @Override
    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationshipStrategy().getRelationship().getMapping();
    }

    @Override
    public PersistentAttribute getPersistentAttribute() {
        return this.getRelationshipMapping().getPersistentAttribute();
    }

    @Override
    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        super.validateJoinColumns(messages, reporter);
        this.validateNodes((Iterable<? extends XmlContextNode>)this.getInverseJoinColumns(), messages, reporter);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getRelationshipStrategy().validatesAgainstDatabase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractJoinColumnOwner
    implements OrmReadOnlyJoinColumn.Owner {
        protected AbstractJoinColumnOwner() {
        }

        @Override
        public String getDefaultColumnName(ReadOnlyNamedColumn column) {
            return MappingTools.buildJoinColumnDefaultName((ReadOnlyJoinColumn)column, this);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return Tools.valuesAreDifferent((Object)this.getDefaultTableName(), (Object)tableName);
        }

        @Override
        public Iterable<String> getCandidateTableNames() {
            return EmptyIterable.instance();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return Tools.valuesAreEqual((Object)GenericOrmVirtualJoinTable.this.getName(), (Object)tableName) ? GenericOrmVirtualJoinTable.this.getDbTable() : null;
        }

        @Override
        public String getDefaultTableName() {
            return GenericOrmVirtualJoinTable.this.getName();
        }

        @Override
        public TextRange getValidationTextRange() {
            return GenericOrmVirtualJoinTable.this.getValidationTextRange();
        }

        protected OrmVirtualRelationship getRelationship() {
            return this.getRelationshipStrategy().getRelationship();
        }

        protected OrmVirtualJoinTableRelationshipStrategy getRelationshipStrategy() {
            return GenericOrmVirtualJoinTable.this.getRelationshipStrategy();
        }
    }

    protected class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected InverseJoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            RelationshipMapping relationshipMapping = GenericOrmVirtualJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericOrmVirtualJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getName();
        }

        public Table resolveDbTable(String tableName) {
            Table dbTable = super.resolveDbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.resolveDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return GenericOrmVirtualJoinTable.this.defaultInverseJoinColumn == joinColumn;
        }

        public int getJoinColumnsSize() {
            return GenericOrmVirtualJoinTable.this.getInverseJoinColumnsSize();
        }

        public JptValidator buildColumnValidator(ReadOnlyNamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return this.getRelationshipStrategy().buildJoinTableInverseJoinColumnValidator((ReadOnlyJoinColumn)column, this, (JoinColumnTextRangeResolver)textRangeResolver);
        }
    }

    protected class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected JoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            return this.getRelationship().getEntity();
        }

        public String getAttributeName() {
            return MappingTools.getTargetAttributeName(GenericOrmVirtualJoinTable.this.getRelationshipMapping());
        }

        public Table resolveDbTable(String tableName) {
            Table dbTable = super.resolveDbTable(tableName);
            return dbTable != null ? dbTable : this.getTypeMapping().resolveDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        protected TypeMapping getTypeMapping() {
            return this.getRelationship().getTypeMapping();
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return GenericOrmVirtualJoinTable.this.defaultJoinColumn == joinColumn;
        }

        public int getJoinColumnsSize() {
            return GenericOrmVirtualJoinTable.this.getJoinColumnsSize();
        }

        public JptValidator buildColumnValidator(ReadOnlyNamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return this.getRelationshipStrategy().buildJoinTableJoinColumnValidator((ReadOnlyJoinColumn)column, this, (JoinColumnTextRangeResolver)textRangeResolver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedInverseJoinColumnContainer
    extends AbstractJpaNode.ContextListContainer<OrmVirtualJoinColumn, ReadOnlyJoinColumn> {
        protected SpecifiedInverseJoinColumnContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedInverseJoinColumns";
        }

        @Override
        protected OrmVirtualJoinColumn buildContextElement(ReadOnlyJoinColumn resourceElement) {
            return GenericOrmVirtualJoinTable.this.buildInverseJoinColumn(resourceElement);
        }

        @Override
        protected ListIterable<ReadOnlyJoinColumn> getResourceElements() {
            return GenericOrmVirtualJoinTable.this.getOverriddenInverseJoinColumns();
        }

        @Override
        protected ReadOnlyJoinColumn getResourceElement(OrmVirtualJoinColumn contextElement) {
            return contextElement.getOverriddenColumn();
        }
    }
}

