/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.CollectionMapping;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.PersistentAttributeTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmPersistentAttributeTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaPersistentAttribute2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmPersistentAttribute2_0;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAccessHolder;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeMapping;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpecifiedOrmPersistentAttribute
extends AbstractOrmXmlContextNode
implements OrmPersistentAttribute2_0 {
    protected OrmAttributeMapping mapping;
    protected JavaPersistentAttribute javaPersistentAttribute;
    protected JavaPersistentAttribute cachedJavaPersistentAttribute;
    protected AccessType specifiedAccess;
    protected AccessType defaultAccess;

    protected SpecifiedOrmPersistentAttribute(OrmPersistentType parent, XmlAttributeMapping xmlMapping) {
        super(parent);
        this.mapping = this.buildMapping(xmlMapping);
        this.specifiedAccess = this.buildSpecifiedAccess();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.mapping.synchronizeWithResourceModel();
        if (this.cachedJavaPersistentAttribute != null) {
            this.cachedJavaPersistentAttribute.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultAccess(this.buildDefaultAccess());
        this.setJavaPersistentAttribute(this.buildJavaPersistentAttribute());
        this.mapping.update();
        if (this.cachedJavaPersistentAttribute != null) {
            this.cachedJavaPersistentAttribute.update();
        }
    }

    @Override
    public OrmAttributeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public OrmAttributeMapping setMappingKey(String mappingKey) {
        if (this.valuesAreDifferent(this.getMappingKey(), mappingKey)) {
            this.setMappingKey_(mappingKey);
        }
        return this.mapping;
    }

    protected void setMappingKey_(String mappingKey) {
        OrmAttributeMappingDefinition mappingDefinition = this.getMappingFileDefinition().getAttributeMappingDefinition(mappingKey);
        XmlAttributeMapping xmlAttributeMapping = mappingDefinition.buildResourceMapping(this.getResourceNodeFactory());
        this.setMapping(this.buildMapping(xmlAttributeMapping));
    }

    protected final OrmAttributeMapping buildMapping(XmlAttributeMapping xmlAttributeMapping) {
        OrmAttributeMappingDefinition md = this.getMappingFileDefinition().getAttributeMappingDefinition(xmlAttributeMapping.getMappingKey());
        return md.buildContextMapping(this, xmlAttributeMapping, this.getContextNodeFactory());
    }

    protected void setMapping(OrmAttributeMapping mapping) {
        OrmAttributeMapping old = this.mapping;
        this.mapping = mapping;
        this.firePropertyChanged("mapping", old, mapping);
        this.getOwningPersistentType().changeMapping(this, old, mapping);
    }

    @Override
    public String getDefaultMappingKey() {
        return null;
    }

    protected XmlAttributeMapping getXmlAttributeMapping() {
        return this.mapping.getXmlAttributeMapping();
    }

    @Override
    public String getName() {
        return this.mapping.getName();
    }

    @Override
    public void nameChanged(String oldName, String newName) {
        this.firePropertyChanged("name", oldName, newName);
    }

    @Override
    public JavaPersistentAttribute getJavaPersistentAttribute() {
        return this.javaPersistentAttribute;
    }

    @Override
    public JavaPersistentAttribute resolveJavaPersistentAttribute() {
        return this.getJavaPersistentAttribute();
    }

    @Override
    public JavaResourceAttribute getJavaResourceAttribute() {
        return this.javaPersistentAttribute == null ? null : this.javaPersistentAttribute.getResourceAttribute();
    }

    @Override
    public boolean isFor(JavaResourceField javaResourceField) {
        return this.getJavaPersistentAttribute() == null ? false : this.getJavaPersistentAttribute().isFor(javaResourceField);
    }

    @Override
    public boolean isFor(JavaResourceMethod javaResourceGetter, JavaResourceMethod javaResourceSetter) {
        return this.getJavaPersistentAttribute() == null ? false : this.getJavaPersistentAttribute().isFor(javaResourceGetter, javaResourceSetter);
    }

    protected void setJavaPersistentAttribute(JavaPersistentAttribute javaPersistentAttribute) {
        JavaPersistentAttribute old = this.javaPersistentAttribute;
        this.javaPersistentAttribute = javaPersistentAttribute;
        this.firePropertyChanged("javaPersistentAttribute", old, javaPersistentAttribute);
    }

    protected JavaPersistentAttribute buildJavaPersistentAttribute() {
        JavaPersistentAttribute javaAttribute;
        String name = this.getName();
        if (name == null) {
            return null;
        }
        JavaPersistentType javaType = this.getOwningPersistentTypeJavaType();
        if (javaType == null) {
            return null;
        }
        ReadOnlyPersistentAttribute pAttribute = javaType.resolveAttribute(name);
        JavaPersistentAttribute javaPersistentAttribute = javaAttribute = pAttribute == null ? null : pAttribute.getJavaPersistentAttribute();
        if (javaAttribute != null && javaAttribute.getAccess() == this.getAccess()) {
            this.cachedJavaPersistentAttribute = null;
            return javaAttribute;
        }
        return this.getCachedJavaAttribute();
    }

    protected JavaPersistentAttribute getCachedJavaAttribute() {
        JavaResourceType javaResourceType = this.getOwningPersistentTypeJavaType().getJavaResourceType();
        if (this.getAccess() == AccessType.FIELD) {
            JavaResourceField javaResourceField = this.getJavaResourceField(javaResourceType);
            if (javaResourceField == null) {
                this.cachedJavaPersistentAttribute = null;
            } else if (this.cachedJavaPersistentAttribute == null || !this.cachedJavaPersistentAttribute.isFor(javaResourceField)) {
                this.cachedJavaPersistentAttribute = this.buildJavaPersistentField(javaResourceField);
            }
        }
        if (this.getAccess() == AccessType.PROPERTY) {
            JavaResourceMethod javaResourceSetter;
            JavaResourceMethod javaResourceGetter = this.getJavaResourceGetter(javaResourceType);
            JavaResourceMethod javaResourceMethod = javaResourceSetter = javaResourceGetter == null ? null : AbstractJavaPersistentType.getValidSiblingSetMethod(javaResourceGetter, javaResourceType.getMethods());
            if (javaResourceGetter == null && javaResourceSetter == null) {
                this.cachedJavaPersistentAttribute = null;
            } else if (this.cachedJavaPersistentAttribute == null || !this.cachedJavaPersistentAttribute.isFor(javaResourceGetter, javaResourceSetter)) {
                this.cachedJavaPersistentAttribute = this.buildJavaPersistentProperty(javaResourceGetter, javaResourceSetter);
            }
        }
        return this.cachedJavaPersistentAttribute;
    }

    protected JavaResourceField getJavaResourceField(JavaResourceType javaResourceType) {
        for (JavaResourceField javaResourceField : this.getJavaResourceFields(javaResourceType)) {
            if (!javaResourceField.getName().equals(this.getName())) continue;
            return javaResourceField;
        }
        String superclassName = javaResourceType.getSuperclassQualifiedName();
        if (superclassName == null) {
            return null;
        }
        JavaResourceType superclass = (JavaResourceType)this.getJpaProject().getJavaResourceType(superclassName, JavaResourceAnnotatedElement.Kind.TYPE);
        if (superclass == null) {
            return null;
        }
        return this.getJavaResourceField(superclass);
    }

    protected Iterable<JavaResourceField> getJavaResourceFields(JavaResourceType javaResourceType) {
        return javaResourceType.getFields();
    }

    protected JavaResourceMethod getJavaResourceGetter(JavaResourceType javaResourceType) {
        for (JavaResourceMethod javaResourceGetter : this.getJavaResourceGetters(javaResourceType)) {
            if (!javaResourceGetter.getName().equals(this.getName())) continue;
            return javaResourceGetter;
        }
        String superclassName = javaResourceType.getSuperclassQualifiedName();
        if (superclassName == null) {
            return null;
        }
        JavaResourceType superclass = (JavaResourceType)this.getJpaProject().getJavaResourceType(superclassName, JavaResourceAnnotatedElement.Kind.TYPE);
        if (superclass == null) {
            return null;
        }
        return this.getJavaResourceGetter(superclass);
    }

    protected Iterable<JavaResourceMethod> getResourceMethods(JavaResourceType javaResourceType, Filter<JavaResourceMethod> filter) {
        return new FilteringIterable(javaResourceType.getMethods(), filter);
    }

    protected Filter<JavaResourceMethod> buildPersistablePropertyGetterMethodsFilter(final JavaResourceType javaResourceType) {
        return new Filter<JavaResourceMethod>(){

            public boolean accept(JavaResourceMethod resourceMethod) {
                return AbstractJavaPersistentType.methodIsPersistablePropertyGetter(resourceMethod, javaResourceType.getMethods());
            }
        };
    }

    protected Iterable<JavaResourceMethod> getJavaResourceGetters(JavaResourceType javaResourceType) {
        return this.getResourceMethods(javaResourceType, this.buildPersistablePropertyGetterMethodsFilter(javaResourceType));
    }

    protected JavaPersistentAttribute buildJavaPersistentField(JavaResourceField javaResourceField) {
        return this.getJpaFactory().buildJavaPersistentField(this.getOwningPersistentType(), javaResourceField);
    }

    protected JavaPersistentAttribute buildJavaPersistentProperty(JavaResourceMethod javaResourceGetter, JavaResourceMethod javaResourceSetter) {
        return this.getJpaFactory().buildJavaPersistentProperty(this.getOwningPersistentType(), javaResourceGetter, javaResourceSetter);
    }

    @Override
    public AccessType getAccess() {
        AccessType specifiedAccess = this.getSpecifiedAccess();
        return specifiedAccess != null ? specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)access);
    }

    protected AccessType buildDefaultAccess() {
        return this.getOwningPersistentType().getAccess();
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType access) {
        this.setSpecifiedAccess_(access);
        this.getXmlAccessHolder().setAccess(AccessType.toOrmResourceModel(access));
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", (Object)old, (Object)access);
    }

    protected AccessType buildSpecifiedAccess() {
        return AccessType.fromOrmResourceModel(this.getXmlAccessHolder().getAccess());
    }

    protected XmlAccessHolder getXmlAccessHolder() {
        return this.getXmlAttributeMapping();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public OrmReadOnlyPersistentAttribute convertToVirtual() {
        return this.getOwningPersistentType().convertAttributeToVirtual(this);
    }

    @Override
    public OrmPersistentAttribute convertToSpecified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OrmPersistentAttribute convertToSpecified(String mappingKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.jpa.core.orm.persistentAttribute";
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        return this;
    }

    @Override
    public boolean contains(int textOffset) {
        return this.mapping.contains(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.mapping.getSelectionTextRange();
    }

    @Override
    public void dispose() {
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.mapping.createRenameTypeEdits(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.mapping.createMoveTypeEdits(originalType, newPackage);
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.mapping.createRenamePackageEdits(originalPackage, newName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateAttribute(messages, reporter);
        this.mapping.validate(messages, reporter);
    }

    protected void validateAttribute(List<IMessage> messages, IReporter reporter) {
        if (this.javaPersistentAttribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_UNRESOLVED_NAME", new String[]{this.getName(), this.getOwningTypeMapping().getClass_()}, this.mapping, this.mapping.getNameTextRange()));
        } else {
            this.buildAttibuteValidator().validate(messages, reporter);
        }
    }

    protected PersistentAttributeTextRangeResolver buildTextRangeResolver() {
        return new OrmPersistentAttributeTextRangeResolver(this);
    }

    protected abstract JptValidator buildAttibuteValidator();

    @Override
    public TextRange getValidationTextRange() {
        return this.mapping.getValidationTextRange();
    }

    @Override
    public String getMetamodelContainerFieldTypeName() {
        return this.getJpaContainerDefinition().getMetamodelContainerFieldTypeName();
    }

    @Override
    public String getMetamodelContainerFieldMapKeyTypeName() {
        return this.getJpaContainerDefinition().getMetamodelContainerFieldMapKeyTypeName((CollectionMapping)((Object)this.mapping));
    }

    @Override
    public String getMetamodelTypeName() {
        JavaPersistentAttribute2_0 javaAttribute = (JavaPersistentAttribute2_0)this.javaPersistentAttribute;
        return javaAttribute != null ? javaAttribute.getMetamodelTypeName() : MetamodelField.DEFAULT_TYPE_NAME;
    }

    protected JavaPersistentAttribute.JpaContainerDefinition getJpaContainerDefinition() {
        JavaPersistentAttribute2_0 javaAttribute = (JavaPersistentAttribute2_0)this.javaPersistentAttribute;
        return javaAttribute != null ? javaAttribute.getJpaContainerDefinition() : JavaPersistentAttribute.JpaContainerDefinition.Null.instance();
    }

    @Override
    public OrmPersistentType getParent() {
        return (OrmPersistentType)super.getParent();
    }

    @Override
    public OrmPersistentType getOwningPersistentType() {
        return this.getParent();
    }

    protected JavaPersistentType getOwningPersistentTypeJavaType() {
        return this.getOwningPersistentType().getJavaPersistentType();
    }

    @Override
    public OrmTypeMapping getOwningTypeMapping() {
        return this.getOwningPersistentType().getMapping();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.mapping.getPrimaryKeyColumnName();
    }

    @Override
    public String getTypeName() {
        return this.javaPersistentAttribute == null ? null : this.javaPersistentAttribute.getTypeName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

