/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaTemporalConverter;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.AbstractJavaConverter;
import org.eclipse.jpt.jpa.core.resource.java.TemporalAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaTemporalConverter
extends AbstractJavaConverter
implements JavaTemporalConverter {
    protected final TemporalAnnotation temporalAnnotation;
    protected TemporalType temporalType;

    public GenericJavaTemporalConverter(JavaAttributeMapping parent, TemporalAnnotation temporalAnnotation, Converter.Owner owner) {
        super(parent, owner);
        this.temporalAnnotation = temporalAnnotation;
        this.temporalType = this.buildTemporalType();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setTemporalType_(this.buildTemporalType());
    }

    @Override
    public TemporalType getTemporalType() {
        return this.temporalType;
    }

    @Override
    public void setTemporalType(TemporalType temporalType) {
        if (this.valuesAreDifferent((Object)this.temporalType, (Object)temporalType)) {
            this.temporalAnnotation.setValue(TemporalType.toJavaResourceModel(temporalType));
            this.removeTemporalAnnotationIfUnset();
            this.setTemporalType_(temporalType);
        }
    }

    protected void setTemporalType_(TemporalType temporalType) {
        TemporalType old = this.temporalType;
        this.temporalType = temporalType;
        this.firePropertyChanged("temporalType", (Object)old, (Object)temporalType);
    }

    protected TemporalType buildTemporalType() {
        return TemporalType.fromJavaResourceModel(this.temporalAnnotation.getValue());
    }

    @Override
    public Class<? extends Converter> getType() {
        return TemporalConverter.class;
    }

    @Override
    public TemporalAnnotation getConverterAnnotation() {
        return this.temporalAnnotation;
    }

    protected void removeTemporalAnnotationIfUnset() {
        if (this.temporalAnnotation.isUnset()) {
            this.temporalAnnotation.removeAnnotation();
        }
    }
}

