/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import org.eclipse.jpt.jpa.core.context.DiscriminatorType;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmNamedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyNamedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmNamedColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlBaseDiscriminatorColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmNamedDiscriminatorColumn<X extends XmlBaseDiscriminatorColumn, O extends OrmReadOnlyNamedDiscriminatorColumn.Owner>
extends AbstractOrmNamedColumn<X, O>
implements OrmNamedDiscriminatorColumn {
    protected DiscriminatorType specifiedDiscriminatorType = this.buildSpecifiedDiscriminatorType();
    protected DiscriminatorType defaultDiscriminatorType;
    protected Integer specifiedLength = this.buildSpecifiedLength();
    protected int defaultLength;

    protected AbstractOrmNamedDiscriminatorColumn(XmlContextNode parent, O owner) {
        this(parent, owner, null);
    }

    protected AbstractOrmNamedDiscriminatorColumn(XmlContextNode parent, O owner, X xmlColumn) {
        super(parent, owner, xmlColumn);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedDiscriminatorType_(this.buildSpecifiedDiscriminatorType());
        this.setSpecifiedLength_(this.buildSpecifiedLength());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultDiscriminatorType(this.buildDefaultDiscriminatorType());
        this.setDefaultLength(this.buildDefaultLength());
    }

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.specifiedDiscriminatorType != null ? this.specifiedDiscriminatorType : this.defaultDiscriminatorType;
    }

    @Override
    public DiscriminatorType getSpecifiedDiscriminatorType() {
        return this.specifiedDiscriminatorType;
    }

    @Override
    public void setSpecifiedDiscriminatorType(DiscriminatorType discriminatorType) {
        if (this.valuesAreDifferent((Object)this.specifiedDiscriminatorType, (Object)discriminatorType)) {
            XmlBaseDiscriminatorColumn xmlColumn = (XmlBaseDiscriminatorColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedDiscriminatorType_(discriminatorType);
            xmlColumn.setDiscriminatorType(DiscriminatorType.toOrmResourceModel(discriminatorType));
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedDiscriminatorType_(DiscriminatorType discriminatorType) {
        DiscriminatorType old = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = discriminatorType;
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)old, (Object)discriminatorType);
    }

    protected DiscriminatorType buildSpecifiedDiscriminatorType() {
        XmlBaseDiscriminatorColumn xmlColumn = (XmlBaseDiscriminatorColumn)this.getXmlColumn();
        return xmlColumn == null ? null : DiscriminatorType.fromOrmResourceModel(xmlColumn.getDiscriminatorType());
    }

    @Override
    public DiscriminatorType getDefaultDiscriminatorType() {
        return this.defaultDiscriminatorType;
    }

    protected void setDefaultDiscriminatorType(DiscriminatorType discriminatorType) {
        DiscriminatorType old = this.defaultDiscriminatorType;
        this.defaultDiscriminatorType = discriminatorType;
        this.firePropertyChanged("defaultDiscriminatorType", (Object)old, (Object)discriminatorType);
    }

    protected DiscriminatorType buildDefaultDiscriminatorType() {
        return ((OrmReadOnlyNamedDiscriminatorColumn.Owner)this.owner).getDefaultDiscriminatorType();
    }

    @Override
    public int getLength() {
        return this.specifiedLength != null ? this.specifiedLength : this.defaultLength;
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer length) {
        if (this.valuesAreDifferent(this.specifiedLength, length)) {
            XmlBaseDiscriminatorColumn xmlColumn = (XmlBaseDiscriminatorColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedLength_(length);
            xmlColumn.setLength(length);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedLength_(Integer length) {
        Integer old = this.specifiedLength;
        this.specifiedLength = length;
        this.firePropertyChanged("specifiedLength", old, length);
    }

    protected Integer buildSpecifiedLength() {
        XmlBaseDiscriminatorColumn xmlColumn = (XmlBaseDiscriminatorColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getLength();
    }

    @Override
    public int getDefaultLength() {
        return this.defaultLength;
    }

    protected void setDefaultLength(int defaultLength) {
        int old = this.defaultLength;
        this.defaultLength = defaultLength;
        this.firePropertyChanged("defaultLength", old, defaultLength);
    }

    protected int buildDefaultLength() {
        return ((OrmReadOnlyNamedDiscriminatorColumn.Owner)this.owner).getDefaultLength();
    }

    public boolean isResourceSpecified() {
        return this.getXmlColumn() != null;
    }
}

