/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaManagedTypeProvider;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaMapping;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JpaManagedType
implements IManagedType {
    private final TypeMapping managedType;
    private Map<String, IMapping> mappings;
    private final JpaManagedTypeProvider provider;
    private IType type;

    JpaManagedType(JpaManagedTypeProvider provider, TypeMapping managedType) {
        this.provider = provider;
        this.managedType = managedType;
    }

    private IMapping buildMapping(AttributeMapping mapping) {
        return new JpaMapping(this, mapping);
    }

    private Map<String, IMapping> buildMappings() {
        HashMap<String, IMapping> mappings = new HashMap<String, IMapping>();
        for (AttributeMapping mapping : this.managedType.getAllAttributeMappings()) {
            mappings.put(mapping.getName(), this.buildMapping(mapping));
        }
        return mappings;
    }

    public int compareTo(IManagedType managedType) {
        return this.getType().getName().compareTo(managedType.getType().getName());
    }

    TypeMapping getManagedType() {
        return this.managedType;
    }

    public final IMapping getMappingNamed(String name) {
        this.initializeMappings();
        return this.mappings.get(name);
    }

    public final JpaManagedTypeProvider getProvider() {
        return this.provider;
    }

    public final IType getType() {
        if (this.type == null) {
            this.type = this.provider.getTypeRepository().getType(this.managedType.getPersistentType().getName());
        }
        return this.type;
    }

    private void initializeMappings() {
        if (this.mappings == null) {
            this.mappings = this.buildMappings();
        }
    }

    public final Iterable<IMapping> mappings() {
        this.initializeMappings();
        return Collections.unmodifiableCollection(this.mappings.values());
    }
}

