/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.MappedSuperclass;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.persistence.PersistentTypeContainer;
import org.eclipse.jpt.jpa.core.internal.jpa1.GenericJpaProject;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaEmbeddable;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaEntity;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaMappedSuperclass;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaNullManagedType;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaTypeRepository;
import org.eclipse.persistence.jpa.jpql.spi.IEmbeddable;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.spi.IPlatform;
import org.eclipse.persistence.jpa.jpql.spi.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaManagedTypeProvider
implements IManagedTypeProvider {
    private Collection<IEntity> abstractSchemaTypes;
    private final JpaProject jpaProject;
    private Map<String, IManagedType> managedTypes;
    private final PersistentTypeContainer persistentTypeContainer;
    private JpaTypeRepository typeRepository;
    private IJPAVersion version;

    public JpaManagedTypeProvider(JpaProject jpaProject, PersistentTypeContainer persistentTypeContainer) {
        this.jpaProject = jpaProject;
        this.persistentTypeContainer = persistentTypeContainer;
    }

    public Iterable<IEntity> abstractSchemaTypes() {
        if (this.abstractSchemaTypes == null) {
            this.initializeManagedTypes();
            EntityCollector visitor = new EntityCollector();
            for (IManagedType managedType : this.managedTypes.values()) {
                managedType.accept((IManagedTypeVisitor)visitor);
            }
            this.abstractSchemaTypes = visitor.entities;
        }
        return Collections.unmodifiableCollection(this.abstractSchemaTypes);
    }

    private IManagedType buildManagedType(PersistentType persistentType) {
        TypeMapping mappedClass = persistentType.getMapping();
        if (mappedClass instanceof Entity) {
            return new JpaEntity(this, (Entity)mappedClass);
        }
        if (mappedClass instanceof MappedSuperclass) {
            return new JpaMappedSuperclass(this, (MappedSuperclass)mappedClass);
        }
        if (mappedClass instanceof Embeddable) {
            return new JpaEmbeddable(this, (Embeddable)mappedClass);
        }
        return new JpaNullManagedType(this, mappedClass);
    }

    private Map<String, IManagedType> buildManagedTypes() {
        HashMap<String, IManagedType> managedTypes = new HashMap<String, IManagedType>();
        for (PersistentType persistentType : this.getPersistentTypeContainer().getPersistentTypes()) {
            String name;
            if (persistentType == null || managedTypes.containsKey(name = persistentType.getMapping().getName()) && persistentType.getOverriddenPersistentType() == null) continue;
            managedTypes.put(name, this.buildManagedType(persistentType));
        }
        return managedTypes;
    }

    private IJPAVersion convert(JpaPlatform.Version version) {
        String jpaVersion = version.getJpaVersion();
        if (JpaFacet.VERSION_1_0.getVersionString().equals(jpaVersion)) {
            return IJPAVersion.VERSION_1_0;
        }
        return IJPAVersion.VERSION_2_0;
    }

    public IManagedType getManagedType(IType type) {
        this.initializeManagedTypes();
        for (IManagedType managedType : this.managedTypes.values()) {
            if (managedType.getType() != type) continue;
            return managedType;
        }
        return null;
    }

    public IManagedType getManagedType(String abstractSchemaName) {
        this.initializeManagedTypes();
        return this.managedTypes.get(abstractSchemaName);
    }

    PersistentTypeContainer getPersistentTypeContainer() {
        return this.persistentTypeContainer;
    }

    public IPlatform getPlatform() {
        return this.jpaProject instanceof GenericJpaProject ? IPlatform.JAVA : IPlatform.ECLIPSE_LINK;
    }

    PersistentTypeContainer getProvider() {
        return this.persistentTypeContainer;
    }

    public JpaTypeRepository getTypeRepository() {
        if (this.typeRepository == null) {
            this.typeRepository = new JpaTypeRepository(this.jpaProject.getJavaProject());
        }
        return this.typeRepository;
    }

    public IJPAVersion getVersion() {
        if (this.version == null) {
            this.version = this.convert(this.jpaProject.getJpaPlatform().getJpaVersion());
        }
        return this.version;
    }

    private void initializeManagedTypes() {
        if (this.managedTypes == null) {
            this.managedTypes = this.buildManagedTypes();
        }
    }

    public Iterable<IManagedType> managedTypes() {
        this.initializeManagedTypes();
        return Collections.unmodifiableCollection(this.managedTypes.values());
    }

    Iterable<? extends PersistentType> persistenceTypes() {
        return this.persistentTypeContainer.getPersistentTypes();
    }

    private static class EntityCollector
    implements IManagedTypeVisitor {
        private final Collection<IEntity> entities = new ArrayList<IEntity>();

        EntityCollector() {
        }

        public void visit(IEmbeddable embeddable) {
        }

        public void visit(IEntity entity) {
            this.entities.add(entity);
        }

        public void visit(IMappedSuperclass mappedSuperclass) {
        }
    }
}

