/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.refactoring.JpaCoreRefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaDeleteMappingFileParticipant
extends DeleteParticipant
implements ISharableParticipant {
    protected final Map<IFile, DeleteArguments> mappingFiles = new HashMap<IFile, DeleteArguments>();
    protected final Map<IFile, Iterable<DeleteEdit>> persistenceXmlMappingFileDeleteEdits = new HashMap<IFile, Iterable<DeleteEdit>>();

    public String getName() {
        return JpaCoreRefactoringMessages.JPA_DELETE_MAPPING_FILE_REFACTORING_PARTICIPANT_NAME;
    }

    protected boolean initialize(Object element) {
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return true;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        this.mappingFiles.put((IFile)element, (DeleteArguments)arguments);
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        monitor.subTask(JpaCoreRefactoringMessages.JPA_REFACORING_PARTICIPANT_LOADING_JPA_PROJECTS_SUB_TASK_NAME);
        JpaProjectManager jpaProjectManager = JptJpaCorePlugin.getJpaProjectManager();
        if (jpaProjectManager.getJpaProjectsSize() == 0) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(jpaProjectManager.getJpaProjectsSize() * 10 + 1));
        sm.subTask(JpaCoreRefactoringMessages.JPA_DELETE_MAPPING_FILE_REFACTORING_SUB_TASK_NAME);
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        for (JpaProject jpaProject : JptJpaCorePlugin.getJpaProjectManager().getJpaProjects()) {
            this.createDeleteEdits(jpaProject);
            sm.worked(10);
        }
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IFile persistenceXmlFile : this.persistenceXmlMappingFileDeleteEdits.keySet()) {
            deltaFactory.change(persistenceXmlFile);
        }
        sm.worked(1);
        return null;
    }

    protected void createDeleteEdits(JpaProject jpaProject) throws OperationCanceledException {
        PersistenceUnit persistenceUnit = this.getPersistenceUnit(jpaProject);
        if (persistenceUnit == null) {
            return;
        }
        Iterable<DeleteEdit> classRefDeleteEdits = this.createSpecifiedMappingFileRefDeleteEdits(persistenceUnit);
        if (!CollectionTools.isEmpty(classRefDeleteEdits)) {
            this.persistenceXmlMappingFileDeleteEdits.put(jpaProject.getPersistenceXmlResource().getFile(), classRefDeleteEdits);
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (this.persistenceXmlMappingFileDeleteEdits.isEmpty()) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.persistenceXmlMappingFileDeleteEdits.size());
        sm.subTask(JpaCoreRefactoringMessages.JPA_DELETE_MAPPING_FILE_REFACTORING_SUB_TASK_NAME);
        CompositeChange compositeChange = new CompositeChange(JpaCoreRefactoringMessages.JPA_DELETE_MAPPING_FILE_REFACTORING_CHANGE_NAME);
        for (IFile persistenceXmlFile : this.persistenceXmlMappingFileDeleteEdits.keySet()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.addPersistenceXmlDeleteMappingFileChange(persistenceXmlFile, compositeChange);
        }
        return compositeChange.getChildren().length == 0 ? null : compositeChange;
    }

    private Iterable<DeleteEdit> createSpecifiedMappingFileRefDeleteEdits(final PersistenceUnit persistenceUnit) {
        return new CompositeIterable((Iterable)new TransformationIterable<IFile, Iterable<DeleteEdit>>(this.mappingFiles.keySet()){

            protected Iterable<DeleteEdit> transform(IFile file) {
                return persistenceUnit.createDeleteMappingFileEdits(file);
            }
        });
    }

    protected void addPersistenceXmlDeleteMappingFileChange(IFile persistenceXmlFile, CompositeChange compositeChange) {
        TextChange textChange = this.getTextChange(persistenceXmlFile);
        if (textChange == null) {
            textChange = new TextFileChange(JpaCoreRefactoringMessages.JPA_DELETE_MAPPING_FILE_REFACTORING_CHANGE_PERSISTENCE_XML_NAME, persistenceXmlFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        Iterable<DeleteEdit> mappingFileDeleteEdits = this.persistenceXmlMappingFileDeleteEdits.get(persistenceXmlFile);
        this.addEdits(textChange, mappingFileDeleteEdits);
    }

    private PersistenceUnit getPersistenceUnit(JpaProject jpaProject) {
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            return null;
        }
        if (persistence.getPersistenceUnitsSize() != 1) {
            return null;
        }
        return (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
    }

    private void addEdits(TextChange textChange, Iterable<? extends TextEdit> textEdits) {
        for (TextEdit textEdit : textEdits) {
            try {
                textChange.addEdit(textEdit);
            }
            catch (MalformedTreeException e) {
                JptJpaCorePlugin.log(e);
            }
        }
    }
}

