/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverterClassConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkNamedConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaEclipseLinkConverterClassConverter<A extends EclipseLinkNamedConverterAnnotation>
extends JavaEclipseLinkConverter<A>
implements EclipseLinkConverterClassConverter {
    private String converterClass;

    public JavaEclipseLinkConverterClassConverter(JavaJpaContextNode parent, A converterAnnotation, String converterClass) {
        super(parent, converterAnnotation);
        this.converterClass = converterClass;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setConverterClass_(this.getAnnotationConverterClass());
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String converterClass) {
        this.setAnnotationConverterClass(converterClass);
        this.setConverterClass_(converterClass);
    }

    protected void setConverterClass_(String converterClass) {
        String old = this.converterClass;
        this.converterClass = converterClass;
        this.firePropertyChanged("converterClass", old, converterClass);
    }

    protected abstract String getAnnotationConverterClass();

    protected abstract void setAnnotationConverterClass(String var1);

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateConverterClass(messages, astRoot);
    }

    protected void validateConverterClass(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.converterClass == null) {
            return;
        }
        if (StringTools.stringIsEmpty((String)this.converterClass)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_DEFINED", this, this.getConverterClassTextRange(astRoot)));
            return;
        }
        if (!this.converterClassExists()) {
            this.addConverterClassDoesNotExistMessageTo(messages, astRoot);
            return;
        }
        if (!this.converterClassImplementsInterface(this.getEclipseLinkConverterInterface())) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, this.getEclipseLinkConverterInterfaceErrorMessage(), new String[]{this.getFullyQualifiedConverterClass()}, this, this.getConverterClassTextRange(astRoot)));
        }
    }

    protected void addConverterClassDoesNotExistMessageTo(List<IMessage> messages, CompilationUnit astRoot) {
        messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_EXISTS", new String[]{this.getFullyQualifiedConverterClass()}, this, this.getConverterClassTextRange(astRoot)));
    }

    protected abstract String getEclipseLinkConverterInterface();

    protected abstract String getEclipseLinkConverterInterfaceErrorMessage();

    protected boolean converterClassExists() {
        return this.typeExists(this.getFullyQualifiedConverterClass());
    }

    protected boolean typeExists(String typeName) {
        return typeName != null && JDTTools.findType((IJavaProject)this.getJavaProject(), (String)typeName) != null;
    }

    protected boolean typeImplementsInterface(String typeName, String interfaceName) {
        return typeName != null && JDTTools.typeIsSubType((IJavaProject)this.getJavaProject(), (String)typeName, (String)interfaceName);
    }

    protected boolean converterClassImplementsInterface(String interfaceName) {
        return this.typeImplementsInterface(this.getFullyQualifiedConverterClass(), interfaceName);
    }

    protected abstract String getFullyQualifiedConverterClass();

    protected TextRange getConverterClassTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getAnnotationConverterClassTextRange(astRoot), astRoot);
    }

    protected abstract TextRange getAnnotationConverterClassTextRange(CompilationUnit var1);

    protected IJavaProject getJavaProject() {
        return this.getJpaProject().getJavaProject();
    }
}

