/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.NotNullFilter;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.JavaEclipseLinkConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkNamedConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkConverterContainerImpl
extends AbstractJavaJpaContextNode
implements JavaEclipseLinkConverterContainer {
    protected JavaEclipseLinkCustomConverter customConverter = this.buildCustomConverter();
    protected JavaEclipseLinkObjectTypeConverter objectTypeConverter = this.buildObjectTypeConverter();
    protected JavaEclipseLinkStructConverter structConverter = this.buildStructConverter();
    protected JavaEclipseLinkTypeConverter typeConverter = this.buildTypeConverter();

    public JavaEclipseLinkConverterContainerImpl(JavaTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncCustomConverter();
        this.syncObjectTypeConverter();
        this.syncStructConverter();
        this.syncTypeConverter();
    }

    public void update() {
        super.update();
        if (this.customConverter != null) {
            this.customConverter.update();
        }
        if (this.objectTypeConverter != null) {
            this.objectTypeConverter.update();
        }
        if (this.structConverter != null) {
            this.structConverter.update();
        }
        if (this.typeConverter != null) {
            this.typeConverter.update();
        }
    }

    @Override
    public JavaEclipseLinkCustomConverter getCustomConverter() {
        return this.customConverter;
    }

    @Override
    public JavaEclipseLinkCustomConverter addCustomConverter() {
        if (this.customConverter != null) {
            throw new IllegalStateException("custom converter already exists: " + this.customConverter);
        }
        JavaEclipseLinkCustomConverter converter = (JavaEclipseLinkCustomConverter)this.buildNewConverter(this.getCustomConverterAdapter());
        this.setCustomConverter_(converter);
        return converter;
    }

    @Override
    public void removeCustomConverter() {
        if (this.customConverter == null) {
            throw new IllegalStateException("custom converter is null");
        }
        this.getCustomConverterAdapter().removeConverterAnnotation((JavaResourceMember)this.getJavaResourceType());
        this.setCustomConverter_(null);
    }

    protected void setCustomConverter_(JavaEclipseLinkCustomConverter converter) {
        JavaEclipseLinkCustomConverter old = this.customConverter;
        this.customConverter = converter;
        this.firePropertyChanged("customConverter", old, converter);
    }

    protected JavaEclipseLinkCustomConverter buildCustomConverter() {
        return (JavaEclipseLinkCustomConverter)this.buildConverter(this.getCustomConverterAdapter());
    }

    protected void syncCustomConverter() {
        EclipseLinkNamedConverterAnnotation annotation = this.getCustomConverterAdapter().getConverterAnnotation((JavaResourceMember)this.getJavaResourceType());
        if (annotation == null) {
            if (this.customConverter != null) {
                this.setCustomConverter_(null);
            }
        } else if (this.customConverter != null && this.customConverter.getConverterAnnotation() == annotation) {
            this.customConverter.synchronizeWithResourceModel();
        } else {
            JavaEclipseLinkCustomConverter converter = (JavaEclipseLinkCustomConverter)this.buildConverter(this.getCustomConverterAdapter(), annotation);
            this.setCustomConverter_(converter);
        }
    }

    protected JavaEclipseLinkCustomConverter.Adapter getCustomConverterAdapter() {
        return JavaEclipseLinkCustomConverter.Adapter.instance();
    }

    @Override
    public JavaEclipseLinkObjectTypeConverter getObjectTypeConverter() {
        return this.objectTypeConverter;
    }

    @Override
    public JavaEclipseLinkObjectTypeConverter addObjectTypeConverter() {
        if (this.objectTypeConverter != null) {
            throw new IllegalStateException("object type converter already exists: " + this.objectTypeConverter);
        }
        JavaEclipseLinkObjectTypeConverter converter = (JavaEclipseLinkObjectTypeConverter)this.buildNewConverter(this.getObjectTypeConverterAdapter());
        this.setObjectTypeConverter_(converter);
        return converter;
    }

    @Override
    public void removeObjectTypeConverter() {
        if (this.objectTypeConverter == null) {
            throw new IllegalStateException("object type converter is null");
        }
        this.getObjectTypeConverterAdapter().removeConverterAnnotation((JavaResourceMember)this.getJavaResourceType());
        this.setObjectTypeConverter_(null);
    }

    protected void setObjectTypeConverter_(JavaEclipseLinkObjectTypeConverter converter) {
        JavaEclipseLinkObjectTypeConverter old = this.objectTypeConverter;
        this.objectTypeConverter = converter;
        this.firePropertyChanged("objectTypeConverter", old, converter);
    }

    protected JavaEclipseLinkObjectTypeConverter buildObjectTypeConverter() {
        return (JavaEclipseLinkObjectTypeConverter)this.buildConverter(this.getObjectTypeConverterAdapter());
    }

    protected void syncObjectTypeConverter() {
        EclipseLinkNamedConverterAnnotation annotation = this.getObjectTypeConverterAdapter().getConverterAnnotation((JavaResourceMember)this.getJavaResourceType());
        if (annotation == null) {
            if (this.objectTypeConverter != null) {
                this.setObjectTypeConverter_(null);
            }
        } else if (this.objectTypeConverter != null && this.objectTypeConverter.getConverterAnnotation() == annotation) {
            this.objectTypeConverter.synchronizeWithResourceModel();
        } else {
            JavaEclipseLinkObjectTypeConverter converter = (JavaEclipseLinkObjectTypeConverter)this.buildConverter(this.getObjectTypeConverterAdapter(), annotation);
            this.setObjectTypeConverter_(converter);
        }
    }

    protected JavaEclipseLinkObjectTypeConverter.Adapter getObjectTypeConverterAdapter() {
        return JavaEclipseLinkObjectTypeConverter.Adapter.instance();
    }

    @Override
    public JavaEclipseLinkStructConverter getStructConverter() {
        return this.structConverter;
    }

    @Override
    public JavaEclipseLinkStructConverter addStructConverter() {
        if (this.structConverter != null) {
            throw new IllegalStateException("struct converter already exists: " + this.structConverter);
        }
        JavaEclipseLinkStructConverter converter = (JavaEclipseLinkStructConverter)this.buildNewConverter(this.getStructConverterAdapter());
        this.setStructConverter_(converter);
        return converter;
    }

    @Override
    public void removeStructConverter() {
        if (this.structConverter == null) {
            throw new IllegalStateException("struct converter is null");
        }
        this.getStructConverterAdapter().removeConverterAnnotation((JavaResourceMember)this.getJavaResourceType());
        this.setStructConverter_(null);
    }

    protected void setStructConverter_(JavaEclipseLinkStructConverter converter) {
        JavaEclipseLinkStructConverter old = this.structConverter;
        this.structConverter = converter;
        this.firePropertyChanged("structConverter", old, converter);
    }

    protected JavaEclipseLinkStructConverter buildStructConverter() {
        return (JavaEclipseLinkStructConverter)this.buildConverter(this.getStructConverterAdapter());
    }

    protected void syncStructConverter() {
        EclipseLinkNamedConverterAnnotation annotation = this.getStructConverterAdapter().getConverterAnnotation((JavaResourceMember)this.getJavaResourceType());
        if (annotation == null) {
            if (this.structConverter != null) {
                this.setStructConverter_(null);
            }
        } else if (this.structConverter != null && this.structConverter.getConverterAnnotation() == annotation) {
            this.structConverter.synchronizeWithResourceModel();
        } else {
            JavaEclipseLinkStructConverter converter = (JavaEclipseLinkStructConverter)this.buildConverter(this.getStructConverterAdapter(), annotation);
            this.setStructConverter_(converter);
        }
    }

    protected JavaEclipseLinkStructConverter.Adapter getStructConverterAdapter() {
        return JavaEclipseLinkStructConverter.Adapter.instance();
    }

    @Override
    public JavaEclipseLinkTypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public JavaEclipseLinkTypeConverter addTypeConverter() {
        if (this.typeConverter != null) {
            throw new IllegalStateException("type converter already exists: " + this.typeConverter);
        }
        JavaEclipseLinkTypeConverter converter = (JavaEclipseLinkTypeConverter)this.buildNewConverter(this.getTypeConverterAdapter());
        this.setTypeConverter_(converter);
        return converter;
    }

    @Override
    public void removeTypeConverter() {
        if (this.typeConverter == null) {
            throw new IllegalStateException("type converter is null");
        }
        this.getTypeConverterAdapter().removeConverterAnnotation((JavaResourceMember)this.getJavaResourceType());
        this.setTypeConverter_(null);
    }

    protected void setTypeConverter_(JavaEclipseLinkTypeConverter converter) {
        JavaEclipseLinkTypeConverter old = this.typeConverter;
        this.typeConverter = converter;
        this.firePropertyChanged("typeConverter", old, converter);
    }

    protected JavaEclipseLinkTypeConverter buildTypeConverter() {
        return (JavaEclipseLinkTypeConverter)this.buildConverter(this.getTypeConverterAdapter());
    }

    protected void syncTypeConverter() {
        EclipseLinkNamedConverterAnnotation annotation = this.getTypeConverterAdapter().getConverterAnnotation((JavaResourceMember)this.getJavaResourceType());
        if (annotation == null) {
            if (this.typeConverter != null) {
                this.setTypeConverter_(null);
            }
        } else if (this.typeConverter != null && this.typeConverter.getConverterAnnotation() == annotation) {
            this.typeConverter.synchronizeWithResourceModel();
        } else {
            JavaEclipseLinkTypeConverter converter = (JavaEclipseLinkTypeConverter)this.buildConverter(this.getTypeConverterAdapter(), annotation);
            this.setTypeConverter_(converter);
        }
    }

    protected JavaEclipseLinkTypeConverter.Adapter getTypeConverterAdapter() {
        return JavaEclipseLinkTypeConverter.Adapter.instance();
    }

    public JavaTypeMapping getParent() {
        return (JavaTypeMapping)super.getParent();
    }

    protected JavaTypeMapping getTypeMapping() {
        return this.getParent();
    }

    protected JavaResourceType getJavaResourceType() {
        return this.getTypeMapping().getJavaResourceType();
    }

    protected <C extends JavaEclipseLinkConverter<?>> C buildConverter(JavaEclipseLinkConverter.Adapter adapter) {
        return (C)adapter.buildConverter((JavaResourceMember)this.getJavaResourceType(), (JavaJpaContextNode)this);
    }

    protected <C extends JavaEclipseLinkConverter<?>> C buildConverter(JavaEclipseLinkConverter.Adapter adapter, EclipseLinkNamedConverterAnnotation converterAnnotation) {
        return (C)adapter.buildConverter(converterAnnotation, (JavaJpaContextNode)this);
    }

    protected <C extends JavaEclipseLinkConverter<?>> C buildNewConverter(JavaEclipseLinkConverter.Adapter adapter) {
        return (C)adapter.buildNewConverter((JavaResourceMember)this.getJavaResourceType(), this);
    }

    @Override
    public Iterable<EclipseLinkConverter> getConverters() {
        return new FilteringIterable(this.getConverters_(), NotNullFilter.instance());
    }

    protected Iterable<EclipseLinkConverter> getConverters_() {
        ArrayList<EclipseLinkConverter> result = new ArrayList<EclipseLinkConverter>(4);
        result.add(this.customConverter);
        result.add(this.objectTypeConverter);
        result.add(this.structConverter);
        result.add(this.typeConverter);
        return result;
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getJavaResourceType().getTextRange(astRoot);
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange(astRoot);
    }
}

