/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverterClassConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlNamedConverter;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrmEclipseLinkConverterClassConverter<X extends XmlNamedConverter>
extends OrmEclipseLinkConverter<X>
implements EclipseLinkConverterClassConverter {
    private String converterClass;
    protected JavaResourceAbstractType converterResourceType;

    public OrmEclipseLinkConverterClassConverter(XmlContextNode parent, X xmlConverter, String converterClass) {
        super(parent, xmlConverter);
        this.converterClass = converterClass;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setConverterClass_(this.getXmlConverterClass());
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String converterClass) {
        this.setConverterClass_(converterClass);
        this.setXmlConverterClass(converterClass);
    }

    protected void setConverterClass_(String newConverterClass) {
        String oldConverterClass = this.converterClass;
        this.converterClass = newConverterClass;
        this.firePropertyChanged("converterClass", oldConverterClass, newConverterClass);
    }

    protected JavaResourceAbstractType getConverterJavaResourceType() {
        return this.getMappingFileRoot().resolveJavaResourceType(this.converterClass);
    }

    protected abstract String getXmlConverterClass();

    protected abstract void setXmlConverterClass(String var1);

    protected void updateConverterResourceType() {
        this.converterResourceType = this.getConverterJavaResourceType();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateConverterClass(messages);
    }

    protected void validateConverterClass(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.converterClass)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_DEFINED", this, this.getConverterClassTextRange()));
            return;
        }
        if (!this.converterClassExists()) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_EXISTS", new String[]{this.converterClass}, this, this.getConverterClassTextRange()));
            return;
        }
        if (!this.converterClassImplementsInterface(this.getEclipseLinkConverterInterface())) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, this.getEclipseLinkConverterInterfaceErrorMessage(), new String[]{this.converterClass}, this, this.getConverterClassTextRange()));
        }
    }

    protected abstract String getEclipseLinkConverterInterface();

    protected abstract String getEclipseLinkConverterInterfaceErrorMessage();

    protected boolean converterClassExists() {
        return this.typeExists(this.converterClass) || this.typeExists(this.getAlternateConverterClass());
    }

    protected boolean typeExists(String typeName) {
        return typeName != null && JDTTools.findType((IJavaProject)this.getJavaProject(), (String)typeName) != null;
    }

    protected boolean typeImplementsInterface(String typeName, String interfaceName) {
        return typeName != null && JDTTools.typeIsSubType((IJavaProject)this.getJavaProject(), (String)typeName, (String)interfaceName);
    }

    protected boolean converterClassImplementsInterface(String interfaceName) {
        return this.typeImplementsInterface(this.converterClass, interfaceName) || this.typeImplementsInterface(this.getAlternateConverterClass(), interfaceName);
    }

    protected String getAlternateConverterClass() {
        String mappingFilePackage = this.getMappingFileRoot().getPackage();
        if (StringTools.stringIsEmpty((String)mappingFilePackage)) {
            return null;
        }
        return String.valueOf(mappingFilePackage) + '.' + this.converterClass;
    }

    protected TextRange getConverterClassTextRange() {
        return this.getValidationTextRange(this.getXmlConverterClassTextRange());
    }

    protected abstract TextRange getXmlConverterClassTextRange();

    protected IJavaProject getJavaProject() {
        return this.getJpaProject().getJavaProject();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.isFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenameEdit(originalType, newName)) : EmptyIterable.instance();
    }

    protected abstract ReplaceEdit createRenameEdit(IType var1, String var2);

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.isFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newPackage.getElementName())) : EmptyIterable.instance();
    }

    protected abstract ReplaceEdit createRenamePackageEdit(String var1);

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.isIn(originalPackage) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newName)) : EmptyIterable.instance();
    }

    protected boolean isFor(String typeName) {
        JavaResourceAbstractType converterType = this.getConverterJavaResourceType();
        return converterType != null && converterType.getQualifiedName().equals(typeName);
    }

    protected boolean isIn(IPackageFragment packageFragment) {
        JavaResourceAbstractType converterType = this.getConverterJavaResourceType();
        return converterType != null && converterType.isIn(packageFragment);
    }
}

