/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkMutableAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEclipseLinkMutableAnnotation
extends SourceAnnotation
implements EclipseLinkMutableAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Mutable");
    private static final DeclarationAnnotationElementAdapter<Boolean> VALUE_ADAPTER = SourceEclipseLinkMutableAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<Boolean> valueAdapter;
    private Boolean value;

    public SourceEclipseLinkMutableAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super((JavaResourceNode)parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new AnnotatedElementAnnotationElementAdapter(element, VALUE_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Mutable";
    }

    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncValue(this.buildValue(astRoot));
    }

    public boolean isUnset() {
        return super.isUnset() && this.value == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void setValue(Boolean value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(Boolean astValue) {
        Boolean old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", old, astValue);
    }

    private Boolean buildValue(CompilationUnit astRoot) {
        return (Boolean)this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", BooleanExpressionConverter.instance());
    }
}

