/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.ClassesGeneratorWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ClassesGeneratorOptionsWizardPage
extends WizardPage {
    private ProxyOptionsComposite proxyOptionsComposite;
    private Options1Composite options1Composite;
    private Options2Composite options2Composite;

    protected ClassesGeneratorOptionsWizardPage() {
        super("Classes Generator Options");
        this.initialize();
    }

    protected void initialize() {
        this.setTitle(JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_title);
        this.setDescription(JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_desc);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(true);
        this.setControl(this.buildTopLevelControl(parent));
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.proxyOptionsComposite = new ProxyOptionsComposite(composite);
        this.buildOptionsComposites(composite);
        return composite;
    }

    private void buildOptionsComposites(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        this.options1Composite = new Options1Composite(composite);
        this.options2Composite = new Options2Composite(composite);
    }

    protected String getProxy() {
        return this.proxyOptionsComposite.getProxy();
    }

    protected String getProxyFile() {
        return this.proxyOptionsComposite.getProxyFile();
    }

    protected boolean usesStrictValidation() {
        return this.options1Composite.usesStrictValidation();
    }

    protected boolean makesReadOnly() {
        return this.options1Composite.makesReadOnly();
    }

    protected boolean suppressesPackageInfoGen() {
        return this.options1Composite.suppressesPackageInfoGen();
    }

    protected boolean suppressesHeaderGen() {
        return this.options1Composite.suppressesHeaderGen();
    }

    protected boolean isVerbose() {
        return this.options1Composite.isVerbose();
    }

    protected boolean isQuiet() {
        return this.options1Composite.isQuiet();
    }

    protected boolean treatsAsXmlSchema() {
        return this.options2Composite.treatsAsXmlSchema();
    }

    protected boolean treatsAsRelaxNg() {
        return this.options2Composite.treatsAsRelaxNg();
    }

    protected boolean treatsAsRelaxNgCompact() {
        return this.options2Composite.treatsAsRelaxNgCompact();
    }

    protected boolean treatsAsDtd() {
        return this.options2Composite.treatsAsDtd();
    }

    protected boolean treatsAsWsdl() {
        return this.options2Composite.treatsAsWsdl();
    }

    protected boolean showsVersion() {
        return this.options2Composite.showsVersion();
    }

    protected boolean showsHelp() {
        return this.options2Composite.showsHelp();
    }

    protected Button buildCheckBox(Composite parent, String text, SelectionListener listener, int verticalIndent) {
        Button checkBox = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.verticalIndent = verticalIndent;
        checkBox.setLayoutData((Object)gridData);
        checkBox.setText(text);
        checkBox.addSelectionListener(listener);
        return checkBox;
    }

    protected Button buildRadioButton(Composite parent, String text, SelectionListener listener, int horizontalSpan) {
        Button radioButton = new Button(parent, 16);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        radioButton.setLayoutData((Object)gridData);
        radioButton.setText(text);
        radioButton.addSelectionListener(listener);
        return radioButton;
    }

    protected Text buildText(Composite parent, int horizontalSpan) {
        Text text = new Text(parent, 2052);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = horizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected void disableText(Text text) {
        text.setEnabled(false);
        text.setText("");
    }

    private String makeRelativeToProjectPath(String filePath) {
        Path path = new Path(filePath);
        IPath relativePath = path.makeRelativeTo(this.getProject().getLocation());
        return relativePath.toOSString();
    }

    private IProject getProject() {
        return ((ClassesGeneratorWizard)this.getWizard()).getJavaProject().getProject();
    }

    class Options1Composite {
        private boolean usesStrictValidation = true;
        private final Button usesStrictValidationCheckBox;
        private boolean makesReadOnly = false;
        private final Button makesReadOnlyCheckBox;
        private boolean suppressesPackageInfoGen = false;
        private final Button suppressesPackageInfoGenCheckBox;
        private boolean suppressesHeaderGen = false;
        private final Button suppressesHeaderGenCheckBox;
        private boolean isVerbose = false;
        private final Button isVerboseCheckBox;
        private boolean isQuiet = false;
        private final Button isQuietCheckBox;

        Options1Composite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.usesStrictValidationCheckBox = this.buildUsesStrictValidationCheckBox(composite, this.buildUsesStrictValidationSelectionListener());
            this.makesReadOnlyCheckBox = this.buildMakesReadOnlyCheckBox(composite, this.buildMakesReadOnlySelectionListener());
            this.suppressesPackageInfoGenCheckBox = this.buildSuppressesPackageInfoGenCheckBox(composite, this.buildSuppressesPackageInfoGenSelectionListener());
            this.suppressesHeaderGenCheckBox = this.buildSuppressesHeaderGenCheckBox(composite, this.buildSuppressesHeaderGenSelectionListener());
            this.isVerboseCheckBox = this.buildIsVerboseCheckBox(composite, this.buildIsVerboseSelectionListener());
            this.isQuietCheckBox = this.buildIsQuietCheckBox(composite, this.buildIsQuietSelectionListener());
        }

        private Button buildUsesStrictValidationCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_useStrictValidation, listener, 5);
            checkBox.setSelection(this.usesStrictValidation());
            return checkBox;
        }

        private Button buildMakesReadOnlyCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_makeReadOnly, listener, 5);
            checkBox.setSelection(this.makesReadOnly());
            return checkBox;
        }

        private Button buildSuppressesPackageInfoGenCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_suppressPackageInfoGen, listener, 5);
            checkBox.setSelection(this.suppressesPackageInfoGen());
            return checkBox;
        }

        private Button buildSuppressesHeaderGenCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_suppressesHeaderGen, listener, 5);
            checkBox.setSelection(this.suppressesHeaderGen());
            return checkBox;
        }

        private Button buildIsVerboseCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_verbose, listener, 5);
            checkBox.setSelection(this.isVerbose());
            return checkBox;
        }

        private Button buildIsQuietCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_quiet, listener, 5);
            checkBox.setSelection(this.isQuiet());
            return checkBox;
        }

        private SelectionListener buildUsesStrictValidationSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options1Composite.this.setUsesStrictValidation(Options1Composite.this.usesStrictValidationCheckBox.getSelection());
                }
            };
        }

        private SelectionListener buildMakesReadOnlySelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options1Composite.this.setMakesReadOnly(Options1Composite.this.makesReadOnlyCheckBox.getSelection());
                }
            };
        }

        private SelectionListener buildSuppressesPackageInfoGenSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options1Composite.this.setSuppressesPackageInfoGen(Options1Composite.this.suppressesPackageInfoGenCheckBox.getSelection());
                }
            };
        }

        private SelectionListener buildSuppressesHeaderGenSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options1Composite.this.setSuppressesHeaderGen(Options1Composite.this.suppressesHeaderGenCheckBox.getSelection());
                }
            };
        }

        private SelectionListener buildIsVerboseSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options1Composite.this.setIsVerbose(Options1Composite.this.isVerboseCheckBox.getSelection());
                }
            };
        }

        private SelectionListener buildIsQuietSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options1Composite.this.setIsQuiet(Options1Composite.this.isQuietCheckBox.getSelection());
                }
            };
        }

        protected boolean usesStrictValidation() {
            return this.usesStrictValidation;
        }

        protected void setUsesStrictValidation(boolean usesStrictValidation) {
            this.usesStrictValidation = usesStrictValidation;
        }

        protected boolean makesReadOnly() {
            return this.makesReadOnly;
        }

        protected void setMakesReadOnly(boolean makesReadOnly) {
            this.makesReadOnly = makesReadOnly;
        }

        protected boolean suppressesPackageInfoGen() {
            return this.suppressesPackageInfoGen;
        }

        protected void setSuppressesPackageInfoGen(boolean suppressesPackageInfoGen) {
            this.suppressesPackageInfoGen = suppressesPackageInfoGen;
        }

        protected boolean suppressesHeaderGen() {
            return this.suppressesHeaderGen;
        }

        protected void setSuppressesHeaderGen(boolean suppressesHeaderGen) {
            this.suppressesHeaderGen = suppressesHeaderGen;
        }

        protected boolean isVerbose() {
            return this.isVerbose;
        }

        protected void setIsVerbose(boolean isVerbose) {
            this.isVerbose = isVerbose;
        }

        protected boolean isQuiet() {
            return this.isQuiet;
        }

        protected void setIsQuiet(boolean isQuiet) {
            this.isQuiet = isQuiet;
        }
    }

    class Options2Composite {
        private boolean treatsAsXmlSchema = false;
        private final Button treatsAsXmlSchemaCheckBox;
        private boolean treatsAsRelaxNg = false;
        private final Button treatsAsRelaxNgCheckBox;
        private boolean treatsAsRelaxNgCompact = false;
        private final Button treatsAsRelaxNgCompactCheckBox;
        private boolean treatsAsDtd = false;
        private final Button treatsAsDtdCheckBox;
        private boolean treatsAsWsdl = false;
        private final Button treatsAsWsdlCheckBox;
        private boolean showsVersion = false;
        private final Button showsVersionCheckBox;
        private boolean showsHelp = false;
        private final Button showsHelpCheckBox;

        Options2Composite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.treatsAsXmlSchemaCheckBox = this.buildTreatsAsXmlSchemaCheckBox(composite, this.buildTreatsAsXmlSchemaSelectionListener());
            this.treatsAsRelaxNgCheckBox = this.buildTreatsAsRelaxNgCheckBox(composite, this.buildTreatsAsRelaxNgSelectionListener());
            this.treatsAsRelaxNgCompactCheckBox = this.buildTreatsAsRelaxNgCompactCheckBox(composite, this.buildTreatsAsRelaxNgCompactSelectionListener());
            this.treatsAsDtdCheckBox = this.buildTreatsAsDtdCheckBox(composite, this.buildTreatsAsDtdSelectionListener());
            this.treatsAsWsdlCheckBox = this.buildTreatsAsWsdlCheckBox(composite, this.buildTreatsAsWsdlSelectionListener());
            this.showsVersionCheckBox = this.buildVersionCheckBox(composite, this.buildVersionSelectionListener());
            this.showsHelpCheckBox = this.buildHelpCheckBox(composite, this.buildHelpSelectionListener());
        }

        private Button buildTreatsAsXmlSchemaCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_treatsAsXmlSchema, listener, 5);
            checkBox.setSelection(this.treatsAsXmlSchema());
            return checkBox;
        }

        private Button buildTreatsAsRelaxNgCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_treatsAsRelaxNg, listener, 5);
            checkBox.setSelection(this.treatsAsRelaxNg());
            return checkBox;
        }

        private Button buildTreatsAsRelaxNgCompactCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_treatsAsRelaxNgCompact, listener, 5);
            checkBox.setSelection(this.treatsAsRelaxNgCompact());
            return checkBox;
        }

        private Button buildTreatsAsDtdCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_treatsAsDtd, listener, 5);
            checkBox.setSelection(this.treatsAsDtd());
            return checkBox;
        }

        private Button buildTreatsAsWsdlCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_treatsAsWsdl, listener, 5);
            checkBox.setSelection(this.treatsAsWsdl());
            return checkBox;
        }

        private Button buildVersionCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_showsVersion, listener, 5);
            checkBox.setSelection(this.showsVersion());
            return checkBox;
        }

        private Button buildHelpCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = ClassesGeneratorOptionsWizardPage.this.buildCheckBox(parent, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_showsHelp, listener, 5);
            checkBox.setSelection(this.showsHelp());
            return checkBox;
        }

        private SelectionListener buildTreatsAsXmlSchemaSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options2Composite.this.setTreatsAsXmlSchema(Options2Composite.this.treatsAsXmlSchemaCheckBox.getSelection());
                }
            };
        }

        private SelectionListener buildTreatsAsRelaxNgSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options2Composite.this.setTreatsAsRelaxNg(Options2Composite.this.treatsAsRelaxNgCheckBox.getSelection());
                }
            };
        }

        private SelectionListener buildTreatsAsRelaxNgCompactSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options2Composite.this.setTreatsAsRelaxNgCompact(Options2Composite.this.treatsAsRelaxNgCompactCheckBox.getSelection());
                }
            };
        }

        private SelectionListener buildTreatsAsDtdSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options2Composite.this.setTreatsAsDtd(Options2Composite.this.treatsAsDtdCheckBox.getSelection());
                }
            };
        }

        private SelectionListener buildTreatsAsWsdlSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options2Composite.this.setTreatsAsWsdl(Options2Composite.this.treatsAsWsdlCheckBox.getSelection());
                }
            };
        }

        private SelectionListener buildVersionSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options2Composite.this.setShowsVersion(Options2Composite.this.showsVersionCheckBox.getSelection());
                }
            };
        }

        private SelectionListener buildHelpSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    Options2Composite.this.setShowsHelp(Options2Composite.this.showsHelpCheckBox.getSelection());
                }
            };
        }

        protected boolean treatsAsXmlSchema() {
            return this.treatsAsXmlSchema;
        }

        protected void setTreatsAsXmlSchema(boolean treatsAsXmlSchema) {
            this.treatsAsXmlSchema = treatsAsXmlSchema;
        }

        protected boolean treatsAsRelaxNg() {
            return this.treatsAsRelaxNg;
        }

        protected void setTreatsAsRelaxNg(boolean treatsAsRelaxNg) {
            this.treatsAsRelaxNg = treatsAsRelaxNg;
        }

        protected boolean treatsAsRelaxNgCompact() {
            return this.treatsAsRelaxNgCompact;
        }

        protected void setTreatsAsRelaxNgCompact(boolean treatsAsRelaxNgCompact) {
            this.treatsAsRelaxNgCompact = treatsAsRelaxNgCompact;
        }

        protected boolean treatsAsDtd() {
            return this.treatsAsDtd;
        }

        protected void setTreatsAsDtd(boolean treatsAsDtd) {
            this.treatsAsDtd = treatsAsDtd;
        }

        protected boolean treatsAsWsdl() {
            return this.treatsAsWsdl;
        }

        protected void setTreatsAsWsdl(boolean treatsAsWsdl) {
            this.treatsAsWsdl = treatsAsWsdl;
        }

        protected boolean showsVersion() {
            return this.showsVersion;
        }

        protected void setShowsVersion(boolean showsVersion) {
            this.showsVersion = showsVersion;
        }

        protected boolean showsHelp() {
            return this.showsHelp;
        }

        protected void setShowsHelp(boolean showsHelp) {
            this.showsHelp = showsHelp;
        }
    }

    class ProxyOptionsComposite {
        private final Button noProxyRadioButton;
        private final Button proxyRadioButton;
        private final Text proxyText;
        private final Button proxyFileRadioButton;
        private final Text proxyFileText;
        private Button browseButton;

        private ProxyOptionsComposite(Composite parent) {
            Group proxyGroup = new Group(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            proxyGroup.setLayout((Layout)layout);
            proxyGroup.setLayoutData((Object)new GridData(768));
            proxyGroup.setText(JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_proxyGroup);
            SelectionListener proxyButtonListener = this.buildProxyRadioButtonListener();
            this.noProxyRadioButton = ClassesGeneratorOptionsWizardPage.this.buildRadioButton((Composite)proxyGroup, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_noProxy, proxyButtonListener, 3);
            this.proxyRadioButton = ClassesGeneratorOptionsWizardPage.this.buildRadioButton((Composite)proxyGroup, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_proxy, proxyButtonListener, 1);
            this.proxyText = ClassesGeneratorOptionsWizardPage.this.buildText((Composite)proxyGroup, 1);
            new Label((Composite)proxyGroup, 64);
            this.proxyFileRadioButton = ClassesGeneratorOptionsWizardPage.this.buildRadioButton((Composite)proxyGroup, JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_proxyFile, proxyButtonListener, 1);
            this.proxyFileText = ClassesGeneratorOptionsWizardPage.this.buildText((Composite)proxyGroup, 1);
            this.browseButton = this.buildBrowseButton((Composite)proxyGroup);
            this.noProxyRadioButton.setSelection(true);
            this.proxyButtonChanged();
        }

        private Button buildBrowseButton(Composite parent) {
            Composite buttonComposite = new Composite(parent, 0);
            GridLayout buttonLayout = new GridLayout(1, false);
            buttonComposite.setLayout((Layout)buttonLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 1;
            buttonComposite.setLayoutData((Object)gridData);
            Button browseButton = new Button(buttonComposite, 8);
            browseButton.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_browseButton);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            browseButton.setLayoutData((Object)gridData);
            browseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String filePath = ProxyOptionsComposite.this.promptProxyFile();
                    if (!StringTools.stringIsEmpty((String)filePath)) {
                        ProxyOptionsComposite.this.proxyFileText.setText(ClassesGeneratorOptionsWizardPage.this.makeRelativeToProjectPath(filePath));
                    }
                }
            });
            return browseButton;
        }

        private SelectionListener buildProxyRadioButtonListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    ProxyOptionsComposite.this.proxyButtonChanged();
                }
            };
        }

        private void proxyButtonChanged() {
            boolean usesProxy;
            boolean bl = usesProxy = !this.noProxyRadioButton.getSelection();
            if (usesProxy) {
                if (this.proxyRadioButton.getSelection()) {
                    this.proxyText.setEnabled(true);
                    ClassesGeneratorOptionsWizardPage.this.disableText(this.proxyFileText);
                    this.browseButton.setEnabled(false);
                } else if (this.proxyFileRadioButton.getSelection()) {
                    this.proxyFileText.setEnabled(true);
                    this.browseButton.setEnabled(true);
                    ClassesGeneratorOptionsWizardPage.this.disableText(this.proxyText);
                }
            } else {
                ClassesGeneratorOptionsWizardPage.this.disableText(this.proxyText);
                ClassesGeneratorOptionsWizardPage.this.disableText(this.proxyFileText);
                this.browseButton.setEnabled(false);
            }
        }

        private String promptProxyFile() {
            IWizard wizard = ClassesGeneratorOptionsWizardPage.this.getWizard();
            String projectPath = ((ClassesGeneratorWizard)wizard).getJavaProject().getProject().getLocation().toString();
            FileDialog dialog = new FileDialog(ClassesGeneratorOptionsWizardPage.this.getShell());
            dialog.setText(JptJaxbUiMessages.ClassesGeneratorOptionsWizardPage_chooseAProxyFile);
            dialog.setFilterPath(projectPath);
            return dialog.open();
        }

        protected String getProxy() {
            return this.proxyText.getText();
        }

        protected String getProxyFile() {
            return this.proxyFileText.getText();
        }
    }
}

