/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;

public class ReferenceResolver {
    public static final String KEY = "REFERENCE_RESOLVER";
    private ArrayList<Reference> references = new ArrayList();
    private HashMap<ReferenceKey, Object> referencedContainers = new HashMap();
    private ReferenceKey lookupKey = new ReferenceKey(null, null);

    public static ReferenceResolver getInstance(Session unitOfWork) {
        if (unitOfWork == null) {
            return null;
        }
        return (ReferenceResolver)unitOfWork.getProperty(KEY);
    }

    public void addReference(Reference ref) {
        this.references.add(ref);
    }

    private void createPKVectorsFromMap(Reference reference, XMLCollectionReferenceMapping mapping) {
        ClassDescriptor referenceDescriptor = mapping.getReferenceDescriptor();
        Vector<CacheId> pks = new Vector<CacheId>();
        if (null == referenceDescriptor) {
            CacheId pkVals = (CacheId)reference.getPrimaryKeyMap().get(null);
            if (null == pkVals) {
                return;
            }
            for (int x = 0; x < pkVals.getPrimaryKey().length; ++x) {
                Object[] values = new Object[]{pkVals.getPrimaryKey()[x]};
                pks.add(new CacheId(values));
            }
        } else {
            Vector<String> pkFields = referenceDescriptor.getPrimaryKeyFieldNames();
            if (pkFields.isEmpty()) {
                return;
            }
            boolean init = true;
            Iterator<String> pkFieldNameIt = pkFields.iterator();
            while (pkFieldNameIt.hasNext()) {
                int i;
                CacheId pkVals = (CacheId)reference.getPrimaryKeyMap().get(pkFieldNameIt.next());
                if (pkVals == null) {
                    return;
                }
                if (init) {
                    for (i = 0; i < pkVals.getPrimaryKey().length; ++i) {
                        pks.add(new CacheId(new Object[0]));
                    }
                    init = false;
                }
                for (i = 0; i < pkVals.getPrimaryKey().length; ++i) {
                    Object val = pkVals.getPrimaryKey()[i];
                    ((CacheId)pks.get(i)).add(val);
                }
            }
        }
        reference.setPrimaryKey(pks);
    }

    public Reference getReference(XMLObjectReferenceMapping mapping, Object sourceObject) {
        for (int x = 0; x < this.references.size(); ++x) {
            Reference reference = this.references.get(x);
            if (reference.getMapping() != mapping || reference.getSourceObject() != sourceObject) continue;
            return reference;
        }
        return null;
    }

    public Reference getReference(XMLObjectReferenceMapping mapping, Object sourceObject, XMLField xmlField) {
        XMLField targetField = (XMLField)mapping.getSourceToTargetKeyFieldAssociations().get(xmlField);
        String tgtXpath = null;
        if (mapping.getReferenceClass() != null && mapping.getReferenceClass() != Object.class && targetField != null) {
            tgtXpath = targetField.getXPath();
        }
        for (int x = 0; x < this.references.size(); ++x) {
            Reference reference = this.references.get(x);
            if (reference.getMapping() != mapping || reference.getSourceObject() != sourceObject || reference.getPrimaryKeyMap().get(tgtXpath) != null) continue;
            return reference;
        }
        return null;
    }

    public void resolveReferences(AbstractSession session) {
        int referencesSize = this.references.size();
        for (int x = 0; x < referencesSize; ++x) {
            XMLInverseReferenceMapping inverseReferenceMapping;
            Reference reference = this.references.get(x);
            Object referenceSourceObject = reference.getSourceObject();
            if (reference.getMapping() instanceof XMLCollectionReferenceMapping) {
                XMLCollectionReferenceMapping mapping = (XMLCollectionReferenceMapping)reference.getMapping();
                ContainerPolicy cPolicy = mapping.getContainerPolicy();
                Object container = this.getContainerForMapping(mapping, referenceSourceObject);
                if (container == null) {
                    container = mapping.getReuseContainer() ? mapping.getAttributeAccessor().getAttributeValueFromObject(referenceSourceObject) : cPolicy.containerInstance();
                    this.referencedContainers.put(new ReferenceKey(referenceSourceObject, mapping), container);
                }
                this.createPKVectorsFromMap(reference, mapping);
                Object value = null;
                if (!mapping.isWriteOnly()) {
                    for (CacheId primaryKey : (Vector)reference.getPrimaryKey()) {
                        value = this.getValue(session, reference, primaryKey);
                        if (value == null) continue;
                        cPolicy.addInto(value, container, session);
                    }
                }
                mapping.setAttributeValueInObject(referenceSourceObject, container);
                XMLInverseReferenceMapping inverseReferenceMapping2 = mapping.getInverseReferenceMapping();
                if (inverseReferenceMapping2 == null || value == null) continue;
                AttributeAccessor backpointerAccessor = inverseReferenceMapping2.getAttributeAccessor();
                ContainerPolicy backpointerContainerPolicy = inverseReferenceMapping2.getContainerPolicy();
                if (backpointerContainerPolicy == null) {
                    backpointerAccessor.setAttributeValueInObject(value, referenceSourceObject);
                    continue;
                }
                Object backpointerContainer = backpointerAccessor.getAttributeValueFromObject(value);
                if (backpointerContainer == null) {
                    backpointerContainer = backpointerContainerPolicy.containerInstance();
                    backpointerAccessor.setAttributeValueInObject(value, backpointerContainer);
                }
                backpointerContainerPolicy.addInto(referenceSourceObject, backpointerContainer, session);
                continue;
            }
            if (!(reference.getMapping() instanceof XMLObjectReferenceMapping)) continue;
            CacheId primaryKey = (CacheId)reference.getPrimaryKey();
            Object value = this.getValue(session, reference, primaryKey);
            XMLObjectReferenceMapping mapping = (XMLObjectReferenceMapping)reference.getMapping();
            if (value != null) {
                mapping.setAttributeValueInObject(reference.getSourceObject(), value);
            }
            if (null != reference.getSetting()) {
                reference.getSetting().setValue(value);
            }
            if ((inverseReferenceMapping = mapping.getInverseReferenceMapping()) == null) continue;
            AttributeAccessor backpointerAccessor = inverseReferenceMapping.getAttributeAccessor();
            ContainerPolicy backpointerContainerPolicy = inverseReferenceMapping.getContainerPolicy();
            if (backpointerContainerPolicy == null) {
                backpointerAccessor.setAttributeValueInObject(value, referenceSourceObject);
                continue;
            }
            Object backpointerContainer = backpointerAccessor.getAttributeValueFromObject(value);
            if (backpointerContainer == null) {
                backpointerContainer = backpointerContainerPolicy.containerInstance();
                backpointerAccessor.setAttributeValueInObject(value, backpointerContainer);
            }
            backpointerContainerPolicy.addInto(reference.getSourceObject(), backpointerContainer, session);
        }
        if (session.isUnitOfWork()) {
            ((UnitOfWork)((Object)session)).release();
        }
        this.references = new ArrayList();
        this.referencedContainers = new HashMap();
    }

    private Object getContainerForMapping(XMLCollectionReferenceMapping mapping, Object referenceSourceObject) {
        this.lookupKey.setMapping(mapping);
        this.lookupKey.setSourceObject(referenceSourceObject);
        return this.referencedContainers.get(this.lookupKey);
    }

    private Object getValue(AbstractSession session, Reference reference, CacheId primaryKey) {
        Class referenceTargetClass = reference.getTargetClass();
        if (null == referenceTargetClass || referenceTargetClass == ClassConstants.OBJECT) {
            for (ClassDescriptor entry : session.getDescriptors().values()) {
                Object value = null;
                XMLDescriptor targetDescriptor = (XMLDescriptor)entry;
                List<DatabaseField> pkFields = targetDescriptor.getPrimaryKeyFields();
                if (null == pkFields || 1 != pkFields.size()) continue;
                XMLField pkField = (XMLField)pkFields.get(0);
                Class targetType = (pkField = (XMLField)targetDescriptor.getTypedField(pkField)).getType();
                if (targetType == ClassConstants.STRING || targetType == ClassConstants.OBJECT) {
                    value = session.getIdentityMapAccessor().getFromIdentityMap(primaryKey, targetDescriptor.getJavaClass());
                } else {
                    try {
                        Object[] pkValues = primaryKey.getPrimaryKey();
                        Object[] convertedPkValues = new Object[pkValues.length];
                        for (int x = 0; x < pkValues.length; ++x) {
                            convertedPkValues[x] = session.getDatasourcePlatform().getConversionManager().convertObject(pkValues[x], targetType);
                        }
                        value = session.getIdentityMapAccessor().getFromIdentityMap(new CacheId(convertedPkValues), targetDescriptor.getJavaClass());
                    }
                    catch (ConversionException e) {
                        // empty catch block
                    }
                }
                if (null == value) continue;
                return value;
            }
            return null;
        }
        return session.getIdentityMapAccessor().getFromIdentityMap(primaryKey, referenceTargetClass);
    }

    private class ReferenceKey {
        private Object sourceObject;
        private XMLMapping mapping;

        public ReferenceKey(Object sourceObject, XMLMapping mapping) {
            this.sourceObject = sourceObject;
            this.mapping = mapping;
        }

        public Object getSourceObject() {
            return this.sourceObject;
        }

        public XMLMapping getMapping() {
            return this.mapping;
        }

        public void setSourceObject(Object obj) {
            this.sourceObject = obj;
        }

        public void setMapping(XMLMapping mapping) {
            this.mapping = mapping;
        }

        public int hashCode() {
            return this.mapping.hashCode() ^ this.sourceObject.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ReferenceKey key = (ReferenceKey)obj;
            return this.sourceObject == key.getSourceObject() && this.mapping == key.getMapping();
        }
    }
}

