/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryMethod
extends BinaryAttribute
implements JavaResourceMethod {
    private boolean constructor;
    private final Vector<String> parameterTypeNames = new Vector();

    BinaryMethod(JavaResourceType parent, IMethod method) {
        super(parent, new MethodAdapter(method));
    }

    @Override
    public JavaResourceAnnotatedElement.Kind getKind() {
        return JavaResourceAnnotatedElement.Kind.METHOD;
    }

    @Override
    public void update() {
        super.update();
        this.setConstructor(this.buildConstructor());
        this.setParameterTypeNames(this.buildParameterTypeNames());
    }

    IMethod getMember() {
        return (IMethod)super.getMember();
    }

    @Override
    public String getMethodName() {
        return this.getMember().getElementName();
    }

    @Override
    public ListIterable<String> getParameterTypeNames() {
        return new LiveCloneListIterable(this.parameterTypeNames);
    }

    @Override
    public String getParameterTypeName(int index) {
        return this.parameterTypeNames.get(index);
    }

    @Override
    public int getParametersSize() {
        return this.parameterTypeNames.size();
    }

    private List<String> buildParameterTypeNames() {
        ArrayList<String> names = new ArrayList<String>();
        ILocalVariable[] iLocalVariableArray = this.getParameters(this.getMember());
        int n = iLocalVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalVariable parameter = iLocalVariableArray[n2];
            names.add(parameter.getElementName());
            ++n2;
        }
        return names;
    }

    private ILocalVariable[] getParameters(IMethod jdtMethod) {
        try {
            return jdtMethod.getParameters();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return null;
        }
    }

    private void setParameterTypeNames(List<String> parameterTypeNames) {
        this.synchronizeList(parameterTypeNames, this.parameterTypeNames, "parameterTypeNames");
    }

    @Override
    public boolean isConstructor() {
        return this.constructor;
    }

    private void setConstructor(boolean isConstructor) {
        boolean old = this.constructor;
        this.constructor = isConstructor;
        this.firePropertyChanged("constructor", old, isConstructor);
    }

    private boolean buildConstructor() {
        try {
            return this.getMember().isConstructor();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean isFor(MethodSignature methodSignature, int occurrence) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodAdapter
    implements BinaryAttribute.Adapter {
        final IMethod method;
        static final IMethod[] EMPTY_METHOD_ARRAY = new IMethod[0];

        MethodAdapter(IMethod method) {
            this.method = method;
        }

        public IMethod getElement() {
            return this.method;
        }

        @Override
        public Iterable<ITypeParameter> getTypeParameters() {
            try {
                return new CompositeIterable(new Iterable[]{new ArrayIterable((Object[])this.method.getTypeParameters()), new ArrayIterable((Object[])this.method.getDeclaringType().getTypeParameters())});
            }
            catch (JavaModelException jme) {
                JptCommonCorePlugin.log(jme);
                return EmptyIterable.instance();
            }
        }

        @Override
        public IAnnotation[] getAnnotations() throws JavaModelException {
            return this.method.getAnnotations();
        }

        @Override
        public String getAttributeName() {
            return NameTools.convertGetterSetterMethodNameToPropertyName((String)this.method.getElementName());
        }

        @Override
        public String getTypeSignature() throws JavaModelException {
            return this.method.getReturnType();
        }
    }
}

