/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.common.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceMember<M extends Member>
extends SourceAnnotatedElement<M>
implements JavaResourceMember {
    boolean final_;
    boolean transient_;
    boolean public_;
    boolean static_;

    SourceMember(JavaResourceNode parent, M member) {
        super(parent, member);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        IBinding binding = ((Member)this.annotatedElement).getBinding(astRoot);
        this.final_ = this.buildFinal(binding);
        this.transient_ = this.buildTransient(binding);
        this.public_ = this.buildPublic(binding);
        this.static_ = this.buildStatic(binding);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        IBinding binding = ((Member)this.annotatedElement).getBinding(astRoot);
        this.syncFinal(this.buildFinal(binding));
        this.syncTransient(this.buildTransient(binding));
        this.syncPublic(this.buildPublic(binding));
        this.syncStatic(this.buildStatic(binding));
    }

    @Override
    public Annotation setPrimaryAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        ArrayList<String> annotationNames = new ArrayList<String>();
        CollectionTools.addAll(annotationNames, supportingAnnotationNames);
        if (primaryAnnotationName != null) {
            annotationNames.add(primaryAnnotationName);
        }
        for (Annotation annotation : this.getAnnotations()) {
            if (CollectionTools.contains(annotationNames, (Object)annotation.getAnnotationName())) continue;
            this.annotations.remove(annotation);
            annotation.removeAnnotation();
        }
        Iterator containers = this.annotationContainers.values().iterator();
        while (containers.hasNext()) {
            SourceAnnotatedElement.AnnotationContainer container = (SourceAnnotatedElement.AnnotationContainer)containers.next();
            if (container.getContainerAnnotation() != null) {
                if (CollectionTools.contains(annotationNames, (Object)container.getContainerAnnotation().getAnnotationName())) continue;
                containers.remove();
                container.getContainerAnnotation().removeAnnotation();
                continue;
            }
            String nestedAnnotatioName = container.getNestedAnnotationName();
            if (CollectionTools.contains(annotationNames, (Object)nestedAnnotatioName)) continue;
            containers.remove();
            ((NestableAnnotation)container.getNestedAnnotations().iterator().next()).removeAnnotation();
        }
        Annotation newPrimaryAnnotation = this.getAnnotation(primaryAnnotationName);
        if (primaryAnnotationName != null && newPrimaryAnnotation == null) {
            newPrimaryAnnotation = this.buildAnnotation(primaryAnnotationName);
            this.annotations.add(newPrimaryAnnotation);
            newPrimaryAnnotation.newAnnotation();
        }
        return newPrimaryAnnotation;
    }

    @Override
    public boolean isFinal() {
        return this.final_;
    }

    private void syncFinal(boolean astFinal) {
        boolean old = this.final_;
        this.final_ = astFinal;
        this.firePropertyChanged("final", old, astFinal);
    }

    private boolean buildFinal(IBinding binding) {
        return binding == null ? false : Modifier.isFinal((int)binding.getModifiers());
    }

    @Override
    public boolean isTransient() {
        return this.transient_;
    }

    private void syncTransient(boolean astTransient) {
        boolean old = this.transient_;
        this.transient_ = astTransient;
        this.firePropertyChanged("transient", old, astTransient);
    }

    private boolean buildTransient(IBinding binding) {
        return binding == null ? false : Modifier.isTransient((int)binding.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return this.public_;
    }

    private void syncPublic(boolean astPublic) {
        boolean old = this.public_;
        this.public_ = astPublic;
        this.firePropertyChanged("public", old, astPublic);
    }

    private boolean buildPublic(IBinding binding) {
        return binding == null ? false : Modifier.isPublic((int)binding.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return this.static_;
    }

    private void syncStatic(boolean astStatic) {
        boolean old = this.static_;
        this.static_ = astStatic;
        this.firePropertyChanged("static", old, astStatic);
    }

    private boolean buildStatic(IBinding binding) {
        return binding == null ? false : Modifier.isStatic((int)binding.getModifiers());
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        return ((Member)this.annotatedElement).matches(memberName, occurrence);
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
    }
}

