/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core;

import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.GenericJpaProjectManager;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.internal.GenericJpaPlatformFactory;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.platform.JpaPlatformManagerImpl;
import org.eclipse.jpt.jpa.core.platform.GenericPlatform;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JptJpaCorePlugin
extends Plugin {
    private volatile GenericJpaProjectManager jpaProjectManager;
    private volatile ServiceTracker<?, SAXParserFactory> parserTracker;
    private static volatile boolean flushPreferences = true;
    public static final String PLUGIN_ID = "org.eclipse.jpt.jpa.core";
    public static final String PLUGIN_ID_ = "org.eclipse.jpt.jpa.core.";
    public static final String LEGACY_PLUGIN_ID = "org.eclipse.jpt.core";
    public static final String LEGACY_PLUGIN_ID_ = "org.eclipse.jpt.core.";
    private static final String JPA_PLATFORM_PREF_KEY = "org.eclipse.jpt.core.platform";
    @Deprecated
    public static final String DEFAULT_JPA_PLATFORM_PREF_KEY = "defaultJpaPlatform";
    public static final String DEFAULT_JPA_PLATFORM_1_0_PREF_KEY = "defaultJpaPlatform_" + JpaFacet.VERSION_1_0.getVersionString();
    public static final String DEFAULT_JPA_PLATFORM_2_0_PREF_KEY = "defaultJpaPlatform_" + JpaFacet.VERSION_2_0.getVersionString();
    public static final String DISCOVER_ANNOTATED_CLASSES = "org.eclipse.jpt.jpa.core.discoverAnnotatedClasses";
    private static final String LEGACY_DISCOVER_ANNOTATED_CLASSES = "org.eclipse.jpt.core.discoverAnnotatedClasses";
    public static final String METAMODEL_SOURCE_FOLDER_NAME = "org.eclipse.jpt.jpa.core.metamodelSourceFolderName";
    private static final String LEGACY_METAMODEL_SOURCE_FOLDER_NAME = "org.eclipse.jpt.core.metamodelSourceFolderName";
    public static final QualifiedName DATA_SOURCE_CONNECTION_PROFILE_NAME = new QualifiedName("org.eclipse.jpt.jpa.core", "dataSource.connectionProfileName");
    public static final QualifiedName USER_OVERRIDE_DEFAULT_CATALOG = new QualifiedName("org.eclipse.jpt.jpa.core", "userOverrideDefaultCatalogName");
    public static final QualifiedName USER_OVERRIDE_DEFAULT_SCHEMA = new QualifiedName("org.eclipse.jpt.jpa.core", "userOverrideDefaultSchemaName");
    public static final String VALIDATION_MARKER_ID = "org.eclipse.jpt.jpa.core.jpaProblemMarker";
    public static final String VALIDATOR_ID = "org.eclipse.jpt.jpa.core.jpaValidator";
    public static final IContentType PERSISTENCE_XML_CONTENT_TYPE = JptJpaCorePlugin.getJpaContentType("persistence");
    public static final JptResourceType PERSISTENCE_XML_1_0_RESOURCE_TYPE = new JptResourceType(PERSISTENCE_XML_CONTENT_TYPE, "1.0");
    public static final JptResourceType PERSISTENCE_XML_2_0_RESOURCE_TYPE = new JptResourceType(PERSISTENCE_XML_CONTENT_TYPE, "2.0");
    public static final IContentType MAPPING_FILE_CONTENT_TYPE = JptJpaCorePlugin.getJpaContentType("mappingFile");
    public static final IContentType ORM_XML_CONTENT_TYPE = JptJpaCorePlugin.getJpaContentType("orm");
    public static final JptResourceType ORM_XML_1_0_RESOURCE_TYPE = new JptResourceType(ORM_XML_CONTENT_TYPE, "1.0");
    public static final JptResourceType ORM_XML_2_0_RESOURCE_TYPE = new JptResourceType(ORM_XML_CONTENT_TYPE, "2.0");
    public static final IProjectFacet WEB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    public static final IPath DEFAULT_PERSISTENCE_XML_RUNTIME_PATH = new Path("META-INF/persistence.xml");
    public static final IPath DEFAULT_ORM_XML_RUNTIME_PATH = new Path("META-INF/orm.xml");
    public static final String CONTENT_PREFIX = "org.eclipse.jpt.jpa.core.content";
    public static final String CONTENT_PREFIX_ = "org.eclipse.jpt.jpa.core.content.";
    private static JptJpaCorePlugin INSTANCE;

    private static IContentType getJpaContentType(String jpaContentType) {
        return JptJpaCorePlugin.getContentType(CONTENT_PREFIX_ + jpaContentType);
    }

    private static IContentType getContentType(String contentType) {
        return Platform.getContentTypeManager().getContentType(contentType);
    }

    public static JptJpaCorePlugin instance() {
        return INSTANCE;
    }

    public static JpaProjectManager getJpaProjectManager() {
        return INSTANCE.getJpaProjectManager_();
    }

    public static JpaProject getJpaProject(IProject project) {
        return JptJpaCorePlugin.getJpaProjectManager().getJpaProject(project);
    }

    public static JpaFile getJpaFile(IFile file) {
        return JptJpaCorePlugin.getJpaProjectManager().getJpaFile(file);
    }

    public static void rebuildJpaProject(IProject project) {
        JptJpaCorePlugin.getJpaProjectManager().rebuildJpaProject(project);
    }

    public static boolean projectHasWebFacet(IProject project) {
        return JptJpaCorePlugin.projectHasFacet(project, WEB_FACET);
    }

    private static boolean projectHasFacet(IProject project, IProjectFacet facet) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facet.getId());
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
            return false;
        }
    }

    public static JpaFile getJpaFile(IProject project, IPath runtimePath) {
        IFile xmlFile = JptCommonCorePlugin.getPlatformFile((IProject)project, (IPath)runtimePath);
        return xmlFile.exists() ? JptJpaCorePlugin.getJpaFile(xmlFile) : null;
    }

    public static IPath getJarRuntimeRootPath(IProject project) {
        return JptJpaCorePlugin.projectHasWebFacet(project) ? new Path("/WEB-INF") : new Path("/");
    }

    public static void initializeDefaultPreferences() {
        IEclipsePreferences node = JptJpaCorePlugin.getDefaultPreferences();
        JpaPlatformDescription defaultPlatform_1_0 = JpaPlatformManagerImpl.instance().getDefaultJpaPlatform(JpaFacet.VERSION_1_0);
        if (defaultPlatform_1_0 == null) {
            defaultPlatform_1_0 = GenericPlatform.VERSION_1_0;
        }
        node.put(DEFAULT_JPA_PLATFORM_1_0_PREF_KEY, defaultPlatform_1_0.getId());
        JpaPlatformDescription defaultPlatform_2_0 = JpaPlatformManagerImpl.instance().getDefaultJpaPlatform(JpaFacet.VERSION_2_0);
        if (defaultPlatform_2_0 == null) {
            defaultPlatform_2_0 = GenericPlatform.VERSION_2_0;
        }
        node.put(DEFAULT_JPA_PLATFORM_2_0_PREF_KEY, defaultPlatform_2_0.getId());
    }

    public static IEclipsePreferences getDefaultPreferences() {
        return JptJpaCorePlugin.getPreferences(DefaultScope.INSTANCE);
    }

    public static IEclipsePreferences getWorkspacePreferences() {
        return JptJpaCorePlugin.getPreferences(InstanceScope.INSTANCE);
    }

    public static void setWorkspacePreference(String preferenceKey, String preferenceValue) {
        IEclipsePreferences prefs = JptJpaCorePlugin.getWorkspacePreferences();
        prefs.put(preferenceKey, preferenceValue);
        JptJpaCorePlugin.flush(prefs);
    }

    public static IEclipsePreferences getProjectPreferences(IProject project) {
        return JptJpaCorePlugin.getPreferences((IScopeContext)new ProjectScope(project));
    }

    public static void setProjectPreference(IProject project, String preferenceKey, String preferenceValue) {
        IEclipsePreferences prefs = JptJpaCorePlugin.getProjectPreferences(project);
        if (preferenceValue == null) {
            prefs.remove(preferenceKey);
        } else {
            prefs.put(preferenceKey, preferenceValue);
        }
        JptJpaCorePlugin.flush(prefs);
    }

    public static void setProjectPreference(IProject project, String preferenceKey, boolean preferenceValue) {
        IEclipsePreferences prefs = JptJpaCorePlugin.getProjectPreferences(project);
        prefs.putBoolean(preferenceKey, preferenceValue);
        JptJpaCorePlugin.flush(prefs);
    }

    public static void clearProjectPreferences(IProject project) {
        JptJpaCorePlugin.clearProjectPreferences(project, JPA_PLATFORM_PREF_KEY, DISCOVER_ANNOTATED_CLASSES, METAMODEL_SOURCE_FOLDER_NAME, LEGACY_DISCOVER_ANNOTATED_CLASSES, LEGACY_METAMODEL_SOURCE_FOLDER_NAME);
    }

    public static void clearProjectPreferences(IProject project, String ... preferenceKeys) {
        IEclipsePreferences prefs = JptJpaCorePlugin.getProjectPreferences(project);
        String[] stringArray = preferenceKeys;
        int n = preferenceKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String preferenceKey = stringArray[n2];
            prefs.remove(preferenceKey);
            ++n2;
        }
        JptJpaCorePlugin.flush(prefs);
    }

    private static IEclipsePreferences getPreferences(IScopeContext context) {
        return context.getNode(LEGACY_PLUGIN_ID);
    }

    public static JpaPlatformDescription getDefaultJpaPlatform(IProjectFacetVersion jpaFacetVersion) {
        JpaPlatformDescription defaultPlatform = JptJpaCorePlugin.getDefaultJpaPlatform(jpaFacetVersion, new Preferences[]{JptJpaCorePlugin.getWorkspacePreferences(), JptJpaCorePlugin.getDefaultPreferences()});
        if (defaultPlatform == null) {
            defaultPlatform = JptJpaCorePlugin.getDefaultJpaPlatform(jpaFacetVersion, new Preferences[]{JptJpaCorePlugin.getDefaultPreferences()});
        }
        return defaultPlatform;
    }

    private static JpaPlatformDescription getDefaultJpaPlatform(IProjectFacetVersion jpaFacetVersion, Preferences ... nodes) {
        JpaPlatformDescription defaultDefaultPlatform = JptJpaCorePlugin.getDefaultJpaPlatform(jpaFacetVersion, DEFAULT_JPA_PLATFORM_PREF_KEY, null, nodes);
        String preferenceKey = null;
        if (jpaFacetVersion.equals(JpaFacet.VERSION_1_0)) {
            if (defaultDefaultPlatform == null) {
                defaultDefaultPlatform = GenericPlatform.VERSION_1_0;
            }
            preferenceKey = DEFAULT_JPA_PLATFORM_1_0_PREF_KEY;
        } else if (jpaFacetVersion.equals(JpaFacet.VERSION_2_0)) {
            if (defaultDefaultPlatform == null) {
                defaultDefaultPlatform = GenericPlatform.VERSION_2_0;
            }
            preferenceKey = DEFAULT_JPA_PLATFORM_2_0_PREF_KEY;
        } else {
            throw new IllegalArgumentException("Illegal JPA facet version: " + jpaFacetVersion);
        }
        return JptJpaCorePlugin.getDefaultJpaPlatform(jpaFacetVersion, preferenceKey, defaultDefaultPlatform, nodes);
    }

    private static JpaPlatformDescription getDefaultJpaPlatform(IProjectFacetVersion jpaFacetVersion, String preferenceKey, JpaPlatformDescription defaultDefault, Preferences ... nodes) {
        String defaultDefaultId = defaultDefault == null ? null : defaultDefault.getId();
        String defaultPlatformId = Platform.getPreferencesService().get(preferenceKey, defaultDefaultId, nodes);
        JpaPlatformDescription defaultPlatform = JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatform(defaultPlatformId);
        if (defaultPlatform != null && defaultPlatform.supportsJpaFacetVersion(jpaFacetVersion)) {
            return defaultPlatform;
        }
        if (defaultDefault != null && defaultDefault.supportsJpaFacetVersion(jpaFacetVersion)) {
            return defaultDefault;
        }
        return null;
    }

    public static JpaPlatformManager getJpaPlatformManager() {
        return JpaPlatformManagerImpl.instance();
    }

    public static void setDefaultJpaPlatformId(String jpaFacetVersion, String platformId) {
        String preferenceKey = null;
        if (JpaFacet.VERSION_1_0.getVersionString().equals(jpaFacetVersion)) {
            preferenceKey = DEFAULT_JPA_PLATFORM_1_0_PREF_KEY;
        } else if (JpaFacet.VERSION_2_0.getVersionString().equals(jpaFacetVersion)) {
            preferenceKey = DEFAULT_JPA_PLATFORM_2_0_PREF_KEY;
        } else {
            throw new IllegalArgumentException("Illegal JPA facet version: " + jpaFacetVersion);
        }
        JptJpaCorePlugin.setWorkspacePreference(preferenceKey, platformId);
    }

    public static String getJpaPlatformId(IProject project) {
        return JptJpaCorePlugin.getProjectPreferences(project).get(JPA_PLATFORM_PREF_KEY, GenericPlatform.VERSION_1_0.getId());
    }

    public static JpaPlatformDescription getJpaPlatformDescription(IProject project) {
        String jpaPlatformId = JptJpaCorePlugin.getJpaPlatformId(project);
        return JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatform(jpaPlatformId);
    }

    public static void setJpaPlatformId(IProject project, String jpaPlatformId) {
        JptJpaCorePlugin.setProjectPreference(project, JPA_PLATFORM_PREF_KEY, jpaPlatformId);
    }

    public static String getJpaPlatformIdPrefKey() {
        return JPA_PLATFORM_PREF_KEY;
    }

    public static boolean discoverAnnotatedClasses(IProject project) {
        if (JptJpaCorePlugin.getProjectPreferences(project).get(DISCOVER_ANNOTATED_CLASSES, null) != null) {
            return JptJpaCorePlugin.getProjectPreferences(project).getBoolean(DISCOVER_ANNOTATED_CLASSES, false);
        }
        return JptJpaCorePlugin.getProjectPreferences(project).getBoolean(LEGACY_DISCOVER_ANNOTATED_CLASSES, false);
    }

    public static void setDiscoverAnnotatedClasses(IProject project, boolean discoverAnnotatedClasses) {
        JptJpaCorePlugin.setProjectPreference(project, DISCOVER_ANNOTATED_CLASSES, discoverAnnotatedClasses);
    }

    public static String getMetamodelSourceFolderName(IProject project) {
        String metamodelSourceFolderName = JptJpaCorePlugin.getProjectPreferences(project).get(METAMODEL_SOURCE_FOLDER_NAME, null);
        if (metamodelSourceFolderName != null) {
            return metamodelSourceFolderName;
        }
        return JptJpaCorePlugin.getProjectPreferences(project).get(LEGACY_METAMODEL_SOURCE_FOLDER_NAME, null);
    }

    public static void setMetamodelSourceFolderName(IProject project, String metamodelSourceFolderName) {
        JptJpaCorePlugin.setProjectPreference(project, METAMODEL_SOURCE_FOLDER_NAME, metamodelSourceFolderName);
        if (metamodelSourceFolderName == null) {
            JptJpaCorePlugin.setProjectPreference(project, LEGACY_METAMODEL_SOURCE_FOLDER_NAME, null);
        }
    }

    private static void doNotFlushPreferences() {
        flushPreferences = false;
    }

    private static void flush(IEclipsePreferences prefs) {
        if (flushPreferences) {
            new PreferencesFlushJob(prefs).schedule();
        }
    }

    public static String getConnectionProfileName(IProject project) {
        try {
            String connectionProfileName = project.getPersistentProperty(DATA_SOURCE_CONNECTION_PROFILE_NAME);
            return StringTools.stringIsEmpty((String)connectionProfileName) ? null : connectionProfileName;
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
            return null;
        }
    }

    public static void setConnectionProfileName(IProject project, String connectionProfileName) {
        try {
            project.setPersistentProperty(DATA_SOURCE_CONNECTION_PROFILE_NAME, connectionProfileName);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    public static String getUserOverrideDefaultCatalog(IProject project) {
        try {
            return project.getPersistentProperty(USER_OVERRIDE_DEFAULT_CATALOG);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
            return null;
        }
    }

    public static void setUserOverrideDefaultCatalog(IProject project, String defaultCatalog) {
        try {
            project.setPersistentProperty(USER_OVERRIDE_DEFAULT_CATALOG, defaultCatalog);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    public static String getUserOverrideDefaultSchema(IProject project) {
        try {
            return project.getPersistentProperty(USER_OVERRIDE_DEFAULT_SCHEMA);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
            return null;
        }
    }

    public static void setUserOverrideDefaultSchema(IProject project, String defaultSchema) {
        try {
            project.setPersistentProperty(USER_OVERRIDE_DEFAULT_SCHEMA, defaultSchema);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    public static void clearProjectPersistentProperties(IProject project) {
        try {
            project.setPersistentProperty(DATA_SOURCE_CONNECTION_PROFILE_NAME, null);
            project.setPersistentProperty(USER_OVERRIDE_DEFAULT_CATALOG, null);
            project.setPersistentProperty(USER_OVERRIDE_DEFAULT_SCHEMA, null);
        }
        catch (CoreException ce) {
            JptJpaCorePlugin.log(ce);
        }
    }

    public static boolean nodeIsJpa2_0Compatible(JpaNode jpaNode) {
        return jpaNode.getJpaProject().getJpaPlatform().getJpaVersion().isCompatibleWithJpaVersion(JpaFacet.VERSION_2_0.getVersionString());
    }

    public static boolean nodeIsXml2_0Compatible(XmlContextNode xmlContextNode) {
        return GenericJpaPlatformFactory.SimpleVersion.JPA_VERSION_COMPARATOR.compare(xmlContextNode.getResourceType().getVersion(), "2.0") >= 0;
    }

    public static boolean javaElementChangeListenerIsActive() {
        return JptJpaCorePlugin.getJpaProjectManager().javaElementChangeListenerIsActive();
    }

    public static void setJavaElementChangeListenerIsActive(boolean javaElementChangeListenerIsActive) {
        JptJpaCorePlugin.getJpaProjectManager().setJavaElementChangeListenerIsActive(javaElementChangeListenerIsActive);
    }

    public static void log(String msg) {
        JptJpaCorePlugin.log(msg, null);
    }

    public static void log(Throwable throwable) {
        JptJpaCorePlugin.log(throwable.getLocalizedMessage(), throwable);
    }

    public static void log(String msg, Throwable throwable) {
        JptJpaCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, throwable));
    }

    public static void log(IStatus status) {
        INSTANCE.getLog().log(status);
    }

    public JptJpaCorePlugin() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.jpaProjectManager != null) {
                this.jpaProjectManager.stop();
                this.jpaProjectManager = null;
            }
            if (this.parserTracker != null) {
                this.parserTracker.close();
                this.parserTracker = null;
            }
        }
        finally {
            super.stop(context);
        }
    }

    private synchronized GenericJpaProjectManager getJpaProjectManager_() {
        if (this.jpaProjectManager == null) {
            this.jpaProjectManager = this.buildJpaProjectManager();
            this.jpaProjectManager.start();
        }
        return this.jpaProjectManager;
    }

    private GenericJpaProjectManager buildJpaProjectManager() {
        return new GenericJpaProjectManager();
    }

    public synchronized SAXParserFactory getSAXParserFactory() {
        SAXParserFactory factory = (SAXParserFactory)this.getParserTracker().getService();
        if (factory != null) {
            factory.setNamespaceAware(true);
        }
        return factory;
    }

    private ServiceTracker<?, SAXParserFactory> getParserTracker() {
        if (this.parserTracker == null) {
            this.parserTracker = this.buildParserTracker();
            this.parserTracker.open();
        }
        return this.parserTracker;
    }

    private ServiceTracker<?, SAXParserFactory> buildParserTracker() {
        return new ServiceTracker(this.getBundle().getBundleContext(), "javax.xml.parsers.SAXParserFactory", null);
    }

    private static class PreferencesFlushJob
    extends Job {
        private final IEclipsePreferences prefs;

        PreferencesFlushJob(IEclipsePreferences prefs) {
            super(NLS.bind((String)JptCoreMessages.PREFERENCES_FLUSH_JOB_NAME, (Object)prefs.absolutePath()));
            this.prefs = prefs;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.prefs.flush();
            }
            catch (BackingStoreException ex) {
                JptJpaCorePlugin.log(ex);
            }
            return Status.OK_STATUS;
        }
    }
}

