/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.jpa.core.EntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPlatformProvider;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaResourceModelProvider;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.ResourceDefinition;
import org.eclipse.jpt.jpa.core.context.java.DefaultJavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.internal.GenericEntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.db.JptJpaDbPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaPlatform
implements JpaPlatform {
    private final String id;
    private final JpaPlatform.Version jpaVersion;
    private final JpaFactory jpaFactory;
    private final AnnotationProvider annotationProvider;
    private final JpaPlatformProvider platformProvider;
    private final JpaPlatformVariation jpaVariation;

    public GenericJpaPlatform(String id, JpaPlatform.Version jpaVersion, JpaFactory jpaFactory, AnnotationProvider annotationProvider, JpaPlatformProvider platformProvider, JpaPlatformVariation jpaVariation) {
        this.id = id;
        this.jpaVersion = jpaVersion;
        this.jpaFactory = jpaFactory;
        this.annotationProvider = annotationProvider;
        this.jpaVariation = jpaVariation;
        this.platformProvider = platformProvider;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public JpaPlatformDescription getDescription() {
        return JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatform(this.getId());
    }

    @Override
    public JpaPlatform.Version getJpaVersion() {
        return this.jpaVersion;
    }

    @Override
    public JpaFactory getJpaFactory() {
        return this.jpaFactory;
    }

    protected JpaPlatformProvider getPlatformProvider() {
        return this.platformProvider;
    }

    @Override
    public JpaFile buildJpaFile(JpaProject jpaProject, IFile file) {
        IContentType contentType = PlatformTools.getContentType((IFile)file);
        return contentType == null ? null : this.buildJpaFile(jpaProject, file, contentType);
    }

    protected JpaFile buildJpaFile(JpaProject jpaProject, IFile file, IContentType contentType) {
        JptResourceModel resourceModel = this.buildResourceModel(jpaProject, file, contentType);
        return resourceModel == null ? null : this.jpaFactory.buildJpaFile(jpaProject, file, contentType, resourceModel);
    }

    protected JptResourceModel buildResourceModel(JpaProject jpaProject, IFile file, IContentType contentType) {
        JpaResourceModelProvider provider = this.getResourceModelProvider(contentType);
        return provider == null ? null : provider.buildResourceModel(jpaProject, file);
    }

    protected JpaResourceModelProvider getResourceModelProvider(IContentType contentType) {
        for (JpaResourceModelProvider provider : this.platformProvider.getResourceModelProviders()) {
            if (!contentType.equals(provider.getContentType())) continue;
            return provider;
        }
        return null;
    }

    @Override
    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    @Override
    public AnnotationEditFormatter getAnnotationEditFormatter() {
        return DefaultAnnotationEditFormatter.instance();
    }

    @Override
    public Iterable<JavaTypeMappingDefinition> getJavaTypeMappingDefinitions() {
        return this.platformProvider.getJavaTypeMappingDefinitions();
    }

    @Override
    public Iterable<JavaAttributeMappingDefinition> getSpecifiedJavaAttributeMappingDefinitions() {
        return this.platformProvider.getSpecifiedJavaAttributeMappingDefinitions();
    }

    @Override
    public Iterable<DefaultJavaAttributeMappingDefinition> getDefaultJavaAttributeMappingDefinitions() {
        return this.platformProvider.getDefaultJavaAttributeMappingDefinitions();
    }

    @Override
    public boolean supportsResourceType(JptResourceType resourceType) {
        for (ResourceDefinition resourceDefinition : this.platformProvider.getResourceDefinitions()) {
            if (!resourceDefinition.getResourceType().equals((Object)resourceType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResourceDefinition getResourceDefinition(JptResourceType resourceType) {
        for (ResourceDefinition resourceDefinition : this.platformProvider.getResourceDefinitions()) {
            if (!resourceDefinition.getResourceType().equals((Object)resourceType)) continue;
            return resourceDefinition;
        }
        throw new IllegalArgumentException("Illegal resource type: " + resourceType);
    }

    @Override
    public JptResourceType getMostRecentSupportedResourceType(IContentType contentType) {
        return this.platformProvider.getMostRecentSupportedResourceType(contentType);
    }

    @Override
    public ConnectionProfileFactory getConnectionProfileFactory() {
        return JptJpaDbPlugin.getConnectionProfileFactory();
    }

    @Override
    public EntityGeneratorDatabaseAnnotationNameBuilder getEntityGeneratorDatabaseAnnotationNameBuilder() {
        return GenericEntityGeneratorDatabaseAnnotationNameBuilder.instance();
    }

    @Override
    public JpaPlatformVariation getJpaVariation() {
        return this.jpaVariation;
    }
}

