/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.QueryHint;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaQueryHint;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.java.QueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaQuery<A extends QueryAnnotation>
extends AbstractJavaJpaContextNode
implements JavaQuery {
    protected final A queryAnnotation;
    protected String name;
    protected String query;
    protected final AbstractJpaNode.ContextListContainer<JavaQueryHint, QueryHintAnnotation> queryHintContainer;

    protected AbstractJavaQuery(JavaJpaContextNode parent, A queryAnnotation) {
        super(parent);
        this.queryAnnotation = queryAnnotation;
        this.name = queryAnnotation.getName();
        this.query = queryAnnotation.getQuery();
        this.queryHintContainer = this.buildHintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.queryAnnotation.getName());
        this.setQuery_(this.queryAnnotation.getQuery());
        this.syncHints();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getHints());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.queryAnnotation.setName(name);
        this.setName_(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        this.queryAnnotation.setQuery(query);
        this.setQuery_(query);
    }

    protected void setQuery_(String query) {
        String old = this.query;
        this.query = query;
        this.firePropertyChanged("query", old, query);
    }

    @Override
    public ListIterable<JavaQueryHint> getHints() {
        return this.queryHintContainer.getContextElements();
    }

    @Override
    public int getHintsSize() {
        return this.queryHintContainer.getContextElementsSize();
    }

    @Override
    public JavaQueryHint addHint() {
        return this.addHint(this.getHintsSize());
    }

    @Override
    public JavaQueryHint addHint(int index) {
        QueryHintAnnotation annotation = this.queryAnnotation.addHint(index);
        return (JavaQueryHint)this.queryHintContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeHint(QueryHint hint) {
        this.removeHint(this.queryHintContainer.indexOfContextElement((JavaQueryHint)hint));
    }

    @Override
    public void removeHint(int index) {
        this.queryAnnotation.removeHint(index);
        this.queryHintContainer.removeContextElement(index);
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.queryAnnotation.moveHint(targetIndex, sourceIndex);
        this.queryHintContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected JavaQueryHint buildHint(QueryHintAnnotation hintAnnotation) {
        return this.getJpaFactory().buildJavaQueryHint(this, hintAnnotation);
    }

    protected void syncHints() {
        this.queryHintContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<QueryHintAnnotation> getHintAnnotations() {
        return this.queryAnnotation.getHints();
    }

    protected AbstractJpaNode.ContextListContainer<JavaQueryHint, QueryHintAnnotation> buildHintContainer() {
        HintContainer container = new HintContainer();
        container.initialize();
        return container;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateName(messages, astRoot);
        this.validateQuery(messages, reporter, astRoot);
    }

    protected void validateName(List<IMessage> messages, CompilationUnit astRoot) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_NAME_UNDEFINED", EMPTY_STRING_ARRAY, this, this.getNameTextRange(astRoot)));
        }
    }

    protected void validateQuery(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (StringTools.stringIsEmpty((String)this.query)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_STATEMENT_UNDEFINED", new String[]{this.name}, this, this.getNameTextRange(astRoot)));
        } else {
            this.validateQuery_(messages, reporter, astRoot);
        }
    }

    protected abstract void validateQuery_(List<IMessage> var1, IReporter var2, CompilationUnit var3);

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.queryAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.queryAnnotation.getNameTextRange(astRoot), astRoot);
    }

    @Override
    public boolean isIdentical(Query query) {
        return StringTools.stringsAreEqual((String)this.getName(), (String)query.getName()) && StringTools.stringsAreEqual((String)this.getQuery(), (String)query.getQuery()) && this.hintsAreIdentical(query.getHints());
    }

    private boolean hintsAreIdentical(ListIterable<? extends QueryHint> hints) {
        boolean isIdentical = true;
        if (this.getHintsSize() != CollectionTools.size(hints)) {
            return false;
        }
        int i = 0;
        while (i < this.getHintsSize()) {
            if (!((JavaQueryHint)CollectionTools.get(this.getHints(), (int)i)).isIdentical((QueryHint)CollectionTools.get(hints, (int)i))) {
                isIdentical = false;
            }
            ++i;
        }
        return isIdentical;
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    public A getQueryAnnotation() {
        return this.queryAnnotation;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HintContainer
    extends AbstractJpaNode.ContextListContainer<JavaQueryHint, QueryHintAnnotation> {
        protected HintContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "hints";
        }

        @Override
        protected JavaQueryHint buildContextElement(QueryHintAnnotation resourceElement) {
            return AbstractJavaQuery.this.buildHint(resourceElement);
        }

        @Override
        protected ListIterable<QueryHintAnnotation> getResourceElements() {
            return AbstractJavaQuery.this.getHintAnnotations();
        }

        @Override
        protected QueryHintAnnotation getResourceElement(JavaQueryHint contextElement) {
            return contextElement.getQueryHintAnnotation();
        }
    }
}

