/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTableRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinTableContainer;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmJoinTableRelationshipStrategy
extends AbstractOrmXmlContextNode
implements OrmJoinTableRelationshipStrategy,
ReadOnlyTable.Owner {
    protected OrmJoinTable joinTable;

    protected AbstractOrmJoinTableRelationshipStrategy(OrmJoinTableRelationship parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        if (this.joinTable != null) {
            this.joinTable.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        this.updateJoinTable();
    }

    @Override
    public OrmJoinTable getJoinTable() {
        return this.joinTable;
    }

    protected void setJoinTable(OrmJoinTable joinTable) {
        OrmJoinTable old = this.joinTable;
        this.joinTable = joinTable;
        this.firePropertyChanged("joinTable", old, joinTable);
    }

    protected void updateJoinTable() {
        if (this.buildsJoinTable()) {
            if (this.joinTable == null) {
                this.setJoinTable(this.buildJoinTable());
            } else {
                this.joinTable.update();
            }
        } else if (this.joinTable != null) {
            this.setJoinTable(null);
        }
    }

    protected boolean buildsJoinTable() {
        return this.getXmlJoinTable() != null || this.getRelationship().mayHaveDefaultJoinTable();
    }

    protected OrmJoinTable buildJoinTable() {
        return this.getContextNodeFactory().buildOrmJoinTable(this, this);
    }

    @Override
    public XmlJoinTable getXmlJoinTable() {
        return this.getXmlJoinTableContainer().getJoinTable();
    }

    @Override
    public XmlJoinTable buildXmlJoinTable() {
        XmlJoinTable xmlJoinTable = OrmFactory.eINSTANCE.createXmlJoinTable();
        this.getXmlJoinTableContainer().setJoinTable(xmlJoinTable);
        return xmlJoinTable;
    }

    @Override
    public void removeXmlJoinTable() {
        this.getXmlJoinTableContainer().setJoinTable(null);
    }

    protected XmlJoinTableContainer getXmlJoinTableContainer() {
        return this.getRelationship().getXmlContainer();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.joinTable != null) {
            this.joinTable.validate(messages, reporter);
        }
    }

    @Override
    public OrmJoinTableRelationship getParent() {
        return (OrmJoinTableRelationship)super.getParent();
    }

    @Override
    public OrmJoinTableRelationship getRelationship() {
        return this.getParent();
    }

    protected RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public void initializeFrom(ReadOnlyJoinTableRelationshipStrategy oldStrategy) {
        ReadOnlyJoinTable oldJoinTable = oldStrategy.getJoinTable();
        if (oldJoinTable != null) {
            this.addStrategy();
            this.joinTable.initializeFrom(oldJoinTable);
        }
    }

    @Override
    public void initializeFromVirtual(ReadOnlyJoinTableRelationshipStrategy virtualStrategy) {
        ReadOnlyJoinTable oldJoinTable = virtualStrategy.getJoinTable();
        if (oldJoinTable != null) {
            this.addStrategy();
            this.joinTable.initializeFromVirtual(oldJoinTable);
        }
    }

    @Override
    public String getTableName() {
        return this.joinTable == null ? null : this.joinTable.getName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return this.joinTable == null ? null : this.joinTable.getDbTable();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return Tools.valuesAreDifferent((Object)this.getTableName(), (Object)tableName);
    }

    @Override
    public String getColumnTableNotValidDescription() {
        return JpaValidationDescriptionMessages.DOES_NOT_MATCH_JOIN_TABLE;
    }

    @Override
    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this.getRelationship());
    }

    @Override
    public void addStrategy() {
        if (this.joinTable == null) {
            this.setJoinTable(this.buildJoinTable());
            this.buildXmlJoinTable();
        }
    }

    @Override
    public void removeStrategy() {
        if (this.joinTable != null) {
            this.setJoinTable(null);
            this.removeXmlJoinTable();
        }
    }
}

