/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.TableTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmTableTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.orm.AbstractXmlTable;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.jpa.core.resource.xml.AbstractJpaEObject;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmTable<X extends AbstractXmlTable>
extends AbstractOrmXmlContextNode
implements OrmTable,
ReadOnlyUniqueConstraint.Owner {
    protected final ReadOnlyTable.Owner owner;
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected final AbstractJpaNode.ContextListContainer<OrmUniqueConstraint, XmlUniqueConstraint> uniqueConstraintContainer;

    protected AbstractOrmTable(XmlContextNode parent, ReadOnlyTable.Owner owner) {
        this(parent, owner, null);
    }

    protected AbstractOrmTable(XmlContextNode parent, ReadOnlyTable.Owner owner, X xmlTable) {
        super(parent);
        this.owner = owner;
        this.setXmlTable(xmlTable);
        this.specifiedName = this.buildSpecifiedName();
        this.specifiedSchema = this.buildSpecifiedSchema();
        this.specifiedCatalog = this.buildSpecifiedCatalog();
        this.uniqueConstraintContainer = this.buildUniqueConstraintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(this.buildSpecifiedName());
        this.setSpecifiedSchema_(this.buildSpecifiedSchema());
        this.setSpecifiedCatalog_(this.buildSpecifiedCatalog());
        this.syncUniqueConstraints();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getUniqueConstraints());
    }

    protected abstract X getXmlTable();

    protected void setXmlTable(X xmlTable) {
        if (xmlTable != null) {
            throw new IllegalArgumentException("this method must be overridden if the XML table is not null: " + xmlTable);
        }
    }

    protected X getXmlTableForUpdate() {
        X xmlTable = this.getXmlTable();
        return xmlTable != null ? xmlTable : this.buildXmlTable();
    }

    protected abstract X buildXmlTable();

    protected void removeXmlTableIfUnset() {
        if (((AbstractJpaEObject)this.getXmlTable()).isUnset()) {
            this.removeXmlTable();
        }
    }

    protected abstract void removeXmlTable();

    @Override
    public boolean isSpecifiedInResource() {
        return this.getXmlTable() != null;
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        if (this.valuesAreDifferent(this.specifiedName, name)) {
            X xmlTable = this.getXmlTableForUpdate();
            this.setSpecifiedName_(name);
            ((AbstractXmlTable)xmlTable).setName(name);
            this.removeXmlTableIfUnset();
        }
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)xmlTable).getName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected abstract String buildDefaultName();

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        if (this.valuesAreDifferent(this.specifiedSchema, schema)) {
            X xmlTable = this.getXmlTableForUpdate();
            this.setSpecifiedSchema_(schema);
            ((AbstractXmlTable)xmlTable).setSchema(schema);
            this.removeXmlTableIfUnset();
        }
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected String buildSpecifiedSchema() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)xmlTable).getSchema();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected abstract String buildDefaultSchema();

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        if (this.valuesAreDifferent(this.specifiedCatalog, catalog)) {
            X xmlTable = this.getXmlTableForUpdate();
            this.setSpecifiedCatalog_(catalog);
            ((AbstractXmlTable)xmlTable).setCatalog(catalog);
            this.removeXmlTableIfUnset();
        }
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected String buildSpecifiedCatalog() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)xmlTable).getCatalog();
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected abstract String buildDefaultCatalog();

    @Override
    public ListIterable<OrmUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraintContainer.getContextElements();
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintContainer.getContextElementsSize();
    }

    @Override
    public OrmUniqueConstraint getUniqueConstraint(int index) {
        return this.uniqueConstraintContainer.getContextElement(index);
    }

    @Override
    public OrmUniqueConstraint addUniqueConstraint() {
        return this.addUniqueConstraint(this.getUniqueConstraintsSize());
    }

    @Override
    public OrmUniqueConstraint addUniqueConstraint(int index) {
        X xmlTable = this.getXmlTableForUpdate();
        XmlUniqueConstraint xmlConstraint = this.buildXmlUniqueConstraint();
        OrmUniqueConstraint constraint = (OrmUniqueConstraint)this.uniqueConstraintContainer.addContextElement(index, xmlConstraint);
        ((AbstractXmlTable)xmlTable).getUniqueConstraints().add(index, (Object)xmlConstraint);
        return constraint;
    }

    protected XmlUniqueConstraint buildXmlUniqueConstraint() {
        return OrmFactory.eINSTANCE.createXmlUniqueConstraint();
    }

    @Override
    public void removeUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraintContainer.indexOfContextElement((OrmUniqueConstraint)uniqueConstraint));
    }

    @Override
    public void removeUniqueConstraint(int index) {
        this.uniqueConstraintContainer.removeContextElement(index);
        ((AbstractXmlTable)this.getXmlTable()).getUniqueConstraints().remove(index);
        this.removeXmlTableIfUnset();
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.uniqueConstraintContainer.moveContextElement(targetIndex, sourceIndex);
        ((AbstractXmlTable)this.getXmlTable()).getUniqueConstraints().move(targetIndex, sourceIndex);
    }

    protected OrmUniqueConstraint buildUniqueConstraint(XmlUniqueConstraint xmlConstraint) {
        return this.getContextNodeFactory().buildOrmUniqueConstraint(this, this, xmlConstraint);
    }

    protected void syncUniqueConstraints() {
        this.uniqueConstraintContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlUniqueConstraint> getXmlUniqueConstraints() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? EmptyListIterable.instance() : new LiveCloneListIterable(((AbstractXmlTable)xmlTable).getUniqueConstraints());
    }

    protected AbstractJpaNode.ContextListContainer<OrmUniqueConstraint, XmlUniqueConstraint> buildUniqueConstraintContainer() {
        UniqueConstraintContainer container = new UniqueConstraintContainer();
        container.initialize();
        return container;
    }

    @Override
    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getName());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    @Override
    public boolean schemaIsResolved() {
        return this.getDbSchema() != null;
    }

    @Override
    public boolean catalogIsResolved() {
        String catalog = this.getCatalog();
        return catalog == null || this.resolveDbCatalog(catalog) != null;
    }

    @Override
    public Iterable<String> getCandidateUniqueConstraintColumnNames() {
        Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.buildTableValidator().validate(messages, reporter);
    }

    protected JptValidator buildTableValidator() {
        return this.owner.buildTableValidator(this, this.buildTextRangeResolver());
    }

    protected TableTextRangeResolver buildTextRangeResolver() {
        return new OrmTableTextRangeResolver(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlTableValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    protected TextRange getXmlTableValidationTextRange() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractJpaEObject)xmlTable).getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.getXmlTableNameTextRange());
    }

    protected TextRange getXmlTableNameTextRange() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)xmlTable).getNameTextRange();
    }

    @Override
    public TextRange getSchemaTextRange() {
        return this.getValidationTextRange(this.getXmlTableSchemaTextRange());
    }

    protected TextRange getXmlTableSchemaTextRange() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)xmlTable).getSchemaTextRange();
    }

    @Override
    public TextRange getCatalogTextRange() {
        return this.getValidationTextRange(this.getXmlTableCatalogTextRange());
    }

    protected TextRange getXmlTableCatalogTextRange() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)xmlTable).getCatalogTextRange();
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    protected void initializeFrom(ReadOnlyTable oldTable) {
        this.setSpecifiedName(oldTable.getSpecifiedName());
        this.setSpecifiedCatalog(oldTable.getSpecifiedCatalog());
        this.setSpecifiedSchema(oldTable.getSpecifiedSchema());
        for (ReadOnlyUniqueConstraint constraint : oldTable.getUniqueConstraints()) {
            this.addUniqueConstraint().initializeFrom(constraint);
        }
    }

    protected void initializeFromVirtual(ReadOnlyTable virtualTable) {
        this.setSpecifiedName(virtualTable.getName());
    }

    public void toString(StringBuilder sb) {
        sb.append(this.buildQualifiedName());
    }

    protected String buildQualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName((String)this.getCatalog(), (String)this.getSchema(), (String)this.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UniqueConstraintContainer
    extends AbstractJpaNode.ContextListContainer<OrmUniqueConstraint, XmlUniqueConstraint> {
        protected UniqueConstraintContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "uniqueConstraints";
        }

        @Override
        protected OrmUniqueConstraint buildContextElement(XmlUniqueConstraint resourceElement) {
            return AbstractOrmTable.this.buildUniqueConstraint(resourceElement);
        }

        @Override
        protected ListIterable<XmlUniqueConstraint> getResourceElements() {
            return AbstractOrmTable.this.getXmlUniqueConstraints();
        }

        @Override
        protected XmlUniqueConstraint getResourceElement(OrmUniqueConstraint contextElement) {
            return contextElement.getXmlUniqueConstraint();
        }
    }
}

