/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.java.Accessor;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.FieldAccessor;
import org.eclipse.jpt.jpa.core.internal.context.java.PropertyAccessor;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaPersistentAttribute2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmReadOnlyPersistentAttribute2_0;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualOrmPersistentAttribute
extends AbstractOrmXmlContextNode
implements OrmReadOnlyPersistentAttribute2_0 {
    protected final Accessor javaAccessor;
    protected final JavaPersistentAttribute annotatedJavaAttribute;
    protected JavaPersistentAttribute originalJavaAttribute;
    protected StateChangeListener originalJavaAttributeListener;
    protected JavaPersistentAttribute unannotatedJavaAttribute;
    protected JavaAttributeMapping mapping;

    public VirtualOrmPersistentAttribute(OrmPersistentType parent, JavaResourceField resourceField) {
        super(parent);
        this.javaAccessor = new FieldAccessor(this, resourceField);
        this.annotatedJavaAttribute = this.buildAnnotatedJavaAttribute();
        this.mapping = this.buildMapping();
    }

    public VirtualOrmPersistentAttribute(OrmPersistentType parent, JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        super(parent);
        this.javaAccessor = new PropertyAccessor(this, resourceGetter, resourceSetter);
        this.annotatedJavaAttribute = this.buildAnnotatedJavaAttribute();
        this.mapping = this.buildMapping();
    }

    public VirtualOrmPersistentAttribute(OrmPersistentType parent, Accessor javaAccessor) {
        super(parent);
        this.javaAccessor = javaAccessor;
        this.annotatedJavaAttribute = this.buildAnnotatedJavaAttribute();
        this.mapping = this.buildMapping();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncLocalJavaAttributes();
    }

    @Override
    public void update() {
        super.update();
        this.updateOriginalJavaAttribute();
        this.updateLocalJavaAttributes();
        this.setMapping(this.buildMapping());
    }

    @Override
    public JavaAttributeMapping getMapping() {
        return this.mapping;
    }

    protected void setMapping(JavaAttributeMapping mapping) {
        JavaAttributeMapping old = this.mapping;
        this.mapping = mapping;
        this.firePropertyChanged("defaultMappingKey", old, mapping);
    }

    protected JavaAttributeMapping buildMapping() {
        return this.getJavaPersistentAttribute().getMapping();
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public String getDefaultMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public String getName() {
        return this.mapping.getName();
    }

    @Override
    public JavaPersistentAttribute getJavaPersistentAttribute() {
        return this.getOwningTypeMapping().isMetadataComplete() ? this.getUnannotatedJavaAttribute() : this.annotatedJavaAttribute;
    }

    @Override
    public JavaPersistentAttribute resolveJavaPersistentAttribute() {
        JavaPersistentType javaType = this.getOwningPersistentType().getJavaPersistentType();
        return javaType == null ? null : javaType.getAttributeFor(this.getJavaResourceAttribute());
    }

    protected JavaPersistentAttribute2_0 getJavaPersistentAttribute2_0() {
        return (JavaPersistentAttribute2_0)this.getJavaPersistentAttribute();
    }

    protected JavaPersistentAttribute buildAnnotatedJavaAttribute() {
        return this.buildJavaAttribute(this.javaAccessor);
    }

    protected JavaPersistentAttribute getUnannotatedJavaAttribute() {
        if (this.unannotatedJavaAttribute == null) {
            this.unannotatedJavaAttribute = this.buildUnannotatedJavaAttribute();
        }
        return this.unannotatedJavaAttribute;
    }

    protected JavaPersistentAttribute buildUnannotatedJavaAttribute() {
        return this.javaAccessor.buildUnannotatedJavaAttribute(this.getOwningPersistentType());
    }

    protected JavaPersistentAttribute buildJavaAttribute(Accessor accessor) {
        return this.getJpaFactory().buildJavaPersistentAttribute(this.getOwningPersistentType(), accessor);
    }

    protected void syncLocalJavaAttributes() {
        this.annotatedJavaAttribute.synchronizeWithResourceModel();
        if (this.unannotatedJavaAttribute != null) {
            this.unannotatedJavaAttribute.synchronizeWithResourceModel();
        }
    }

    protected void updateLocalJavaAttributes() {
        this.annotatedJavaAttribute.update();
        if (this.unannotatedJavaAttribute != null) {
            this.unannotatedJavaAttribute.update();
        }
    }

    public Accessor getJavaAccessor() {
        return this.javaAccessor;
    }

    @Override
    public JavaResourceAttribute getJavaResourceAttribute() {
        return this.javaAccessor.getResourceAttribute();
    }

    @Override
    public boolean isFor(JavaResourceField javaResourceField) {
        return this.javaAccessor.isFor(javaResourceField);
    }

    @Override
    public boolean isFor(JavaResourceMethod javaResourceGetter, JavaResourceMethod javaResourceSetter) {
        return this.javaAccessor.isFor(javaResourceGetter, javaResourceSetter);
    }

    protected void updateOriginalJavaAttribute() {
        JavaPersistentAttribute newJavaAttribute = this.resolveJavaPersistentAttribute();
        if (newJavaAttribute != this.originalJavaAttribute) {
            if (newJavaAttribute == null) {
                this.originalJavaAttribute.removeStateChangeListener(this.getOriginalJavaAttributeListener());
                this.originalJavaAttribute = null;
            } else {
                if (this.originalJavaAttribute != null) {
                    this.originalJavaAttribute.removeStateChangeListener(this.getOriginalJavaAttributeListener());
                }
                this.originalJavaAttribute = newJavaAttribute;
                this.originalJavaAttribute.addStateChangeListener(this.getOriginalJavaAttributeListener());
            }
        }
    }

    protected StateChangeListener getOriginalJavaAttributeListener() {
        if (this.originalJavaAttributeListener == null) {
            this.originalJavaAttributeListener = this.buildOriginalJavaAttributeListener();
        }
        return this.originalJavaAttributeListener;
    }

    protected StateChangeListener buildOriginalJavaAttributeListener() {
        return new StateChangeListener(){

            public void stateChanged(StateChangeEvent event) {
                VirtualOrmPersistentAttribute.this.originalJavaAttributeChanged();
            }
        };
    }

    protected void originalJavaAttributeChanged() {
        this.syncLocalJavaAttributes();
    }

    @Override
    public AccessType getAccess() {
        return this.getJavaPersistentAttribute().getAccess();
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    public OrmReadOnlyPersistentAttribute convertToVirtual() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OrmPersistentAttribute convertToSpecified() {
        if (this.mapping.getKey() == null) {
            throw new IllegalStateException("Use convertToSpecified(String) instead and specify a mapping type");
        }
        return this.getOwningPersistentType().convertAttributeToSpecified(this);
    }

    @Override
    public OrmPersistentAttribute convertToSpecified(String mappingKey) {
        return this.getOwningPersistentType().convertAttributeToSpecified(this, mappingKey);
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.jpa.core.orm.persistentAttribute";
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        return this;
    }

    @Override
    public boolean contains(int textOffset) {
        return false;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return null;
    }

    @Override
    public void dispose() {
        if (this.originalJavaAttribute != null) {
            this.originalJavaAttribute.removeStateChangeListener(this.getOriginalJavaAttributeListener());
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.getJavaPersistentAttribute().validate(messages, reporter, null);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getOwningTypeMapping().getAttributesTextRange();
    }

    @Override
    public String getMetamodelContainerFieldTypeName() {
        return this.getJavaPersistentAttribute2_0().getMetamodelContainerFieldTypeName();
    }

    @Override
    public String getMetamodelContainerFieldMapKeyTypeName() {
        return this.getJavaPersistentAttribute2_0().getMetamodelContainerFieldMapKeyTypeName();
    }

    @Override
    public String getMetamodelTypeName() {
        return this.getJavaPersistentAttribute2_0().getMetamodelTypeName();
    }

    @Override
    public OrmPersistentType getParent() {
        return (OrmPersistentType)super.getParent();
    }

    @Override
    public OrmPersistentType getOwningPersistentType() {
        return this.getParent();
    }

    @Override
    public OrmTypeMapping getOwningTypeMapping() {
        return this.getOwningPersistentType().getMapping();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.mapping.getPrimaryKeyColumnName();
    }

    @Override
    public String getTypeName() {
        return this.getJavaPersistentAttribute().getTypeName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

