/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaReadOnlyUniqueConstraint;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaUniqueConstraint
extends AbstractJavaReadOnlyUniqueConstraint
implements JavaUniqueConstraint {
    protected ReadOnlyUniqueConstraint.Owner owner;
    protected final UniqueConstraintAnnotation uniqueConstraintAnnotation;

    public GenericJavaUniqueConstraint(JavaJpaContextNode parent, ReadOnlyUniqueConstraint.Owner owner, UniqueConstraintAnnotation uniqueConstraintAnnotation) {
        super(parent);
        this.owner = owner;
        this.uniqueConstraintAnnotation = uniqueConstraintAnnotation;
        this.initializeColumnNames();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncColumnNames();
    }

    @Override
    public void addColumnName(String columnName) {
        this.addColumnName(this.columnNames.size(), columnName);
    }

    @Override
    public void addColumnName(int index, String columnName) {
        this.uniqueConstraintAnnotation.addColumnName(index, columnName);
        this.addItemToList(index, columnName, this.columnNames, "columnNames");
    }

    @Override
    public void removeColumnName(String columnName) {
        this.removeColumnName(this.columnNames.indexOf(columnName));
    }

    @Override
    public void removeColumnName(int index) {
        this.uniqueConstraintAnnotation.removeColumnName(index);
        this.removeItemFromList(index, this.columnNames, "columnNames");
    }

    @Override
    public void moveColumnName(int targetIndex, int sourceIndex) {
        this.uniqueConstraintAnnotation.moveColumnName(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.columnNames, "columnNames");
    }

    protected void initializeColumnNames() {
        for (String columnName : this.getResourceColumnNames()) {
            this.columnNames.add(columnName);
        }
    }

    @Override
    protected Iterable<String> getResourceColumnNames() {
        return this.uniqueConstraintAnnotation.getColumnNames();
    }

    @Override
    protected Iterable<String> getConnectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getConnectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.columnNamesTouches(pos, astRoot)) {
            return this.javaCandidateColumnNames(filter);
        }
        return null;
    }

    protected boolean columnNamesTouches(int pos, CompilationUnit astRoot) {
        return this.uniqueConstraintAnnotation.columnNamesTouches(pos, astRoot);
    }

    protected Iterable<String> javaCandidateColumnNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateColumnNames(filter));
    }

    protected Iterable<String> getCandidateColumnNames(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateColumnNames(), filter);
    }

    protected Iterable<String> getCandidateColumnNames() {
        return this.owner.getCandidateUniqueConstraintColumnNames();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.uniqueConstraintAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    @Override
    public boolean isIdentical(JavaUniqueConstraint javaUniqueConstraint) {
        return this.columnNamesAreIdentical(javaUniqueConstraint.getColumnNames());
    }

    private boolean columnNamesAreIdentical(Iterable<String> columnNames) {
        boolean isIdentical = true;
        if (this.getColumnNamesSize() != CollectionTools.size(columnNames)) {
            return false;
        }
        int i = 0;
        while (i < this.getColumnNamesSize()) {
            if (!StringTools.stringsAreEqual((String)((String)CollectionTools.get(this.getColumnNames(), (int)i)), (String)((String)CollectionTools.get(columnNames, (int)i)))) {
                isIdentical = false;
            }
            ++i;
        }
        return isIdentical;
    }

    @Override
    public UniqueConstraintAnnotation getUniqueConstraintAnnotation() {
        return this.uniqueConstraintAnnotation;
    }

    @Override
    public void initializeFrom(ReadOnlyUniqueConstraint oldUniqueConstraint) {
        for (String columnName : oldUniqueConstraint.getColumnNames()) {
            this.addColumnName(columnName);
        }
    }
}

