/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.GenerationType;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmGeneratedValue;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.orm.XmlGeneratedValue;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmGeneratedValue
extends AbstractOrmXmlContextNode
implements OrmGeneratedValue {
    protected final XmlGeneratedValue xmlGeneratedValue;
    protected GenerationType specifiedStrategy;
    protected GenerationType defaultStrategy;
    protected String specifiedGenerator;
    protected String defaultGenerator;

    public GenericOrmGeneratedValue(XmlContextNode parent, XmlGeneratedValue xmlGeneratedValue) {
        super(parent);
        this.xmlGeneratedValue = xmlGeneratedValue;
        this.specifiedStrategy = this.buildSpecifiedStrategy();
        this.specifiedGenerator = xmlGeneratedValue.getGenerator();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedStrategy_(this.buildSpecifiedStrategy());
        this.setSpecifiedGenerator_(this.xmlGeneratedValue.getGenerator());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultStrategy(this.buildDefaultStrategy());
        this.setDefaultGenerator(this.buildDefaultGenerator());
    }

    @Override
    public GenerationType getStrategy() {
        return this.specifiedStrategy != null ? this.specifiedStrategy : this.defaultStrategy;
    }

    @Override
    public GenerationType getSpecifiedStrategy() {
        return this.specifiedStrategy;
    }

    @Override
    public void setSpecifiedStrategy(GenerationType strategy) {
        this.setSpecifiedStrategy_(strategy);
        this.xmlGeneratedValue.setStrategy(GenerationType.toOrmResourceModel(strategy));
    }

    protected void setSpecifiedStrategy_(GenerationType strategy) {
        GenerationType old = this.specifiedStrategy;
        this.specifiedStrategy = strategy;
        this.firePropertyChanged("specifiedStrategy", (Object)old, (Object)strategy);
    }

    protected GenerationType buildSpecifiedStrategy() {
        return GenerationType.fromOrmResourceModel(this.xmlGeneratedValue.getStrategy());
    }

    @Override
    public GenerationType getDefaultStrategy() {
        return this.defaultStrategy;
    }

    protected void setDefaultStrategy(GenerationType strategy) {
        GenerationType old = this.defaultStrategy;
        this.defaultStrategy = strategy;
        this.firePropertyChanged("defaultStrategy", (Object)old, (Object)strategy);
    }

    protected GenerationType buildDefaultStrategy() {
        return DEFAULT_STRATEGY;
    }

    @Override
    public String getGenerator() {
        return this.specifiedGenerator != null ? this.specifiedGenerator : this.defaultGenerator;
    }

    @Override
    public String getSpecifiedGenerator() {
        return this.specifiedGenerator;
    }

    @Override
    public void setSpecifiedGenerator(String generator) {
        this.setSpecifiedGenerator_(generator);
        this.xmlGeneratedValue.setGenerator(generator);
    }

    protected void setSpecifiedGenerator_(String generator) {
        String old = this.specifiedGenerator;
        this.specifiedGenerator = generator;
        this.firePropertyChanged("specifiedGenerator", old, generator);
    }

    @Override
    public String getDefaultGenerator() {
        return this.defaultGenerator;
    }

    protected void setDefaultGenerator(String generator) {
        String old = this.defaultGenerator;
        this.defaultGenerator = generator;
        this.firePropertyChanged("defaultGenerator", old, generator);
    }

    protected String buildDefaultGenerator() {
        return null;
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    @Override
    public XmlGeneratedValue getXmlGeneratedValue() {
        return this.xmlGeneratedValue;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        String generator = this.getGenerator();
        if (generator == null) {
            return;
        }
        for (Generator next : this.getPersistenceUnit().getGenerators()) {
            if (!generator.equals(next.getName())) continue;
            return;
        }
        messages.add(DefaultJpaValidationMessages.buildMessage(1, "ID_MAPPING_UNRESOLVED_GENERATOR_NAME", new String[]{generator}, this.getParent(), this.getGeneratorTextRange()));
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlGeneratedValue.getValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getGeneratorTextRange() {
        return this.getValidationTextRange(this.xmlGeneratedValue.getGeneratorTextRange());
    }
}

