/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.binary;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryBaseColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.CompleteColumnAnnotation;

public abstract class BinaryCompleteColumnAnnotation
extends BinaryBaseColumnAnnotation
implements CompleteColumnAnnotation {
    protected Integer length = this.buildLength();
    protected Integer precision = this.buildPrecision();
    protected Integer scale = this.buildScale();

    protected BinaryCompleteColumnAnnotation(JavaResourceNode parent, IAnnotation jdtAnnotation) {
        super(parent, jdtAnnotation);
    }

    public void update() {
        super.update();
        this.setLength_(this.buildLength());
        this.setPrecision_(this.buildPrecision());
        this.setScale_(this.buildScale());
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        throw new UnsupportedOperationException();
    }

    private void setLength_(Integer length) {
        Integer old = this.length;
        this.length = length;
        this.firePropertyChanged("length", old, length);
    }

    private Integer buildLength() {
        return (Integer)this.getJdtMemberValue(this.getLengthElementName());
    }

    public TextRange getLengthTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    protected abstract String getLengthElementName();

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        throw new UnsupportedOperationException();
    }

    private void setPrecision_(Integer precision) {
        Integer old = this.precision;
        this.precision = precision;
        this.firePropertyChanged("precision", old, precision);
    }

    private Integer buildPrecision() {
        return (Integer)this.getJdtMemberValue(this.getPrecisionElementName());
    }

    public TextRange getPrecisionTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    protected abstract String getPrecisionElementName();

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        throw new UnsupportedOperationException();
    }

    private void setScale_(Integer scale) {
        Integer old = this.scale;
        this.scale = scale;
        this.firePropertyChanged("scale", old, scale);
    }

    private Integer buildScale() {
        return (Integer)this.getJdtMemberValue(this.getScaleElementName());
    }

    public TextRange getScaleTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    protected abstract String getScaleElementName();
}

