/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceNamedColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.BaseColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceBaseColumnAnnotation
extends SourceNamedColumnAnnotation
implements BaseColumnAnnotation {
    protected DeclarationAnnotationElementAdapter<String> tableDeclarationAdapter = this.buildTableDeclarationAdapter();
    protected AnnotationElementAdapter<String> tableAdapter = this.buildTableAdapter();
    protected String table;
    protected DeclarationAnnotationElementAdapter<Boolean> uniqueDeclarationAdapter = this.buildUniqueDeclarationAdapter();
    protected AnnotationElementAdapter<Boolean> uniqueAdapter = this.buildUniqueAdapter();
    protected Boolean unique;
    protected DeclarationAnnotationElementAdapter<Boolean> nullableDeclarationAdapter = this.buildNullableDeclarationAdapter();
    protected AnnotationElementAdapter<Boolean> nullableAdapter = this.buildNullableAdapter();
    protected Boolean nullable;
    protected DeclarationAnnotationElementAdapter<Boolean> insertableDeclarationAdapter = this.buildInsertableDeclarationAdapter();
    protected AnnotationElementAdapter<Boolean> insertableAdapter = this.buildInsertableAdapter();
    protected Boolean insertable;
    protected DeclarationAnnotationElementAdapter<Boolean> updatableDeclarationAdapter = this.buildUpdatableDeclarationAdapter();
    protected AnnotationElementAdapter<Boolean> updatableAdapter = this.buildUpdatableAdapter();
    protected Boolean updatable;

    protected SourceBaseColumnAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        this(parent, element, daa, (AnnotationAdapter)new ElementAnnotationAdapter(element, daa));
    }

    protected SourceBaseColumnAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.table = this.buildTable(astRoot);
        this.unique = this.buildUnique(astRoot);
        this.nullable = this.buildNullable(astRoot);
        this.insertable = this.buildInsertable(astRoot);
        this.updatable = this.buildUpdatable(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncTable(this.buildTable(astRoot));
        this.syncUnique(this.buildUnique(astRoot));
        this.syncNullable(this.buildNullable(astRoot));
        this.syncInsertable(this.buildInsertable(astRoot));
        this.syncUpdatable(this.buildUpdatable(astRoot));
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public void setTable(String table) {
        if (this.attributeValueHasChanged(this.table, table)) {
            this.table = table;
            this.tableAdapter.setValue((Object)table);
        }
    }

    private void syncTable(String astTable) {
        String old = this.table;
        this.table = astTable;
        this.firePropertyChanged("table", old, astTable);
    }

    private String buildTable(CompilationUnit astRoot) {
        return (String)this.tableAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTableTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.tableDeclarationAdapter, astRoot);
    }

    @Override
    public boolean tableTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.tableDeclarationAdapter, pos, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildTableDeclarationAdapter() {
        return this.buildStringElementAdapter(this.getTableElementName());
    }

    private AnnotationElementAdapter<String> buildTableAdapter() {
        return this.buildStringElementAdapter(this.tableDeclarationAdapter);
    }

    protected abstract String getTableElementName();

    @Override
    public Boolean getUnique() {
        return this.unique;
    }

    @Override
    public void setUnique(Boolean unique) {
        if (this.attributeValueHasChanged(this.unique, unique)) {
            this.unique = unique;
            this.uniqueAdapter.setValue((Object)unique);
        }
    }

    private void syncUnique(Boolean astUnique) {
        Boolean old = this.unique;
        this.unique = astUnique;
        this.firePropertyChanged("unique", old, astUnique);
    }

    private Boolean buildUnique(CompilationUnit astRoot) {
        return (Boolean)this.uniqueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getUniqueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.uniqueDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildUniqueDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getUniqueElementName());
    }

    private AnnotationElementAdapter<Boolean> buildUniqueAdapter() {
        return this.buildBooleanElementAdapter(this.uniqueDeclarationAdapter);
    }

    protected abstract String getUniqueElementName();

    @Override
    public Boolean getNullable() {
        return this.nullable;
    }

    @Override
    public void setNullable(Boolean nullable) {
        if (this.attributeValueHasChanged(this.nullable, nullable)) {
            this.nullable = nullable;
            this.nullableAdapter.setValue((Object)nullable);
        }
    }

    private void syncNullable(Boolean astNullable) {
        Boolean old = this.nullable;
        this.nullable = astNullable;
        this.firePropertyChanged("nullable", old, astNullable);
    }

    private Boolean buildNullable(CompilationUnit astRoot) {
        return (Boolean)this.nullableAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNullableTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nullableDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildNullableDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getNullableElementName());
    }

    private AnnotationElementAdapter<Boolean> buildNullableAdapter() {
        return this.buildBooleanElementAdapter(this.nullableDeclarationAdapter);
    }

    protected abstract String getNullableElementName();

    @Override
    public Boolean getInsertable() {
        return this.insertable;
    }

    @Override
    public void setInsertable(Boolean insertable) {
        if (this.attributeValueHasChanged(this.insertable, insertable)) {
            this.insertable = insertable;
            this.insertableAdapter.setValue((Object)insertable);
        }
    }

    private void syncInsertable(Boolean astInsertable) {
        Boolean old = this.insertable;
        this.insertable = astInsertable;
        this.firePropertyChanged("insertable", old, astInsertable);
    }

    private Boolean buildInsertable(CompilationUnit astRoot) {
        return (Boolean)this.insertableAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getInsertableTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.insertableDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildInsertableDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getInsertableElementName());
    }

    private AnnotationElementAdapter<Boolean> buildInsertableAdapter() {
        return this.buildBooleanElementAdapter(this.insertableDeclarationAdapter);
    }

    protected abstract String getInsertableElementName();

    @Override
    public Boolean getUpdatable() {
        return this.updatable;
    }

    @Override
    public void setUpdatable(Boolean updatable) {
        if (this.attributeValueHasChanged(this.updatable, updatable)) {
            this.updatable = updatable;
            this.updatableAdapter.setValue((Object)updatable);
        }
    }

    private void syncUpdatable(Boolean astUpdatable) {
        Boolean old = this.updatable;
        this.updatable = astUpdatable;
        this.firePropertyChanged("updatable", old, astUpdatable);
    }

    private Boolean buildUpdatable(CompilationUnit astRoot) {
        return (Boolean)this.updatableAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getUpdatableTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.updatableDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildUpdatableDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getUpdatableElementName());
    }

    private AnnotationElementAdapter<Boolean> buildUpdatableAdapter() {
        return this.buildBooleanElementAdapter(this.updatableDeclarationAdapter);
    }

    protected abstract String getUpdatableElementName();

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.table == null && this.unique == null && this.nullable == null && this.insertable == null && this.updatable == null;
    }
}

