/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.GenerationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceGeneratedValueAnnotation
extends SourceAnnotation
implements GeneratedValueAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.GeneratedValue");
    private static final DeclarationAnnotationElementAdapter<String> STRATEGY_ADAPTER = SourceGeneratedValueAnnotation.buildStrategyAdapter();
    private final AnnotationElementAdapter<String> strategyAdapter;
    private GenerationType strategy;
    private static final DeclarationAnnotationElementAdapter<String> GENERATOR_ADAPTER = SourceGeneratedValueAnnotation.buildGeneratorAdapter();
    private final AnnotationElementAdapter<String> generatorAdapter;
    private String generator;

    public SourceGeneratedValueAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super((JavaResourceNode)parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.strategyAdapter = new AnnotatedElementAnnotationElementAdapter(element, STRATEGY_ADAPTER);
        this.generatorAdapter = new AnnotatedElementAnnotationElementAdapter(element, GENERATOR_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.persistence.GeneratedValue";
    }

    public void initialize(CompilationUnit astRoot) {
        this.strategy = this.buildStrategy(astRoot);
        this.generator = this.buildGenerator(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncStrategy(this.buildStrategy(astRoot));
        this.syncGenerator(this.buildGenerator(astRoot));
    }

    public boolean isUnset() {
        return super.isUnset() && this.strategy == null && this.generator == null;
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.strategy);
    }

    @Override
    public GenerationType getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(GenerationType strategy) {
        if (this.attributeValueHasChanged((Object)this.strategy, (Object)strategy)) {
            this.strategy = strategy;
            this.strategyAdapter.setValue((Object)GenerationType.toJavaAnnotationValue(strategy));
        }
    }

    private void syncStrategy(GenerationType astStrategy) {
        GenerationType old = this.strategy;
        this.strategy = astStrategy;
        this.firePropertyChanged("strategy", (Object)old, (Object)astStrategy);
    }

    private GenerationType buildStrategy(CompilationUnit astRoot) {
        return GenerationType.fromJavaAnnotationValue(this.strategyAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getStrategyTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(STRATEGY_ADAPTER, astRoot);
    }

    @Override
    public String getGenerator() {
        return this.generator;
    }

    @Override
    public void setGenerator(String generator) {
        if (this.attributeValueHasChanged(this.generator, generator)) {
            this.generator = generator;
            this.generatorAdapter.setValue((Object)generator);
        }
    }

    private void syncGenerator(String astGenerator) {
        String old = this.generator;
        this.generator = astGenerator;
        this.firePropertyChanged("generator", old, astGenerator);
    }

    private String buildGenerator(CompilationUnit astRoot) {
        return (String)this.generatorAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getGeneratorTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(GENERATOR_ADAPTER, astRoot);
    }

    @Override
    public boolean generatorTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(GENERATOR_ADAPTER, pos, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildStrategyAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "strategy");
    }

    private static DeclarationAnnotationElementAdapter<String> buildGeneratorAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"generator");
    }
}

