/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jpa.core.resource.java.QueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceQueryAnnotation
extends SourceAnnotation
implements QueryAnnotation {
    DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    AnnotationElementAdapter<String> nameAdapter;
    String name;
    TextRange nameTextRange;
    DeclarationAnnotationElementAdapter<String> queryDeclarationAdapter;
    AnnotationElementAdapter<String> queryAdapter;
    String query;
    TextRange queryTextRange;
    final QueryHintsAnnotationContainer hintsContainer = new QueryHintsAnnotationContainer();

    SourceQueryAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameDeclarationAdapter();
        this.nameAdapter = this.buildNameAdapter();
        this.queryDeclarationAdapter = this.buildQueryDeclarationAdapter();
        this.queryAdapter = this.buildQueryAdapter();
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.nameTextRange = this.buildNameTextRange(astRoot);
        this.query = this.buildQuery(astRoot);
        this.queryTextRange = this.buildQueryTextRange(astRoot);
        this.hintsContainer.initialize(this.getAstAnnotation(astRoot));
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.nameTextRange = this.buildNameTextRange(astRoot);
        this.syncQuery(this.buildQuery(astRoot));
        this.queryTextRange = this.buildQueryTextRange(astRoot);
        this.hintsContainer.synchronize(this.getAstAnnotation(astRoot));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.nameTextRange;
    }

    private TextRange buildNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)this.getNameElementName());
    }

    private AnnotationElementAdapter<String> buildNameAdapter() {
        return this.buildStringElementAdapter(this.nameDeclarationAdapter);
    }

    abstract String getNameElementName();

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        if (this.attributeValueHasChanged(this.query, query)) {
            this.query = query;
            this.queryAdapter.setValue((Object)query);
        }
    }

    private void syncQuery(String annotationQuery) {
        String old = this.query;
        this.query = annotationQuery;
        this.firePropertyChanged("query", old, annotationQuery);
    }

    private String buildQuery(CompilationUnit astRoot) {
        return (String)this.queryAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getQueryTextRange(CompilationUnit astRoot) {
        return this.queryTextRange;
    }

    private TextRange buildQueryTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.queryDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildQueryDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)this.getQueryElementName());
    }

    private AnnotationElementAdapter<String> buildQueryAdapter() {
        return this.buildStringElementAdapter(this.queryDeclarationAdapter);
    }

    abstract String getQueryElementName();

    @Override
    public ListIterable<QueryHintAnnotation> getHints() {
        return this.hintsContainer.getNestedAnnotations();
    }

    @Override
    public int getHintsSize() {
        return this.hintsContainer.getNestedAnnotationsSize();
    }

    @Override
    public QueryHintAnnotation hintAt(int index) {
        return (QueryHintAnnotation)this.hintsContainer.nestedAnnotationAt(index);
    }

    @Override
    public QueryHintAnnotation addHint(int index) {
        return (QueryHintAnnotation)this.hintsContainer.addNestedAnnotation(index);
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.hintsContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeHint(int index) {
        this.hintsContainer.removeNestedAnnotation(index);
    }

    abstract QueryHintAnnotation buildHint(int var1);

    abstract String getHintsElementName();

    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.query == null && this.hintsContainer.isEmpty();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QueryHintsAnnotationContainer
    extends SourceAnnotation.AnnotationContainer<QueryHintAnnotation> {
        QueryHintsAnnotationContainer() {
            super((SourceAnnotation)SourceQueryAnnotation.this);
        }

        protected String getAnnotationsPropertyName() {
            return "hints";
        }

        protected String getElementName() {
            return SourceQueryAnnotation.this.getHintsElementName();
        }

        protected String getNestedAnnotationName() {
            return "javax.persistence.QueryHint";
        }

        protected QueryHintAnnotation buildNestedAnnotation(int index) {
            return SourceQueryAnnotation.this.buildHint(index);
        }
    }
}

