/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributesContainer;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaAttributesContainer
extends AbstractJavaContextNode
implements JaxbAttributesContainer {
    protected JavaResourceType javaResourceType;
    protected Owner owner;
    protected final Vector<JaxbPersistentAttribute> attributes = new Vector();
    protected static Filter<JavaResourceField> PUBLIC_MEMBER_ACCESS_TYPE_RESOURCE_FIELDS_FILTER = new Filter<JavaResourceField>(){

        public boolean accept(JavaResourceField resourceField) {
            return GenericJavaAttributesContainer.memberIsPublicNonTransientNonStatic((JavaResourceMember)resourceField) || resourceField.isAnnotated();
        }
    };
    protected static Filter<JavaResourceField> ANNOTATED_RESOURCE_FIELDS_FILTER = new Filter<JavaResourceField>(){

        public boolean accept(JavaResourceField resourceField) {
            return resourceField.isAnnotated();
        }
    };

    public GenericJavaAttributesContainer(JaxbClassMapping parent, Owner owner, JavaResourceType resourceType) {
        super(parent);
        this.javaResourceType = resourceType;
        this.owner = owner;
        this.initializeAttributes();
    }

    public JaxbClassMapping getJaxbClassMapping() {
        return (JaxbClassMapping)this.getParent();
    }

    @Override
    public boolean isFor(JavaResourceType javaResourceType) {
        return this.javaResourceType == javaResourceType;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.synchronizeNodesWithResourceModel(this.getAttributes());
    }

    @Override
    public void update() {
        super.update();
        this.updateAttributes();
    }

    protected XmlAccessType getAccessType() {
        return this.owner.getAccessType();
    }

    @Override
    public Iterable<JaxbPersistentAttribute> getAttributes() {
        return new LiveCloneIterable(this.attributes);
    }

    @Override
    public int getAttributesSize() {
        return this.attributes.size();
    }

    protected void addAttribute(JaxbPersistentAttribute attribute) {
        if (this.attributes.add(attribute)) {
            this.owner.fireAttributeAdded(attribute);
        }
    }

    protected void removeAttribute(JaxbPersistentAttribute attribute) {
        if (this.attributes.remove(attribute)) {
            this.owner.fireAttributeRemoved(attribute);
        }
    }

    protected JaxbPersistentAttribute buildField(JavaResourceField resourceField) {
        return this.getFactory().buildJavaPersistentField(this.getJaxbClassMapping(), resourceField);
    }

    protected JaxbPersistentAttribute buildProperty(JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        return this.getFactory().buildJavaPersistentProperty(this.getJaxbClassMapping(), resourceGetter, resourceSetter);
    }

    protected void initializeAttributes() {
        if (this.getJaxbClassMapping().isXmlTransient()) {
            return;
        }
        if (this.getAccessType() == XmlAccessType.PUBLIC_MEMBER) {
            this.initializePublicMemberAccessAttributes();
        } else if (this.getAccessType() == XmlAccessType.FIELD) {
            this.intializeFieldAccessAttributes();
        } else if (this.getAccessType() == XmlAccessType.PROPERTY) {
            this.intializePropertyAccessAttributes();
        } else if (this.getAccessType() == XmlAccessType.NONE) {
            this.intializeNoneAccessAttributes();
        }
    }

    private void initializePublicMemberAccessAttributes() {
        this.initializeFieldAttributes(PUBLIC_MEMBER_ACCESS_TYPE_RESOURCE_FIELDS_FILTER);
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourceMethods(this.buildPersistablePropertyGetterMethodsFilter())) {
            JavaResourceMethod setterMethod;
            if (GenericJavaAttributesContainer.methodsArePersistablePublicMemberAccess(getterMethod, setterMethod = GenericJavaAttributesContainer.getValidSiblingSetMethod(getterMethod, (Collection<JavaResourceMethod>)resourceMethods))) {
                this.attributes.add(this.buildProperty(getterMethod, setterMethod));
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.initializeRemainingResourceMethodAttributes((Collection<JavaResourceMethod>)resourceMethods);
    }

    private void intializeFieldAccessAttributes() {
        this.initializeFieldAttributes(this.buildNonTransientNonStaticResourceFieldsFilter());
        this.initializeAnnotatedPropertyAttributes();
    }

    private void intializePropertyAccessAttributes() {
        this.initializeFieldAttributes(ANNOTATED_RESOURCE_FIELDS_FILTER);
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourceMethods(this.buildPersistablePropertyGetterMethodsFilter())) {
            JavaResourceMethod setterMethod;
            if (GenericJavaAttributesContainer.methodsArePersistableProperties(getterMethod, setterMethod = GenericJavaAttributesContainer.getValidSiblingSetMethod(getterMethod, (Collection<JavaResourceMethod>)resourceMethods))) {
                this.attributes.add(this.buildProperty(getterMethod, setterMethod));
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.initializeRemainingResourceMethodAttributes((Collection<JavaResourceMethod>)resourceMethods);
    }

    private void intializeNoneAccessAttributes() {
        this.initializeFieldAttributes(ANNOTATED_RESOURCE_FIELDS_FILTER);
        this.initializeAnnotatedPropertyAttributes();
    }

    private void initializeFieldAttributes(Filter<JavaResourceField> filter) {
        for (JavaResourceField resourceField : this.getResourceFields(filter)) {
            this.attributes.add(this.buildField(resourceField));
        }
    }

    private void initializeRemainingResourceMethodAttributes(Collection<JavaResourceMethod> resourceMethods) {
        for (JavaResourceMethod resourceMethod : resourceMethods) {
            if (!resourceMethod.isAnnotated()) continue;
            this.attributes.add(this.buildProperty(null, resourceMethod));
        }
    }

    private static boolean methodsArePersistableProperties(JavaResourceMethod getterMethod, JavaResourceMethod setterMethod) {
        if (setterMethod != null) {
            return true;
        }
        if (getterMethod.getTypeName().equals("java.util.List")) {
            return true;
        }
        return getterMethod.isAnnotated();
    }

    private static boolean methodsArePersistablePublicMemberAccess(JavaResourceMethod getterMethod, JavaResourceMethod setterMethod) {
        if (getterMethod.isPublic()) {
            if (setterMethod != null) {
                if (setterMethod.isPublic()) {
                    return true;
                }
            } else {
                if (getterMethod.getTypeName().equals("java.util.List")) {
                    return true;
                }
                if (getterMethod.isAnnotated()) {
                    return true;
                }
            }
        } else if (getterMethod.isAnnotated() || setterMethod != null && setterMethod.isAnnotated()) {
            return true;
        }
        return false;
    }

    private void initializeAnnotatedPropertyAttributes() {
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourceMethods(this.buildPersistablePropertyGetterMethodsFilter())) {
            JavaResourceMethod setterMethod = GenericJavaAttributesContainer.getValidSiblingSetMethod(getterMethod, (Collection<JavaResourceMethod>)resourceMethods);
            if (getterMethod.isAnnotated() || setterMethod != null && setterMethod.isAnnotated()) {
                this.attributes.add(this.buildProperty(getterMethod, setterMethod));
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.initializeRemainingResourceMethodAttributes((Collection<JavaResourceMethod>)resourceMethods);
    }

    protected Iterable<JavaResourceField> getResourceFields() {
        return this.javaResourceType.getFields();
    }

    protected Iterable<JavaResourceMethod> getResourceMethods() {
        return this.javaResourceType.getMethods();
    }

    protected Iterable<JavaResourceField> getResourceFields(Filter<JavaResourceField> filter) {
        return new FilteringIterable(this.getResourceFields(), filter);
    }

    protected Iterable<JavaResourceMethod> getResourceMethods(Filter<JavaResourceMethod> filter) {
        return new FilteringIterable(this.getResourceMethods(), filter);
    }

    protected Filter<JavaResourceField> buildNonTransientNonStaticResourceFieldsFilter() {
        return new Filter<JavaResourceField>(){

            public boolean accept(JavaResourceField resourceField) {
                return GenericJavaAttributesContainer.memberIsNonTransientNonStatic((JavaResourceMember)resourceField) || resourceField.isAnnotated();
            }
        };
    }

    protected Filter<JavaResourceMethod> buildPersistablePropertyGetterMethodsFilter() {
        return new Filter<JavaResourceMethod>(){

            public boolean accept(JavaResourceMethod resourceMethod) {
                return GenericJavaAttributesContainer.methodIsPersistablePropertyGetter(resourceMethod, GenericJavaAttributesContainer.this.getResourceMethods());
            }
        };
    }

    protected static boolean memberIsPublicNonTransientNonStatic(JavaResourceMember resourceMember) {
        return resourceMember.isPublic() && GenericJavaAttributesContainer.memberIsNonTransientNonStatic(resourceMember);
    }

    protected static boolean memberIsNonTransientNonStatic(JavaResourceMember resourceMember) {
        return !resourceMember.isTransient() && !resourceMember.isStatic();
    }

    protected void updateAttributes() {
        if (this.getJaxbClassMapping().isXmlTransient()) {
            for (JaxbPersistentAttribute contextAttribute : this.getAttributes()) {
                this.removeAttribute(contextAttribute);
            }
            return;
        }
        if (this.getAccessType() == XmlAccessType.PUBLIC_MEMBER) {
            this.syncPublicMemberAccessAttributes();
        } else if (this.getAccessType() == XmlAccessType.FIELD) {
            this.syncFieldAccessAttributes();
        } else if (this.getAccessType() == XmlAccessType.PROPERTY) {
            this.syncPropertyAccessAttributes();
        } else if (this.getAccessType() == XmlAccessType.NONE) {
            this.syncNoneAccessAttributes();
        }
    }

    private void syncPublicMemberAccessAttributes() {
        HashSet contextAttributes = CollectionTools.set(this.getAttributes());
        this.syncFieldAttributes(contextAttributes, PUBLIC_MEMBER_ACCESS_TYPE_RESOURCE_FIELDS_FILTER);
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourceMethods(this.buildPersistablePropertyGetterMethodsFilter())) {
            JavaResourceMethod setterMethod;
            if (!GenericJavaAttributesContainer.methodsArePersistablePublicMemberAccess(getterMethod, setterMethod = GenericJavaAttributesContainer.getValidSiblingSetMethod(getterMethod, (Collection<JavaResourceMethod>)resourceMethods))) continue;
            boolean match = false;
            Iterator stream = contextAttributes.iterator();
            while (stream.hasNext()) {
                JaxbPersistentAttribute contextAttribute = (JaxbPersistentAttribute)stream.next();
                if (!contextAttribute.isFor(getterMethod, setterMethod)) continue;
                match = true;
                contextAttribute.update();
                stream.remove();
                break;
            }
            if (!match) {
                this.addAttribute(this.buildProperty(getterMethod, setterMethod));
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.syncRemainingResourceMethods(contextAttributes, (Collection<JavaResourceMethod>)resourceMethods);
    }

    private void syncFieldAccessAttributes() {
        HashSet contextAttributes = CollectionTools.set(this.getAttributes());
        this.syncFieldAttributes(contextAttributes, this.buildNonTransientNonStaticResourceFieldsFilter());
        this.syncAnnotatedPropertyAttributes(contextAttributes);
    }

    private void syncPropertyAccessAttributes() {
        HashSet contextAttributes = CollectionTools.set(this.getAttributes());
        this.syncFieldAttributes(contextAttributes, ANNOTATED_RESOURCE_FIELDS_FILTER);
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourceMethods(this.buildPersistablePropertyGetterMethodsFilter())) {
            JavaResourceMethod setterMethod;
            if (GenericJavaAttributesContainer.methodsArePersistableProperties(getterMethod, setterMethod = GenericJavaAttributesContainer.getValidSiblingSetMethod(getterMethod, (Collection<JavaResourceMethod>)resourceMethods))) {
                boolean match = false;
                Iterator stream = contextAttributes.iterator();
                while (stream.hasNext()) {
                    JaxbPersistentAttribute contextAttribute = (JaxbPersistentAttribute)stream.next();
                    if (!contextAttribute.isFor(getterMethod, setterMethod)) continue;
                    match = true;
                    contextAttribute.update();
                    stream.remove();
                    break;
                }
                if (!match) {
                    this.addAttribute(this.buildProperty(getterMethod, setterMethod));
                }
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.syncRemainingResourceMethods(contextAttributes, (Collection<JavaResourceMethod>)resourceMethods);
    }

    private void syncNoneAccessAttributes() {
        HashSet contextAttributes = CollectionTools.set(this.getAttributes());
        this.syncFieldAttributes(contextAttributes, ANNOTATED_RESOURCE_FIELDS_FILTER);
        this.syncAnnotatedPropertyAttributes(contextAttributes);
    }

    private void syncAnnotatedPropertyAttributes(HashSet<JaxbPersistentAttribute> contextAttributes) {
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourceMethods(this.buildPersistablePropertyGetterMethodsFilter())) {
            JavaResourceMethod setterMethod = GenericJavaAttributesContainer.getValidSiblingSetMethod(getterMethod, (Collection<JavaResourceMethod>)resourceMethods);
            if (getterMethod.isAnnotated() || setterMethod != null && setterMethod.isAnnotated()) {
                boolean match = false;
                Iterator<JaxbPersistentAttribute> stream = contextAttributes.iterator();
                while (stream.hasNext()) {
                    JaxbPersistentAttribute contextAttribute = stream.next();
                    if (!contextAttribute.isFor(getterMethod, setterMethod)) continue;
                    match = true;
                    contextAttribute.update();
                    stream.remove();
                    break;
                }
                if (!match) {
                    this.addAttribute(this.buildProperty(getterMethod, setterMethod));
                }
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.syncRemainingResourceMethods(contextAttributes, (Collection<JavaResourceMethod>)resourceMethods);
    }

    private void syncFieldAttributes(HashSet<JaxbPersistentAttribute> contextAttributes, Filter<JavaResourceField> filter) {
        for (JavaResourceField resourceField : this.getResourceFields(filter)) {
            boolean match = false;
            Iterator<JaxbPersistentAttribute> stream = contextAttributes.iterator();
            while (stream.hasNext()) {
                JaxbPersistentAttribute contextAttribute = stream.next();
                if (!contextAttribute.isFor(resourceField)) continue;
                match = true;
                contextAttribute.update();
                stream.remove();
                break;
            }
            if (match) continue;
            this.addAttribute(this.buildField(resourceField));
        }
    }

    private void syncRemainingResourceMethods(HashSet<JaxbPersistentAttribute> contextAttributes, Collection<JavaResourceMethod> resourceMethods) {
        for (JavaResourceMethod resourceMethod : resourceMethods) {
            if (!resourceMethod.isAnnotated()) continue;
            boolean match = false;
            Iterator<JaxbPersistentAttribute> stream = contextAttributes.iterator();
            while (stream.hasNext()) {
                JaxbPersistentAttribute contextAttribute = stream.next();
                if (!contextAttribute.isFor(null, resourceMethod)) continue;
                match = true;
                contextAttribute.update();
                stream.remove();
                break;
            }
            if (match) continue;
            this.addAttribute(this.buildProperty(null, resourceMethod));
        }
        for (JaxbPersistentAttribute contextAttribute : contextAttributes) {
            this.removeAttribute(contextAttribute);
        }
    }

    protected static boolean methodIsPersistablePropertyGetter(JavaResourceMethod resourceMethod, Iterable<JavaResourceMethod> allMethods) {
        if (GenericJavaAttributesContainer.methodHasInvalidModifiers(resourceMethod)) {
            return false;
        }
        if (resourceMethod.isConstructor()) {
            return false;
        }
        String returnTypeName = resourceMethod.getTypeName();
        if (returnTypeName == null) {
            return false;
        }
        if (returnTypeName.equals("void")) {
            return false;
        }
        if (GenericJavaAttributesContainer.methodHasParameters(resourceMethod)) {
            return false;
        }
        boolean booleanGetter = GenericJavaAttributesContainer.methodIsBooleanGetter(resourceMethod);
        return !booleanGetter || !GenericJavaAttributesContainer.methodHasValidSiblingIsMethod(resourceMethod, allMethods);
    }

    private static boolean methodIsBooleanGetter(JavaResourceMethod resourceMethod) {
        String returnTypeName = resourceMethod.getTypeName();
        String name = resourceMethod.getMethodName();
        boolean booleanGetter = false;
        if (name.startsWith("is")) {
            if (!returnTypeName.equals("boolean")) {
                return false;
            }
        } else if (name.startsWith("get")) {
            if (returnTypeName.equals("boolean")) {
                booleanGetter = true;
            }
        } else {
            return false;
        }
        return booleanGetter;
    }

    private static boolean methodHasInvalidModifiers(JavaResourceMethod resourceMethod) {
        int modifiers = resourceMethod.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    private static boolean methodHasParameters(JavaResourceMethod resourceMethod) {
        return resourceMethod.getParametersSize() != 0;
    }

    private static boolean methodHasValidSiblingIsMethod(JavaResourceMethod getMethod, Iterable<JavaResourceMethod> resourceMethods) {
        String capitalizedAttributeName = StringTools.capitalize((String)getMethod.getName());
        for (JavaResourceMethod sibling : resourceMethods) {
            if (sibling.getParametersSize() != 0 || !sibling.getMethodName().equals("is" + capitalizedAttributeName)) continue;
            return GenericJavaAttributesContainer.methodIsValidSibling(sibling, "boolean");
        }
        return false;
    }

    private static JavaResourceMethod getValidSiblingSetMethod(JavaResourceMethod getMethod, Collection<JavaResourceMethod> resourceMethods) {
        String capitalizedAttributeName = StringTools.capitalize((String)getMethod.getName());
        String parameterTypeErasureName = getMethod.getTypeName();
        for (JavaResourceMethod sibling : resourceMethods) {
            ListIterable siblingParmTypeNames = sibling.getParameterTypeNames();
            if (sibling.getParametersSize() != 1 || !sibling.getMethodName().equals("set" + capitalizedAttributeName) || !((String)siblingParmTypeNames.iterator().next()).equals(parameterTypeErasureName)) continue;
            return GenericJavaAttributesContainer.methodIsValidSibling(sibling, "void") ? sibling : null;
        }
        return null;
    }

    private static boolean methodIsValidSibling(JavaResourceMethod resourceMethod, String returnTypeName) {
        if (resourceMethod == null) {
            return false;
        }
        if (GenericJavaAttributesContainer.methodHasInvalidModifiers(resourceMethod)) {
            return false;
        }
        if (resourceMethod.isConstructor()) {
            return false;
        }
        String rtName = resourceMethod.getTypeName();
        if (rtName == null) {
            return false;
        }
        return rtName.equals(returnTypeName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        for (JaxbPersistentAttribute attribute : this.getAttributes()) {
            attribute.validate(messages, reporter, astRoot);
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getJaxbClassMapping().getValidationTextRange(astRoot);
    }

    static interface Owner {
        public XmlAccessType getAccessType();

        public void fireAttributeAdded(JaxbPersistentAttribute var1);

        public void fireAttributeRemoved(JaxbPersistentAttribute var1);
    }
}

