/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnumConstant;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumConstant;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.XmlEnumValueAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdSimpleTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaEnumConstant
extends AbstractJavaContextNode
implements JaxbEnumConstant {
    protected final JavaResourceEnumConstant resourceEnumConstant;
    protected String specifiedValue;

    public GenericJavaEnumConstant(JaxbEnumMapping parent, JavaResourceEnumConstant resourceEnumConstant) {
        super(parent);
        this.resourceEnumConstant = resourceEnumConstant;
        this.specifiedValue = this.getResourceEnumValue();
    }

    protected JaxbEnumMapping getEnumMapping() {
        return (JaxbEnumMapping)this.getParent();
    }

    @Override
    public JavaResourceEnumConstant getResourceEnumConstant() {
        return this.resourceEnumConstant;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedValue_(this.getResourceEnumValue());
    }

    protected XmlEnumValueAnnotation getXmlEnumValueAnnotation() {
        return (XmlEnumValueAnnotation)this.getResourceEnumConstant().getNonNullAnnotation("javax.xml.bind.annotation.XmlEnumValue");
    }

    @Override
    public String getName() {
        return this.resourceEnumConstant.getName();
    }

    @Override
    public String getValue() {
        return this.getSpecifiedValue() != null ? this.getSpecifiedValue() : this.getDefaultValue();
    }

    @Override
    public String getDefaultValue() {
        return this.getName();
    }

    @Override
    public String getSpecifiedValue() {
        return this.specifiedValue;
    }

    @Override
    public void setSpecifiedValue(String value) {
        this.getXmlEnumValueAnnotation().setValue(value);
        this.setSpecifiedValue_(value);
    }

    protected void setSpecifiedValue_(String value) {
        String old = this.specifiedValue;
        this.specifiedValue = value;
        this.firePropertyChanged("specifiedValue", old, value);
    }

    protected String getResourceEnumValue() {
        return this.getXmlEnumValueAnnotation().getValue();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        XsdTypeDefinition xsdType;
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        if (this.valueTouches(pos, astRoot) && (xsdType = this.getEnumMapping().getXsdTypeDefinition()) != null && xsdType.getKind() == XsdTypeDefinition.Kind.SIMPLE) {
            XsdSimpleTypeDefinition xsdSimpleType = (XsdSimpleTypeDefinition)xsdType;
            return xsdSimpleType.getEnumValueProposals(filter);
        }
        return EmptyIterable.instance();
    }

    protected boolean valueTouches(int pos, CompilationUnit astRoot) {
        return this.getXmlEnumValueAnnotation().valueTouches(pos, astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        String value = this.getValue();
        XsdTypeDefinition xsdType = this.getEnumMapping().getXsdTypeDefinition();
        if (xsdType == null || xsdType.getKind() != XsdTypeDefinition.Kind.SIMPLE) {
            return;
        }
        if (!((XSDSimpleTypeDefinition)((XsdSimpleTypeDefinition)xsdType).getXSDComponent()).isValidLiteral(value)) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ENUM_VALUE__INVALID_LEXICAL_VALUE", new String[]{value, xsdType.getName()}, this, this.getValueTextRange(astRoot)));
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceEnumConstant().getTextRange(astRoot);
    }

    protected TextRange getValueTextRange(CompilationUnit astRoot) {
        TextRange enumValueTextRange = this.getXmlEnumValueAnnotation().getValueTextRange(astRoot);
        return enumValueTextRange != null ? enumValueTextRange : this.getValidationTextRange(astRoot);
    }
}

