/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlIDREF;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDREFAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdFeature;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlIDREF
extends AbstractJavaContextNode
implements XmlIDREF {
    protected final Context context;

    public GenericJavaXmlIDREF(JaxbAttributeMapping parent, Context context) {
        super(parent);
        this.context = context;
    }

    @Override
    public JaxbAttributeMapping getParent() {
        return (JaxbAttributeMapping)super.getParent();
    }

    protected JaxbPersistentAttribute getPersistentAttribute() {
        return this.getParent().getPersistentAttribute();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.context.getAnnotation().getTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        for (ValidatableReference ref : this.context.getReferences()) {
            XsdFeature xsdFeature;
            JaxbClassMapping classMapping;
            String typeName = ref.getFullyQualifiedType();
            if (!(Object.class.getName().equals(typeName) && CollectionTools.size(this.context.getReferences()) == 1 || (classMapping = this.getContextRoot().getClassMapping(typeName)) != null && classMapping.getXmlIdMapping() != null)) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_ID_REF__TYPE_DOES_NOT_CONTAIN_XML_ID", new String[]{typeName}, this, ref.getTypeTextRange(astRoot)));
            }
            if ((xsdFeature = ref.getXsdFeature()) == null) {
                return;
            }
            if (xsdFeature == null || xsdFeature.typeIsValid(XsdUtil.getSchemaForSchema().getTypeDefinition("IDREF"), this.context.isList())) continue;
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ID_REF__SCHEMA_TYPE_NOT_IDREF", new String[]{xsdFeature.getName()}, this, ref.getXsdFeatureTextRange(astRoot)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Context {
        public XmlIDREFAnnotation getAnnotation();

        public Iterable<ValidatableReference> getReferences();

        public boolean isList();
    }

    public static interface ValidatableReference {
        public String getFullyQualifiedType();

        public TextRange getTypeTextRange(CompilationUnit var1);

        public XsdFeature getXsdFeature();

        public TextRange getXsdFeatureTextRange(CompilationUnit var1);
    }
}

