/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.Bag;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbElementFactoryMethod;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.XmlRegistry;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRegistryAnnotation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlRegistry
extends AbstractJavaContextNode
implements XmlRegistry {
    protected final ElementFactoryMethodContainer elementFactoryMethodContainer = new ElementFactoryMethodContainer();

    public GenericJavaXmlRegistry(JaxbClass parent) {
        super(parent);
        this.initElementFactoryMethods();
    }

    @Override
    public JaxbClass getJaxbClass() {
        return (JaxbClass)this.getParent();
    }

    public JavaResourceType getJavaResourceType() {
        return this.getJaxbClass().getJavaResourceType();
    }

    protected XmlRegistryAnnotation getAnnotation() {
        return (XmlRegistryAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlRegistry");
    }

    public JaxbPackage getJaxbPackage() {
        return this.getJaxbClass().getJaxbPackage();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncElementFactoryMethods();
    }

    @Override
    public void update() {
        super.update();
        this.updateElementFactoryMethods();
    }

    @Override
    public Iterable<JaxbElementFactoryMethod> getElementFactoryMethods() {
        return this.elementFactoryMethodContainer.getContextElements();
    }

    @Override
    public int getElementFactoryMethodsSize() {
        return this.elementFactoryMethodContainer.getContextElementsSize();
    }

    protected void initElementFactoryMethods() {
        this.elementFactoryMethodContainer.initialize();
    }

    protected void syncElementFactoryMethods() {
        this.elementFactoryMethodContainer.synchronizeWithResourceModel();
    }

    protected void updateElementFactoryMethods() {
        this.elementFactoryMethodContainer.update();
    }

    private JaxbElementFactoryMethod buildElementFactoryMethod(JavaResourceMethod resourceMethod) {
        return this.getFactory().buildJavaElementFactoryMethod(this, resourceMethod);
    }

    private Iterable<JavaResourceMethod> getResourceElementFactoryMethods() {
        return new FilteringIterable<JavaResourceMethod>(this.getJavaResourceType().getMethods()){

            protected boolean accept(JavaResourceMethod method) {
                return GenericJavaXmlRegistry.methodIsElementFactoryMethod(method);
            }
        };
    }

    protected static boolean methodIsElementFactoryMethod(JavaResourceMethod method) {
        return GenericJavaXmlRegistry.methodHasXmlElementDeclAnnotation(method);
    }

    protected static boolean methodHasXmlElementDeclAnnotation(JavaResourceMethod method) {
        return method.getAnnotation("javax.xml.bind.annotation.XmlElementDecl") != null;
    }

    protected static boolean methodReturnTypeIsJAXBElement(JavaResourceMethod method) {
        return method.typeIsSubTypeOf("javax.xml.bind.annotation.XmlElement");
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        for (JaxbElementFactoryMethod efm : this.getElementFactoryMethods()) {
            result = efm.getJavaCompletionProposals(pos, filter, astRoot);
            if (CollectionTools.isEmpty(result)) continue;
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getAnnotation().getTextRange(astRoot);
        return textRange != null ? textRange : this.getJaxbClass().getValidationTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateDuplicateQNames(messages, reporter, astRoot);
        for (JaxbElementFactoryMethod efm : this.getElementFactoryMethods()) {
            efm.validate(messages, reporter, astRoot);
        }
    }

    protected void validateDuplicateQNames(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        HashMap<String, HashBag> xmlElementDeclQnames = new HashMap<String, HashBag>();
        for (JaxbElementFactoryMethod xmlElementDecl : this.getElementFactoryMethods()) {
            String elementDeclName = xmlElementDecl.getQName().getName();
            if (StringTools.stringIsEmpty((String)elementDeclName)) continue;
            String fqScope = xmlElementDecl.getFullyQualifiedScope();
            if (xmlElementDeclQnames.get(fqScope) == null) {
                xmlElementDeclQnames.put(fqScope, new HashBag());
            }
            ((Bag)xmlElementDeclQnames.get(fqScope)).add((Object)new QName(xmlElementDecl.getQName().getNamespace(), elementDeclName));
        }
        for (JaxbElementFactoryMethod xmlElementDecl : this.getElementFactoryMethods()) {
            String fqScope = xmlElementDecl.getFullyQualifiedScope();
            String xmlElementNamespace = xmlElementDecl.getQName().getNamespace();
            String xmlElementName = xmlElementDecl.getQName().getName();
            if (((Bag)xmlElementDeclQnames.get(fqScope)).count((Object)new QName(xmlElementNamespace, xmlElementName)) <= 1) continue;
            String scopeDesc = "";
            if (!"javax.xml.bind.annotation.XmlElementDecl.GLOBAL".equals(fqScope)) {
                scopeDesc = NLS.bind((String)JptJaxbCoreMessages.XML_ELEMENT_DECL__SCOPE, (Object)fqScope);
            }
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_REGISTRY__DUPLICATE_XML_ELEMENT_QNAME", new String[]{xmlElementName, scopeDesc}, xmlElementDecl, xmlElementDecl.getQName().getNameTextRange(astRoot)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ElementFactoryMethodContainer
    extends AbstractJaxbNode.ContextCollectionContainer<JaxbElementFactoryMethod, JavaResourceMethod> {
        protected ElementFactoryMethodContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "elementFactoryMethods";
        }

        @Override
        protected JaxbElementFactoryMethod buildContextElement(JavaResourceMethod resourceElement) {
            return GenericJavaXmlRegistry.this.buildElementFactoryMethod(resourceElement);
        }

        @Override
        protected Iterable<JavaResourceMethod> getResourceElements() {
            return GenericJavaXmlRegistry.this.getResourceElementFactoryMethods();
        }

        @Override
        protected JavaResourceMethod getResourceElement(JaxbElementFactoryMethod contextElement) {
            return contextElement.getResourceMethod();
        }
    }
}

