/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.platform;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.GenericAnnotationProvider;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jaxb.core.JaxbFactory;
import org.eclipse.jpt.jaxb.core.JaxbFile;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbResourceModelProvider;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.DefaultJavaAttributeMappingDefinition;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatform;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDefinition;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JaxbPlatformImpl
implements JaxbPlatform {
    private JaxbPlatformDefinition platformDefinition;
    private AnnotationProvider annotationProvider;

    public JaxbPlatformImpl(JaxbPlatformDefinition jaxbPlatformDefinition) {
        this.platformDefinition = jaxbPlatformDefinition;
        this.annotationProvider = new GenericAnnotationProvider(this.platformDefinition.getAnnotationDefinitions(), this.platformDefinition.getNestableAnnotationDefinitions());
    }

    @Override
    public JaxbPlatformDescription getDescription() {
        return this.platformDefinition.getDescription();
    }

    @Override
    public JaxbPlatformDefinition getDefinition() {
        return this.platformDefinition;
    }

    @Override
    public JaxbFactory getFactory() {
        return this.platformDefinition.getFactory();
    }

    @Override
    public JaxbFile buildJaxbFile(JaxbProject jaxbProject, IFile file) {
        IContentType contentType = PlatformTools.getContentType((IFile)file);
        return contentType == null ? null : this.buildJaxbFile(jaxbProject, file, contentType);
    }

    protected JaxbFile buildJaxbFile(JaxbProject jaxbProject, IFile file, IContentType contentType) {
        JptResourceModel resourceModel = this.buildResourceModel(jaxbProject, file, contentType);
        return resourceModel == null ? null : this.getFactory().buildJaxbFile(jaxbProject, file, contentType, resourceModel);
    }

    protected JptResourceModel buildResourceModel(JaxbProject jaxbProject, IFile file, IContentType contentType) {
        JaxbResourceModelProvider provider = this.getResourceModelProvider(contentType);
        return provider == null ? null : provider.buildResourceModel(jaxbProject, file);
    }

    protected JaxbResourceModelProvider getResourceModelProvider(IContentType contentType) {
        for (JaxbResourceModelProvider provider : this.getResourceModelProviders()) {
            if (!contentType.equals(provider.getContentType())) continue;
            return provider;
        }
        return null;
    }

    protected ListIterable<JaxbResourceModelProvider> getResourceModelProviders() {
        return this.platformDefinition.getResourceModelProviders();
    }

    @Override
    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    @Override
    public AnnotationEditFormatter getAnnotationEditFormatter() {
        return DefaultAnnotationEditFormatter.instance();
    }

    @Override
    public JavaAttributeMappingDefinition getSpecifiedJavaAttributeMappingDefinition(JaxbPersistentAttribute attribute) {
        for (JavaAttributeMappingDefinition definition : this.getSpecifiedJavaAttributeMappingDefinitions()) {
            if (!definition.isSpecified(attribute)) continue;
            return definition;
        }
        throw new IllegalStateException("There must be a mapping definition for all attributes");
    }

    @Override
    public Iterable<JavaAttributeMappingDefinition> getSpecifiedJavaAttributeMappingDefinitions() {
        return this.platformDefinition.getSpecifiedJavaAttributeMappingDefinitions();
    }

    @Override
    public JavaAttributeMappingDefinition getSpecifiedJavaAttributeMappingDefinition(String mappingKey) {
        for (JavaAttributeMappingDefinition definition : this.getSpecifiedJavaAttributeMappingDefinitions()) {
            if (!Tools.valuesAreEqual((Object)definition.getKey(), (Object)mappingKey)) continue;
            return definition;
        }
        throw new IllegalArgumentException("Illegal attribute mapping key: " + mappingKey);
    }

    @Override
    public Iterable<DefaultJavaAttributeMappingDefinition> getDefaultJavaAttributeMappingDefinitions() {
        return this.platformDefinition.getDefaultJavaAttributeMappingDefinitions();
    }
}

