/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceXmlElementRefAnnotation
extends SourceAnnotation
implements XmlElementRefAnnotation {
    public static final SimpleDeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlElementRef");
    private String fullyQualifiedTypeName;
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.buildNameDeclarationAdapter();
    private final AnnotationElementAdapter<String> nameAdapter = this.buildAnnotationElementAdapter(this.nameDeclarationAdapter);
    private String name;
    private final DeclarationAnnotationElementAdapter<String> namespaceDeclarationAdapter = this.buildNamespaceDeclarationAdapter();
    private final AnnotationElementAdapter<String> namespaceAdapter = this.buildAnnotationElementAdapter(this.namespaceDeclarationAdapter);
    private String namespace;
    private final DeclarationAnnotationElementAdapter<Boolean> requiredDeclarationAdapter;
    private final AnnotationElementAdapter<Boolean> requiredAdapter;
    private Boolean required;
    private final DeclarationAnnotationElementAdapter<String> typeDeclarationAdapter;
    private final AnnotationElementAdapter<String> typeAdapter;
    private String type;

    public static SourceXmlElementRefAnnotation buildSourceXmlElementRefAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
        return new SourceXmlElementRefAnnotation((JavaResourceNode)parent, annotatedElement, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER);
    }

    public static SourceXmlElementRefAnnotation buildNestedSourceXmlElementRefAnnotation(JavaResourceNode parent, AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new SourceXmlElementRefAnnotation(parent, annotatedElement, idaa);
    }

    private SourceXmlElementRefAnnotation(JavaResourceNode parent, AnnotatedElement annotatedElement, DeclarationAnnotationAdapter daa) {
        this(parent, annotatedElement, daa, (AnnotationAdapter)new ElementAnnotationAdapter(annotatedElement, daa));
    }

    private SourceXmlElementRefAnnotation(JavaResourceNode parent, AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, annotatedElement, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter(annotatedElement, idaa));
    }

    private SourceXmlElementRefAnnotation(JavaResourceNode parent, AnnotatedElement annotatedElement, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, annotatedElement, daa, annotationAdapter);
        this.requiredDeclarationAdapter = this.buildRequiredAdapter(daa);
        this.requiredAdapter = this.buildShortCircuitBooleanElementAdapter(this.requiredDeclarationAdapter);
        this.typeDeclarationAdapter = this.buildTypeDeclarationAdapter();
        this.typeAdapter = this.buildAnnotationElementAdapter(this.typeDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"name");
    }

    private DeclarationAnnotationElementAdapter<String> buildNamespaceDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"namespace");
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildRequiredAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"required");
    }

    private DeclarationAnnotationElementAdapter<String> buildTypeDeclarationAdapter() {
        return SourceXmlElementRefAnnotation.buildAnnotationElementAdapter(this.daa, "type", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private AnnotationElementAdapter<Boolean> buildShortCircuitBooleanElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlElementRef";
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.namespace = this.buildNamespace(astRoot);
        this.required = this.buildRequired(astRoot);
        this.type = this.buildType(astRoot);
        this.fullyQualifiedTypeName = this.buildFullyQualifiedTypeName(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.syncNamespace(this.buildNamespace(astRoot));
        this.syncRequired(this.buildRequired(astRoot));
        this.syncType(this.buildType(astRoot));
        this.syncFullyQualifiedTypeName(this.buildFullyQualifiedTypeName(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.nameDeclarationAdapter, pos, astRoot);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (this.attributeValueHasChanged(this.namespace, namespace)) {
            this.namespace = namespace;
            this.namespaceAdapter.setValue((Object)namespace);
        }
    }

    private void syncNamespace(String astNamespace) {
        String old = this.namespace;
        this.namespace = astNamespace;
        this.firePropertyChanged("namespace", old, astNamespace);
    }

    private String buildNamespace(CompilationUnit astRoot) {
        return (String)this.namespaceAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNamespaceTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.namespaceDeclarationAdapter, astRoot);
    }

    @Override
    public boolean namespaceTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.namespaceDeclarationAdapter, pos, astRoot);
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(Boolean required) {
        if (this.attributeValueHasChanged(this.required, required)) {
            this.required = required;
            this.requiredAdapter.setValue((Object)required);
        }
    }

    private void syncRequired(Boolean astRequired) {
        Boolean old = this.required;
        this.required = astRequired;
        this.firePropertyChanged("required", old, astRequired);
    }

    private Boolean buildRequired(CompilationUnit astRoot) {
        return (Boolean)this.requiredAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getRequiredTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.requiredDeclarationAdapter, astRoot);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (this.attributeValueHasChanged(this.type, type)) {
            this.type = type;
            this.typeAdapter.setValue((Object)type);
        }
    }

    private void syncType(String astType) {
        String old = this.type;
        this.type = astType;
        this.firePropertyChanged("type", old, astType);
    }

    private String buildType(CompilationUnit astRoot) {
        return (String)this.typeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.typeDeclarationAdapter, astRoot);
    }

    @Override
    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    private void syncFullyQualifiedTypeName(String name) {
        String old = this.fullyQualifiedTypeName;
        this.fullyQualifiedTypeName = name;
        this.firePropertyChanged("fullyQualifiedTypeName", old, name);
    }

    private String buildFullyQualifiedTypeName(CompilationUnit astRoot) {
        return this.type == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.typeAdapter.getExpression(astRoot));
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }
}

