/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassName;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkNamedConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaEclipseLinkConverter<A extends EclipseLinkNamedConverterAnnotation>
extends AbstractJavaJpaContextNode
implements EclipseLinkConverter {
    protected final A converterAnnotation;
    protected String name;

    protected JavaEclipseLinkConverter(JavaJpaContextNode parent, A converterAnnotation) {
        super((JpaContextNode)parent);
        this.converterAnnotation = converterAnnotation;
        this.name = converterAnnotation.getName();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.converterAnnotation.getName());
    }

    public void update() {
        super.update();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.converterAnnotation.setName(name);
        this.setName_(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    public A getConverterAnnotation() {
        return this.converterAnnotation;
    }

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    @Override
    public char getEnclosingTypeSeparator() {
        return '.';
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateName(messages, astRoot);
    }

    protected void validateName(List<IMessage> messages, CompilationUnit astRoot) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_NAME_UNDEFINED", EMPTY_STRING_ARRAY, this, this.getNameTextRange(astRoot)));
            return;
        }
        if (ArrayTools.contains((Object[])EclipseLinkConvert.RESERVED_CONVERTER_NAMES, (Object)this.name)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "RESERVED_CONVERTER_NAME", EMPTY_STRING_ARRAY, this, this.getNameTextRange(astRoot)));
        }
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.converterAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getConverterAnnotation().getNameTextRange(astRoot), astRoot);
    }

    @Override
    public boolean isIdentical(EclipseLinkConverter eclipseLinkConverter) {
        return StringTools.stringsAreEqual((String)this.getName(), (String)eclipseLinkConverter.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractAdapter
    implements Adapter {
        @Override
        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildConverter(JavaResourceMember member, JavaJpaContextNode parent) {
            EclipseLinkNamedConverterAnnotation annotation = this.getConverterAnnotation(member);
            return annotation == null ? null : this.buildConverter(annotation, parent);
        }

        @Override
        public EclipseLinkNamedConverterAnnotation getConverterAnnotation(JavaResourceMember member) {
            return (EclipseLinkNamedConverterAnnotation)member.getAnnotation(this.getAnnotationName());
        }

        protected abstract String getAnnotationName();

        @Override
        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildNewConverter(JavaResourceMember member, JavaJpaContextNode parent) {
            return this.buildConverter(this.buildConverterAnnotationIfNecessary(member), parent);
        }

        protected EclipseLinkNamedConverterAnnotation buildConverterAnnotationIfNecessary(JavaResourceMember member) {
            EclipseLinkNamedConverterAnnotation annotation = this.getConverterAnnotation(member);
            return annotation != null ? annotation : this.buildConverterAnnotation(member);
        }

        protected EclipseLinkNamedConverterAnnotation buildConverterAnnotation(JavaResourceMember member) {
            return (EclipseLinkNamedConverterAnnotation)member.addAnnotation(this.getAnnotationName());
        }

        @Override
        public void removeConverterAnnotation(JavaResourceMember member) {
            member.removeAnnotation(this.getAnnotationName());
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)ClassName.getSimpleName((String)this.getAnnotationName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Adapter {
        public Class<? extends EclipseLinkConverter> getConverterType();

        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildConverter(JavaResourceMember var1, JavaJpaContextNode var2);

        public EclipseLinkNamedConverterAnnotation getConverterAnnotation(JavaResourceMember var1);

        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildConverter(EclipseLinkNamedConverterAnnotation var1, JavaJpaContextNode var2);

        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildNewConverter(JavaResourceMember var1, JavaJpaContextNode var2);

        public void removeConverterAnnotation(JavaResourceMember var1);
    }
}

