/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverterHolder;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlNamedConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmEclipseLinkObjectTypeConverter
extends OrmEclipseLinkConverter<XmlObjectTypeConverter>
implements EclipseLinkObjectTypeConverter {
    private String dataType;
    private String objectType;
    protected final AbstractJpaNode.ContextListContainer<OrmEclipseLinkConversionValue, XmlConversionValue> conversionValueContainer;
    private String defaultObjectValue;

    public OrmEclipseLinkObjectTypeConverter(XmlContextNode parent, XmlObjectTypeConverter xmlConverter) {
        super(parent, xmlConverter);
        this.dataType = xmlConverter.getDataType();
        this.objectType = xmlConverter.getObjectType();
        this.conversionValueContainer = this.buildConversionValueContainer();
        this.defaultObjectValue = xmlConverter.getDefaultObjectValue();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDataType_(((XmlObjectTypeConverter)this.xmlConverter).getDataType());
        this.setObjectType_(((XmlObjectTypeConverter)this.xmlConverter).getObjectType());
        this.syncConversionValues();
        this.setDefaultObjectValue_(((XmlObjectTypeConverter)this.xmlConverter).getDefaultObjectValue());
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable)this.getConversionValues());
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String dataType) {
        this.setDataType_(dataType);
        ((XmlObjectTypeConverter)this.xmlConverter).setDataType(dataType);
    }

    protected void setDataType_(String dataType) {
        String old = this.dataType;
        this.dataType = dataType;
        this.firePropertyChanged("dataType", old, dataType);
    }

    protected boolean dataTypeIsFor(String typeName) {
        return this.typeIsFor(this.getDataTypeJavaResourceType(), typeName);
    }

    protected boolean dataTypeIsIn(IPackageFragment packageFragment) {
        return this.typeIsIn(this.getDataTypeJavaResourceType(), packageFragment);
    }

    protected JavaResourceAbstractType getDataTypeJavaResourceType() {
        return this.getMappingFileRoot().resolveJavaResourceType(this.getDataType());
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String objectType) {
        this.setObjectType_(objectType);
        ((XmlObjectTypeConverter)this.xmlConverter).setObjectType(objectType);
    }

    protected void setObjectType_(String objectType) {
        String old = this.objectType;
        this.objectType = objectType;
        this.firePropertyChanged("objectType", old, objectType);
    }

    protected boolean objectTypeIsFor(String typeName) {
        return this.typeIsFor(this.getObjectTypeJavaResourceType(), typeName);
    }

    protected boolean objectTypeIsIn(IPackageFragment packageFragment) {
        return this.typeIsIn(this.getObjectTypeJavaResourceType(), packageFragment);
    }

    protected JavaResourceAbstractType getObjectTypeJavaResourceType() {
        return this.getMappingFileRoot().resolveJavaResourceType(this.getObjectType());
    }

    public ListIterable<OrmEclipseLinkConversionValue> getConversionValues() {
        return this.conversionValueContainer.getContextElements();
    }

    @Override
    public int getConversionValuesSize() {
        return this.conversionValueContainer.getContextElementsSize();
    }

    @Override
    public OrmEclipseLinkConversionValue addConversionValue() {
        return this.addConversionValue(this.getConversionValuesSize());
    }

    @Override
    public OrmEclipseLinkConversionValue addConversionValue(int index) {
        XmlConversionValue xmlConversionValue = this.buildXmlConversionValue();
        OrmEclipseLinkConversionValue conversionValue = (OrmEclipseLinkConversionValue)this.conversionValueContainer.addContextElement(index, (Object)xmlConversionValue);
        ((XmlObjectTypeConverter)this.xmlConverter).getConversionValues().add(index, (Object)xmlConversionValue);
        return conversionValue;
    }

    protected XmlConversionValue buildXmlConversionValue() {
        return EclipseLinkOrmFactory.eINSTANCE.createXmlConversionValue();
    }

    @Override
    public void removeConversionValue(EclipseLinkConversionValue conversionValue) {
        this.removeConversionValue(this.conversionValueContainer.indexOfContextElement((JpaContextNode)((OrmEclipseLinkConversionValue)conversionValue)));
    }

    @Override
    public void removeConversionValue(int index) {
        this.conversionValueContainer.removeContextElement(index);
        ((XmlObjectTypeConverter)this.xmlConverter).getConversionValues().remove(index);
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        this.conversionValueContainer.moveContextElement(targetIndex, sourceIndex);
        ((XmlObjectTypeConverter)this.xmlConverter).getConversionValues().move(targetIndex, sourceIndex);
    }

    protected OrmEclipseLinkConversionValue buildConversionValue(XmlConversionValue xmlConversionValue) {
        return new OrmEclipseLinkConversionValue(this, xmlConversionValue);
    }

    protected void syncConversionValues() {
        this.conversionValueContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlConversionValue> getXmlConversionValues() {
        return new LiveCloneListIterable(((XmlObjectTypeConverter)this.xmlConverter).getConversionValues());
    }

    protected AbstractJpaNode.ContextListContainer<OrmEclipseLinkConversionValue, XmlConversionValue> buildConversionValueContainer() {
        ConversionValueContainer container = new ConversionValueContainer();
        container.initialize();
        return container;
    }

    @Override
    public Iterable<String> getDataValues() {
        return new TransformationIterable<OrmEclipseLinkConversionValue, String>(this.getConversionValues()){

            protected String transform(OrmEclipseLinkConversionValue conversionValue) {
                return conversionValue.getDataValue();
            }
        };
    }

    @Override
    public int getDataValuesSize() {
        return this.getConversionValuesSize();
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String value) {
        this.setDefaultObjectValue_(value);
        ((XmlObjectTypeConverter)this.xmlConverter).setDefaultObjectValue(value);
    }

    protected void setDefaultObjectValue_(String value) {
        String old = this.defaultObjectValue;
        this.defaultObjectValue = value;
        this.firePropertyChanged("defaultObjectValue", old, value);
    }

    public Class<EclipseLinkObjectTypeConverter> getType() {
        return EclipseLinkObjectTypeConverter.class;
    }

    protected boolean typeIsFor(JavaResourceAbstractType type, String typeName) {
        return type != null && type.getQualifiedName().equals(typeName);
    }

    protected boolean typeIsIn(JavaResourceAbstractType type, IPackageFragment packageFragment) {
        return type != null && type.isIn(packageFragment);
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return new CompositeIterable(new Iterable[]{this.createRenameDataTypeEdits(originalType, newName), this.createRenameObjectTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createRenameDataTypeEdits(IType originalType, String newName) {
        return this.dataTypeIsFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenameDataTypeEdit(originalType, newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenameDataTypeEdit(IType originalType, String newName) {
        return ((XmlObjectTypeConverter)this.xmlConverter).createRenameDataTypeEdit(originalType, newName);
    }

    protected Iterable<ReplaceEdit> createRenameObjectTypeEdits(IType originalType, String newName) {
        return this.objectTypeIsFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenameObjectTypeEdit(originalType, newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenameObjectTypeEdit(IType originalType, String newName) {
        return ((XmlObjectTypeConverter)this.xmlConverter).createRenameObjectTypeEdit(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return new CompositeIterable(new Iterable[]{this.createMoveDataTypeEdits(originalType, newPackage), this.createMoveObjectTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createMoveDataTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.dataTypeIsFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenameDataTypePackageEdit(newPackage.getElementName())) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenameDataTypePackageEdit(String newName) {
        return ((XmlObjectTypeConverter)this.xmlConverter).createRenameDataTypePackageEdit(newName);
    }

    protected Iterable<ReplaceEdit> createMoveObjectTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.objectTypeIsFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenameObjectTypePackageEdit(newPackage.getElementName())) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenameObjectTypePackageEdit(String newName) {
        return ((XmlObjectTypeConverter)this.xmlConverter).createRenameObjectTypePackageEdit(newName);
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return new CompositeIterable(new Iterable[]{this.createRenameDataTypePackageEdits(originalPackage, newName), this.createRenameObjectTypePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createRenameDataTypePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.dataTypeIsIn(originalPackage) ? new SingleElementIterable((Object)this.createRenameDataTypePackageEdit(newName)) : EmptyIterable.instance();
    }

    protected Iterable<ReplaceEdit> createRenameObjectTypePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.objectTypeIsIn(originalPackage) ? new SingleElementIterable((Object)this.createRenameObjectTypePackageEdit(newName)) : EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.checkForDuplicateDataValues(messages);
        for (OrmEclipseLinkConversionValue conversionValue : this.getConversionValues()) {
            conversionValue.validate(messages, reporter);
        }
    }

    protected void checkForDuplicateDataValues(List<IMessage> messages) {
        for (ArrayList<OrmEclipseLinkConversionValue> dups : this.mapConversionValuesByDataValue().values()) {
            if (dups.size() <= 1) continue;
            for (OrmEclipseLinkConversionValue dup : dups) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "MULTIPLE_OBJECT_VALUES_FOR_DATA_VALUE", new String[]{dup.getDataValue()}, this, dup.getDataValueTextRange()));
            }
        }
    }

    protected HashMap<String, ArrayList<OrmEclipseLinkConversionValue>> mapConversionValuesByDataValue() {
        HashMap<String, ArrayList<OrmEclipseLinkConversionValue>> map = new HashMap<String, ArrayList<OrmEclipseLinkConversionValue>>(this.getConversionValuesSize());
        for (OrmEclipseLinkConversionValue conversionValue : this.getConversionValues()) {
            String dataValue = conversionValue.getDataValue();
            ArrayList<OrmEclipseLinkConversionValue> list = map.get(dataValue);
            if (list == null) {
                list = new ArrayList();
                map.put(dataValue, list);
            }
            list.add(conversionValue);
        }
        return map;
    }

    @Override
    public boolean isIdentical(EclipseLinkConverter eclipseLinkConverter) {
        return super.isIdentical(eclipseLinkConverter) && StringTools.stringsAreEqual((String)this.getObjectType(), (String)((EclipseLinkObjectTypeConverter)eclipseLinkConverter).getObjectType()) && StringTools.stringsAreEqual((String)this.getDataType(), (String)((EclipseLinkObjectTypeConverter)eclipseLinkConverter).getDataType()) && StringTools.stringsAreEqual((String)this.getDefaultObjectValue(), (String)((EclipseLinkObjectTypeConverter)eclipseLinkConverter).getDefaultObjectValue()) && this.conversionValuesAreIdentical(((EclipseLinkObjectTypeConverter)eclipseLinkConverter).getConversionValues());
    }

    private boolean conversionValuesAreIdentical(ListIterable<? extends EclipseLinkConversionValue> conversionValues) {
        boolean isIdentical = true;
        if (this.getConversionValuesSize() != CollectionTools.size(conversionValues)) {
            return false;
        }
        int i = 0;
        while (i < this.getConversionValuesSize()) {
            if (!((OrmEclipseLinkConversionValue)CollectionTools.get(this.getConversionValues(), (int)i)).isIdentical((EclipseLinkConversionValue)CollectionTools.get(conversionValues, (int)i))) {
                isIdentical = false;
            }
            ++i;
        }
        return isIdentical;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    extends OrmEclipseLinkConverter.AbstractAdapter {
        private static final Adapter INSTANCE = new Adapter();

        public static Adapter instance() {
            return INSTANCE;
        }

        private Adapter() {
        }

        public Class<EclipseLinkObjectTypeConverter> getConverterType() {
            return EclipseLinkObjectTypeConverter.class;
        }

        @Override
        public XmlObjectTypeConverter getXmlConverter(XmlConverterHolder xmlConverterContainer) {
            return xmlConverterContainer.getObjectTypeConverter();
        }

        @Override
        public OrmEclipseLinkConverter<? extends XmlNamedConverter> buildConverter(XmlNamedConverter xmlConverter, XmlContextNode parent) {
            return new OrmEclipseLinkObjectTypeConverter(parent, (XmlObjectTypeConverter)xmlConverter);
        }

        @Override
        protected XmlObjectTypeConverter buildXmlConverter() {
            return EclipseLinkOrmFactory.eINSTANCE.createXmlObjectTypeConverter();
        }

        @Override
        protected void setXmlConverter(XmlConverterHolder xmlConverterContainer, XmlNamedConverter xmlConverter) {
            xmlConverterContainer.setObjectTypeConverter((XmlObjectTypeConverter)xmlConverter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConversionValueContainer
    extends AbstractJpaNode.ContextListContainer<OrmEclipseLinkConversionValue, XmlConversionValue> {
        protected ConversionValueContainer() {
            super((AbstractJpaNode)OrmEclipseLinkObjectTypeConverter.this);
        }

        protected String getContextElementsPropertyName() {
            return "conversionValues";
        }

        protected OrmEclipseLinkConversionValue buildContextElement(XmlConversionValue resourceElement) {
            return OrmEclipseLinkObjectTypeConverter.this.buildConversionValue(resourceElement);
        }

        protected ListIterable<XmlConversionValue> getResourceElements() {
            return OrmEclipseLinkObjectTypeConverter.this.getXmlConversionValues();
        }

        protected XmlConversionValue getResourceElement(OrmEclipseLinkConversionValue contextElement) {
            return contextElement.getXmlConversionValue();
        }
    }
}

