/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.TypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source.SourceEclipseLinkNamedConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.BaseEclipseLinkTypeConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceBaseEclipseLinkTypeConverterAnnotation
extends SourceEclipseLinkNamedConverterAnnotation
implements BaseEclipseLinkTypeConverterAnnotation {
    final DeclarationAnnotationElementAdapter<String> dataTypeDeclarationAdapter = this.buildTypeAdapter(this.getDataTypeElementName());
    final AnnotationElementAdapter<String> dataTypeAdapter = new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, this.dataTypeDeclarationAdapter);
    String dataType;
    TextRange dataTypeTextRange;
    String fullyQualifiedDataType;
    boolean fqDataTypeStale = true;
    final DeclarationAnnotationElementAdapter<String> objectTypeDeclarationAdapter = this.buildTypeAdapter(this.getObjectTypeElementName());
    final AnnotationElementAdapter<String> objectTypeAdapter = new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, this.objectTypeDeclarationAdapter);
    String objectType;
    TextRange objectTypeTextRange;
    String fullyQualifiedObjectType;
    boolean fqObjectTypeStale = true;

    SourceBaseEclipseLinkTypeConverterAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super((JavaResourceNode)parent, element, daa);
    }

    private DeclarationAnnotationElementAdapter<String> buildTypeAdapter(String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, elementName, TypeStringExpressionConverter.instance());
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.dataType = this.buildDataType(astRoot);
        this.dataTypeTextRange = this.buildDataTypeTextRange(astRoot);
        this.objectType = this.buildObjectType(astRoot);
        this.objectTypeTextRange = this.buildObjectTypeTextRange(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncDataType(this.buildDataType(astRoot));
        this.dataTypeTextRange = this.buildDataTypeTextRange(astRoot);
        this.syncObjectType(this.buildObjectType(astRoot));
        this.objectTypeTextRange = this.buildObjectTypeTextRange(astRoot);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.dataType == null && this.objectType == null;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String dataType) {
        if (this.attributeValueHasChanged(this.dataType, dataType)) {
            this.dataType = dataType;
            this.fqDataTypeStale = true;
            this.dataTypeAdapter.setValue((Object)dataType);
        }
    }

    private void syncDataType(String astDataType) {
        if (this.attributeValueHasChanged(this.dataType, astDataType)) {
            this.syncDataType_(astDataType);
        }
    }

    private void syncDataType_(String astDataType) {
        String old = this.dataType;
        this.dataType = astDataType;
        this.fqDataTypeStale = true;
        this.firePropertyChanged("dataType", old, astDataType);
    }

    private String buildDataType(CompilationUnit astRoot) {
        return (String)this.dataTypeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDataTypeTextRange(CompilationUnit astRoot) {
        return this.dataTypeTextRange;
    }

    private TextRange buildDataTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.dataTypeDeclarationAdapter, astRoot);
    }

    abstract String getDataTypeElementName();

    @Override
    public String getFullyQualifiedDataType() {
        if (this.fqDataTypeStale) {
            this.fullyQualifiedDataType = this.buildFullyQualifiedDataType();
            this.fqDataTypeStale = false;
        }
        return this.fullyQualifiedDataType;
    }

    private String buildFullyQualifiedDataType() {
        return this.dataType == null ? null : this.buildFullyQualifiedDataType_();
    }

    private String buildFullyQualifiedDataType_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.dataTypeAdapter.getExpression(this.buildASTRoot()));
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String objectType) {
        if (this.attributeValueHasChanged(this.objectType, objectType)) {
            this.objectType = objectType;
            this.fqObjectTypeStale = true;
            this.objectTypeAdapter.setValue((Object)objectType);
        }
    }

    private void syncObjectType(String astObjectType) {
        if (this.attributeValueHasChanged(this.objectType, astObjectType)) {
            this.syncObjectType_(astObjectType);
        }
    }

    private void syncObjectType_(String astObjectType) {
        String old = this.objectType;
        this.objectType = astObjectType;
        this.fqObjectTypeStale = true;
        this.firePropertyChanged("objectType", old, astObjectType);
    }

    private String buildObjectType(CompilationUnit astRoot) {
        return (String)this.objectTypeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getObjectTypeTextRange(CompilationUnit astRoot) {
        return this.objectTypeTextRange;
    }

    private TextRange buildObjectTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.objectTypeDeclarationAdapter, astRoot);
    }

    abstract String getObjectTypeElementName();

    @Override
    public String getFullyQualifiedObjectType() {
        if (this.fqObjectTypeStale) {
            this.fullyQualifiedObjectType = this.buildFullyQualifiedObjectType();
            this.fqObjectTypeStale = false;
        }
        return this.fullyQualifiedObjectType;
    }

    private String buildFullyQualifiedObjectType() {
        return this.objectType == null ? null : this.buildFullyQualifiedObjectType_();
    }

    private String buildFullyQualifiedObjectType_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.objectTypeAdapter.getExpression(this.buildASTRoot()));
    }
}

