/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.resource.java.FetchType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkTransformationAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEclipseLinkTransformationAnnotation
extends SourceAnnotation
implements EclipseLinkTransformationAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Transformation");
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceEclipseLinkTransformationAnnotation.buildFetchAdapter();
    private final AnnotationElementAdapter<String> fetchAdapter;
    private FetchType fetch;
    private static final DeclarationAnnotationElementAdapter<Boolean> OPTIONAL_ADAPTER = SourceEclipseLinkTransformationAnnotation.buildOptionalAdapter();
    private final AnnotationElementAdapter<Boolean> optionalAdapter;
    private Boolean optional;

    public SourceEclipseLinkTransformationAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super((JavaResourceNode)parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.fetchAdapter = new AnnotatedElementAnnotationElementAdapter(element, FETCH_ADAPTER);
        this.optionalAdapter = new AnnotatedElementAnnotationElementAdapter(element, OPTIONAL_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Transformation";
    }

    public void initialize(CompilationUnit astRoot) {
        this.fetch = this.buildFetch(astRoot);
        this.optional = this.buildOptional(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncFetch(this.buildFetch(astRoot));
        this.syncOptional(this.buildOptional(astRoot));
    }

    public boolean isUnset() {
        return super.isUnset() && this.fetch == null && this.optional == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.fetch);
    }

    @Override
    public FetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(FetchType fetch) {
        if (this.attributeValueHasChanged(this.fetch, fetch)) {
            this.fetch = fetch;
            this.fetchAdapter.setValue((Object)FetchType.toJavaAnnotationValue((FetchType)fetch));
        }
    }

    private void syncFetch(FetchType astFetch) {
        FetchType old = this.fetch;
        this.fetch = astFetch;
        this.firePropertyChanged("fetch", old, astFetch);
    }

    private FetchType buildFetch(CompilationUnit astRoot) {
        return FetchType.fromJavaAnnotationValue((Object)this.fetchAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getFetchTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(FETCH_ADAPTER, astRoot);
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        if (this.attributeValueHasChanged(this.optional, optional)) {
            this.optional = optional;
            this.optionalAdapter.setValue((Object)optional);
        }
    }

    private void syncOptional(Boolean astOptional) {
        Boolean old = this.optional;
        this.optional = astOptional;
        this.firePropertyChanged("optional", old, astOptional);
    }

    private Boolean buildOptional(CompilationUnit astRoot) {
        return (Boolean)this.optionalAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getOptionalTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(OPTIONAL_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "optional", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }
}

