/*******************************************************************************
* Copyright (c) 2008, 2011 Oracle. All rights reserved.
* This program and the accompanying materials are made available under the
* terms of the Eclipse Public License v1.0, which accompanies this distribution
* and is available at http://www.eclipse.org/legal/epl-v10.html.
* 
* Contributors:
*     Oracle - initial API and implementation
*******************************************************************************/
package org.eclipse.jpt.jpa.eclipselink.core.context.persistence;

/**
 *  TargetServer
 */
public enum TargetServer {
			none,
			oc4j,
			sunas9,
			websphere,
			websphere_6_1,
			websphere_7,
			weblogic,
			weblogic_9,
			weblogic_10,
			jboss,
			netweaver_7_1;

	// EclipseLink value string
	static final String NONE = "None";
	static final String OC4J = "OC4J";
	static final String SUNAS9 = "SunAS9";
	static final String WEBSPHERE = "WebSphere";
	static final String WEBSPHERE_6_1 = "WebSphere_6_1";
	static final String WEBSPHERE_7 = "WebSphere_7";
	static final String WEBLOGIC = "WebLogic";
	static final String WEBLOGIC_9 = "WebLogic_9";
	static final String WEBLOGIC_10 = "WebLogic_10";
	static final String JBOSS = "JBoss";
    static final String SAPNETWEAVER_7_1 = "NetWeaver_7_1";

	/**
	 * Return the TargetServer value corresponding to the given literal.
	 */
	public static TargetServer getTargetServerFor(String literal) {
		
		for( TargetServer targetServer : TargetServer.values()) {
			if(targetServer.toString().equals(literal)) {
				return targetServer;
			}
		}
		return null;
	}
}