/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.JpaMakePersistentWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakePersistentAction
implements IObjectActionDelegate {
    private Map<IProject, List<IType>> selectedTypes;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedTypes = this.buildSelectedTypes((StructuredSelection)selection);
    }

    protected Map<IProject, List<IType>> buildSelectedTypes(StructuredSelection structuredSelection) {
        HashMap<IProject, List<IType>> types = new HashMap<IProject, List<IType>>();
        for (Object selection : structuredSelection.toList()) {
            switch (((IJavaElement)selection).getElementType()) {
                case 7: {
                    this.addSelectedType((IType)selection, types);
                    break;
                }
                case 5: {
                    this.addSelectedType((ICompilationUnit)selection, types);
                    break;
                }
                case 4: {
                    this.addSelectedType((IPackageFragment)selection, types);
                    break;
                }
                case 3: {
                    this.addSelectedType((IPackageFragmentRoot)selection, types);
                    break;
                }
            }
        }
        return types;
    }

    private void addSelectedType(IPackageFragmentRoot packageFragmentRoot, Map<IProject, List<IType>> types) {
        IJavaElement[] iJavaElementArray = this.getPackageFragments(packageFragmentRoot);
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement pkgFragment = iJavaElementArray[n2];
            this.addSelectedType((IPackageFragment)pkgFragment, types);
            ++n2;
        }
    }

    private void addSelectedType(IPackageFragment packageFragment, Map<IProject, List<IType>> types) {
        ICompilationUnit[] iCompilationUnitArray = this.getCompilationUnits(packageFragment);
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit compUnit = iCompilationUnitArray[n2];
            this.addSelectedType(compUnit, types);
            ++n2;
        }
    }

    private void addSelectedType(ICompilationUnit compilationUnit, Map<IProject, List<IType>> types) {
        IType primaryType = this.getPrimaryType(compilationUnit);
        if (primaryType != null) {
            this.addSelectedType(primaryType, types);
        }
    }

    private void addSelectedType(IType primaryType, Map<IProject, List<IType>> typesMap) {
        IProject project = primaryType.getJavaProject().getProject();
        List<IType> types = typesMap.get(project);
        if (types == null) {
            types = new ArrayList<IType>();
            typesMap.put(project, types);
        }
        if (!types.contains(primaryType)) {
            types.add(primaryType);
        }
    }

    private ICompilationUnit[] getCompilationUnits(IPackageFragment packageFragment) {
        try {
            return packageFragment.getCompilationUnits();
        }
        catch (JavaModelException e) {
            JptJpaUiPlugin.log(e);
            return new ICompilationUnit[0];
        }
    }

    private IJavaElement[] getPackageFragments(IPackageFragmentRoot packageFragmentRoot) {
        try {
            return packageFragmentRoot.getChildren();
        }
        catch (JavaModelException e) {
            JptJpaUiPlugin.log(e);
            return new IJavaElement[0];
        }
    }

    private IType getPrimaryType(ICompilationUnit compilationUnit) {
        return compilationUnit.findPrimaryType();
    }

    public void run(IAction action) {
        for (List<IType> types : this.selectedTypes.values()) {
            JpaMakePersistentWizard wizard = new JpaMakePersistentWizard(types);
            WizardDialog dialog = new WizardDialog(this.getCurrentShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
    }

    private Shell getCurrentShell() {
        return Display.getCurrent().getActiveShell();
    }
}

