/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.internal.utility.ICUStringCollator;
import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.properties.JptProjectPropertiesPage;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.internal.utility.swt.SWTTools;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.NotBooleanTransformer;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.model.value.AbstractCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.AspectCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.BufferedWritablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.CachingTransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.CompositePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ExtendedListValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SetCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationWritablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaDataSource;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.jpa2.JpaProject2_0;
import org.eclipse.jpt.jpa.core.libprov.JpaLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformGroupDescription;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.ConnectionAdapter;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.db.ConnectionProfileListener;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.JptJpaDbPlugin;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.db.ui.internal.DTPUiTools;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.jpa2.Jpa2_0ProjectFlagModel;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderFrameworkUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaProjectPropertiesPage
extends JptProjectPropertiesPage {
    public static final String PROP_ID = "org.eclipse.jpt.jpa.ui.jpaProjectProperties";
    private PropertyValueModel<JpaProject> jpaProjectModel;
    private BufferedWritablePropertyValueModel<String> platformIdModel;
    private PropertyChangeListener platformIdListener;
    private BufferedWritablePropertyValueModel<String> connectionModel;
    private PropertyValueModel<ConnectionProfile> connectionProfileModel;
    private PropertyValueModel<Boolean> disconnectedModel;
    private PropertyChangeListener disconnectedModelListener;
    private Link connectLink;
    private BufferedWritablePropertyValueModel<Boolean> userOverrideDefaultCatalogFlagModel;
    private BufferedWritablePropertyValueModel<String> userOverrideDefaultCatalogModel;
    private WritablePropertyValueModel<String> defaultCatalogModel;
    private ListValueModel<String> catalogChoicesModel;
    private BufferedWritablePropertyValueModel<Boolean> userOverrideDefaultSchemaFlagModel;
    private BufferedWritablePropertyValueModel<String> userOverrideDefaultSchemaModel;
    private WritablePropertyValueModel<String> defaultSchemaModel;
    private ListValueModel<String> schemaChoicesModel;
    private BufferedWritablePropertyValueModel<Boolean> discoverAnnotatedClassesModel;
    private WritablePropertyValueModel<Boolean> listAnnotatedClassesModel;
    private PropertyValueModel<Boolean> jpa2_0ProjectFlagModel;
    private BufferedWritablePropertyValueModel<String> metamodelSourceFolderModel;
    private ListValueModel<String> javaSourceFolderChoicesModel;
    private static final String BUILD_PATHS_PROPERTY_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
    static final Comparator<String> STRING_COMPARATOR = new ICUStringCollator();
    private static final Comparator<String> JPA_PLATFORM_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String id1, String id2) {
            String label1 = JpaProjectPropertiesPage.getJpaPlatformLabel(id1);
            String label2 = JpaProjectPropertiesPage.getJpaPlatformLabel(id2);
            return STRING_COMPARATOR.compare(label1, label2);
        }
    };
    private static final StringConverter<String> JPA_PLATFORM_LABEL_CONVERTER = new StringConverter<String>(){

        public String convertToString(String id) {
            return JpaProjectPropertiesPage.getJpaPlatformLabel(id);
        }
    };
    private static final StringConverter<String> SIMPLE_STRING_CONVERTER = new StringConverter<String>(){

        public String convertToString(String string) {
            return string != null ? string : JptUiMessages.JpaFacetWizardPage_none;
        }
    };
    private static final ListValueModel<String> CONNECTION_CHOICES_MODEL = new ExtendedListValueModelWrapper((ListValueModel)new SortedListValueModelAdapter((CollectionValueModel)new ConnectionChoicesModel(), STRING_COMPARATOR));

    protected void buildModels() {
        this.jpaProjectModel = new JpaProjectModel((PropertyValueModel<IProject>)this.projectModel);
        this.platformIdModel = this.buildPlatformIdModel();
        this.platformIdListener = this.buildPlatformIdListener();
        this.connectionModel = this.buildConnectionModel();
        this.connectionProfileModel = this.buildConnectionProfileModel();
        this.disconnectedModel = this.buildDisconnectedModel();
        this.disconnectedModelListener = this.buildDisconnectedModelListener();
        this.userOverrideDefaultCatalogFlagModel = this.buildUserOverrideDefaultCatalogFlagModel();
        this.userOverrideDefaultCatalogModel = this.buildUserOverrideDefaultCatalogModel();
        this.defaultCatalogModel = this.buildDefaultCatalogModel();
        this.catalogChoicesModel = this.buildCatalogChoicesModel();
        this.userOverrideDefaultSchemaFlagModel = this.buildUserOverrideDefaultSchemaFlagModel();
        this.userOverrideDefaultSchemaModel = this.buildUserOverrideDefaultSchemaModel();
        this.defaultSchemaModel = this.buildDefaultSchemaModel();
        this.schemaChoicesModel = this.buildSchemaChoicesModel();
        this.discoverAnnotatedClassesModel = this.buildDiscoverAnnotatedClassesModel();
        this.listAnnotatedClassesModel = this.buildListAnnotatedClassesModel();
        this.jpa2_0ProjectFlagModel = this.buildJpa2_0ProjectFlagModel();
        this.metamodelSourceFolderModel = this.buildMetamodelSourceFolderModel();
        this.javaSourceFolderChoicesModel = this.buildJavaSourceFolderChoicesModel();
    }

    private BufferedWritablePropertyValueModel<String> buildPlatformIdModel() {
        return new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new PlatformIdModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private PropertyChangeListener buildPlatformIdListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                JpaProjectPropertiesPage.this.platformIdChanged((String)event.getNewValue());
            }
        };
    }

    void platformIdChanged(String newPlatformId) {
        if (!this.getControl().isDisposed()) {
            this.adjustLibraryProviders();
        }
    }

    private BufferedWritablePropertyValueModel<String> buildConnectionModel() {
        return new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new ConnectionModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private PropertyValueModel<ConnectionProfile> buildConnectionProfileModel() {
        return new ConnectionProfileModel((PropertyValueModel<String>)this.connectionModel);
    }

    private PropertyValueModel<Boolean> buildDisconnectedModel() {
        return new DisconnectedModel(this.connectionProfileModel);
    }

    private BufferedWritablePropertyValueModel<Boolean> buildUserOverrideDefaultCatalogFlagModel() {
        return new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new UserOverrideDefaultCatalogFlagModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private BufferedWritablePropertyValueModel<String> buildUserOverrideDefaultCatalogModel() {
        return new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new UserOverrideDefaultCatalogModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private WritablePropertyValueModel<String> buildDefaultCatalogModel() {
        return new DefaultModel((PropertyValueModel<Boolean>)this.userOverrideDefaultCatalogFlagModel, (WritablePropertyValueModel<String>)this.userOverrideDefaultCatalogModel, this.buildDatabaseDefaultCatalogModel());
    }

    private PropertyValueModel<String> buildDatabaseDefaultCatalogModel() {
        return new DatabaseDefaultCatalogModel(this.connectionProfileModel);
    }

    private ListValueModel<String> buildCatalogChoicesModel() {
        return new SortedListValueModelAdapter(this.buildUnsortedCatalogChoicesModel(), STRING_COMPARATOR);
    }

    private CollectionValueModel<String> buildUnsortedCatalogChoicesModel() {
        return new SetCollectionValueModel((CollectionValueModel)new CompositeCollectionValueModel((Object[])new CollectionValueModel[]{new PropertyCollectionValueModelAdapter(this.defaultCatalogModel), this.buildDatabaseCatalogChoicesModel()}));
    }

    private CollectionValueModel<String> buildDatabaseCatalogChoicesModel() {
        return new DatabaseCatalogChoicesModel(this.connectionProfileModel);
    }

    private BufferedWritablePropertyValueModel<Boolean> buildUserOverrideDefaultSchemaFlagModel() {
        return new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new UserOverrideDefaultSchemaFlagModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private BufferedWritablePropertyValueModel<String> buildUserOverrideDefaultSchemaModel() {
        return new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new UserOverrideDefaultSchemaModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private WritablePropertyValueModel<String> buildDefaultSchemaModel() {
        return new DefaultModel((PropertyValueModel<Boolean>)this.userOverrideDefaultSchemaFlagModel, (WritablePropertyValueModel<String>)this.userOverrideDefaultSchemaModel, this.buildDatabaseDefaultSchemaModel());
    }

    private PropertyValueModel<String> buildDatabaseDefaultSchemaModel() {
        return new DatabaseDefaultSchemaModel(this.connectionProfileModel, (PropertyValueModel<String>)this.defaultCatalogModel);
    }

    private ListValueModel<String> buildSchemaChoicesModel() {
        return new SortedListValueModelAdapter(this.buildUnsortedSchemaChoicesModel(), STRING_COMPARATOR);
    }

    private CollectionValueModel<String> buildUnsortedSchemaChoicesModel() {
        return new SetCollectionValueModel((CollectionValueModel)new CompositeCollectionValueModel((Object[])new CollectionValueModel[]{new PropertyCollectionValueModelAdapter(this.defaultSchemaModel), this.buildDatabaseSchemaChoicesModel()}));
    }

    private CollectionValueModel<String> buildDatabaseSchemaChoicesModel() {
        return new DatabaseSchemaChoicesModel(this.connectionProfileModel, (PropertyValueModel<String>)this.defaultCatalogModel);
    }

    private BufferedWritablePropertyValueModel<Boolean> buildDiscoverAnnotatedClassesModel() {
        return new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new DiscoverAnnotatedClassesModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private WritablePropertyValueModel<Boolean> buildListAnnotatedClassesModel() {
        return new TransformationWritablePropertyValueModel(this.discoverAnnotatedClassesModel, NotBooleanTransformer.instance());
    }

    private PropertyValueModel<Boolean> buildJpa2_0ProjectFlagModel() {
        return new Jpa2_0ProjectFlagModel<JpaProject>(this.jpaProjectModel);
    }

    private BufferedWritablePropertyValueModel<String> buildMetamodelSourceFolderModel() {
        return new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new MetamodelSourceFolderModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private ListValueModel<String> buildJavaSourceFolderChoicesModel() {
        return new ExtendedListValueModelWrapper((ListValueModel)new SortedListValueModelAdapter((CollectionValueModel)new JavaSourceFolderChoicesModel(this.jpaProjectModel), STRING_COMPARATOR));
    }

    private String getConnectionName() {
        return (String)this.connectionModel.getValue();
    }

    private ConnectionProfile getConnectionProfile() {
        return (ConnectionProfile)this.connectionProfileModel.getValue();
    }

    private boolean userOverrideDefaultCatalogFlagIsSet() {
        return JpaProjectPropertiesPage.flagIsSet(this.userOverrideDefaultCatalogFlagModel);
    }

    private String getUserOverrideDefaultCatalog() {
        return (String)this.userOverrideDefaultCatalogModel.getValue();
    }

    private boolean userOverrideDefaultSchemaFlagIsSet() {
        return JpaProjectPropertiesPage.flagIsSet(this.userOverrideDefaultSchemaFlagModel);
    }

    private String getUserOverrideDefaultSchema() {
        return (String)this.userOverrideDefaultSchemaModel.getValue();
    }

    private IWorkbenchPreferenceContainer getWorkbenchPreferenceContainer() {
        IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
        return container;
    }

    public IProjectFacetVersion getProjectFacetVersion() {
        return this.getFacetedProject().getInstalledVersion(JpaFacet.FACET);
    }

    protected LibraryInstallDelegate createLibraryInstallDelegate(IFacetedProject project, IProjectFacetVersion fv) {
        HashMap<String, Object> enablementVariables = new HashMap<String, Object>();
        enablementVariables.put("jpaPlatform", "");
        enablementVariables.put("jpaPlatformDescription", new JpaPlatformDescription(){

            public boolean supportsJpaFacetVersion(IProjectFacetVersion jpaFacetVersion) {
                return false;
            }

            public boolean isDefault() {
                return false;
            }

            public String getPluginId() {
                return null;
            }

            public String getLabel() {
                return null;
            }

            public String getId() {
                return null;
            }

            public JpaPlatformGroupDescription getGroup() {
                return null;
            }

            public String getFactoryClassName() {
                return null;
            }
        });
        LibraryInstallDelegate lid = new LibraryInstallDelegate((IFacetedProjectBase)project, fv, enablementVariables);
        lid.addListener(this.buildLibraryProviderListener(), new String[0]);
        return lid;
    }

    protected void adjustLibraryProviders() {
        LibraryInstallDelegate lid = this.getLibraryInstallDelegate();
        if (lid != null) {
            JpaPlatformDescription jpaPlatform = JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatform((String)this.platformIdModel.getValue());
            String jpaPlatformId = jpaPlatform == null ? "" : jpaPlatform.getId();
            lid.setEnablementContextVariable("jpaPlatform", (Object)jpaPlatformId);
            lid.setEnablementContextVariable("jpaPlatformDescription", (Object)jpaPlatform);
            ArrayList<JpaLibraryProviderInstallOperationConfig> jpaConfigs = new ArrayList<JpaLibraryProviderInstallOperationConfig>();
            JpaLibraryProviderInstallOperationConfig currentJpaConfig = null;
            LibraryProviderOperationConfig config = lid.getLibraryProviderOperationConfig();
            if (config instanceof JpaLibraryProviderInstallOperationConfig) {
                currentJpaConfig = (JpaLibraryProviderInstallOperationConfig)config;
                jpaConfigs.add(currentJpaConfig);
            }
            for (ILibraryProvider lp : lid.getLibraryProviders()) {
                config = lid.getLibraryProviderOperationConfig(lp);
                if (!(config instanceof JpaLibraryProviderInstallOperationConfig) || config.equals(currentJpaConfig)) continue;
                jpaConfigs.add((JpaLibraryProviderInstallOperationConfig)config);
            }
            for (JpaLibraryProviderInstallOperationConfig jpaConfig : jpaConfigs) {
                jpaConfig.setJpaPlatform(jpaPlatform);
            }
        }
    }

    protected void createWidgets(Composite parent) {
        this.buildPlatformGroup(parent);
        Control libraryProviderComposite = LibraryProviderFrameworkUi.createInstallLibraryPanel((Composite)parent, (LibraryInstallDelegate)this.getLibraryInstallDelegate(), (String)JptUiMessages.JpaFacetWizardPage_jpaImplementationLabel);
        libraryProviderComposite.setLayoutData((Object)new GridData(768));
        this.buildConnectionGroup(parent);
        this.buildPersistentClassManagementGroup(parent);
        this.buildMetamodelGroup(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jpt.jpa.ui.properties_javaPersistence");
    }

    protected void engageListeners() {
        super.engageListeners();
        this.platformIdModel.addPropertyChangeListener("value", this.platformIdListener);
        this.disconnectedModel.addPropertyChangeListener("value", this.disconnectedModelListener);
    }

    protected void disengageListeners() {
        this.platformIdModel.removePropertyChangeListener("value", this.platformIdListener);
        this.disconnectedModel.removePropertyChangeListener("value", this.disconnectedModelListener);
        super.disengageListeners();
    }

    private void buildPlatformGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(JptUiMessages.JpaFacetWizardPage_platformLabel);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        Combo platformDropDown = this.buildDropDown((Composite)group);
        SWTTools.bind(this.buildPlatformChoicesModel(), this.platformIdModel, (Combo)platformDropDown, JPA_PLATFORM_LABEL_CONVERTER);
        this.buildFacetsPageLink((Composite)group, JptUiMessages.JpaFacetWizardPage_facetsPageLink);
    }

    private ListValueModel<String> buildPlatformChoicesModel() {
        return new SortedListValueModelAdapter((CollectionValueModel)new SetCollectionValueModel((CollectionValueModel)new CompositeCollectionValueModel((Object[])new CollectionValueModel[]{new PropertyCollectionValueModelAdapter(this.platformIdModel), this.buildRegistryPlatformsModel()})), JPA_PLATFORM_COMPARATOR);
    }

    private CollectionValueModel<String> buildRegistryPlatformsModel() {
        TransformationIterable<JpaPlatformDescription, String> enabledPlatformIds = new TransformationIterable<JpaPlatformDescription, String>((Iterable)new FilteringIterable<JpaPlatformDescription>(JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatforms()){

            protected boolean accept(JpaPlatformDescription o) {
                return o.supportsJpaFacetVersion(JpaProjectPropertiesPage.this.getProjectFacetVersion());
            }
        }){

            protected String transform(JpaPlatformDescription o) {
                return o.getId();
            }
        };
        return new StaticCollectionValueModel((Iterable)enabledPlatformIds);
    }

    static String getJpaPlatformLabel(String id) {
        return JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatform(id).getLabel();
    }

    private void buildConnectionGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(JptUiMessages.JpaFacetWizardPage_connectionLabel);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.jpa.ui.properties_javaPersistenceConnection");
        Combo connectionDropDown = this.buildDropDown((Composite)group, 3);
        SWTTools.bind(CONNECTION_CHOICES_MODEL, this.connectionModel, (Combo)connectionDropDown, SIMPLE_STRING_CONVERTER);
        Link addConnectionLink = this.buildLink((Composite)group, JptUiMessages.JpaFacetWizardPage_connectionLink);
        addConnectionLink.addSelectionListener(this.buildAddConnectionLinkListener());
        this.connectLink = this.buildLink((Composite)group, this.buildConnectLinkText());
        SWTTools.controlEnabledState(this.disconnectedModel, (Control[])new Control[]{this.connectLink});
        this.connectLink.addSelectionListener(this.buildConnectLinkListener());
        Button overrideDefaultCatalogCheckBox = this.buildCheckBox((Composite)group, 3, JptUiMessages.JpaFacetWizardPage_overrideDefaultCatalogLabel);
        SWTTools.bind(this.userOverrideDefaultCatalogFlagModel, (Button)overrideDefaultCatalogCheckBox);
        Label defaultCatalogLabel = this.buildLabel((Composite)group, JptUiMessages.JpaFacetWizardPage_defaultCatalogLabel);
        Combo defaultCatalogDropDown = this.buildDropDown((Composite)group);
        SWTTools.bind(this.catalogChoicesModel, this.defaultCatalogModel, (Combo)defaultCatalogDropDown);
        SWTTools.controlEnabledState(this.userOverrideDefaultCatalogFlagModel, (Control[])new Control[]{defaultCatalogLabel, defaultCatalogDropDown});
        Button overrideDefaultSchemaButton = this.buildCheckBox((Composite)group, 3, JptUiMessages.JpaFacetWizardPage_overrideDefaultSchemaLabel);
        SWTTools.bind(this.userOverrideDefaultSchemaFlagModel, (Button)overrideDefaultSchemaButton);
        Label defaultSchemaLabel = this.buildLabel((Composite)group, JptUiMessages.JpaFacetWizardPage_defaultSchemaLabel);
        Combo defaultSchemaDropDown = this.buildDropDown((Composite)group);
        SWTTools.bind(this.schemaChoicesModel, this.defaultSchemaModel, (Combo)defaultSchemaDropDown);
        SWTTools.controlEnabledState(this.userOverrideDefaultSchemaFlagModel, (Control[])new Control[]{defaultSchemaLabel, defaultSchemaDropDown});
    }

    private PropertyChangeListener buildDisconnectedModelListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildDisconnectedModelListener_());
    }

    private PropertyChangeListener buildDisconnectedModelListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                JpaProjectPropertiesPage.this.updateConnectLinkText(JpaProjectPropertiesPage.this.buildConnectLinkText());
            }
        };
    }

    private String buildConnectLinkText() {
        ConnectionProfile connectionProfile = this.getConnectionProfile();
        if (connectionProfile != null && connectionProfile.isConnected()) {
            return JptUiMessages.JpaFacetWizardPage_connectedText;
        }
        return JptUiMessages.JpaFacetWizardPage_connectLink;
    }

    private void updateConnectLinkText(String text) {
        this.connectLink.setText(text);
        SWTUtil.reflow((Composite)this.connectLink.getParent());
    }

    private SelectionListener buildAddConnectionLinkListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JpaProjectPropertiesPage.this.openNewConnectionWizard();
            }

            public String toString() {
                return "connection link listener";
            }
        };
    }

    void openNewConnectionWizard() {
        String connectionName = DTPUiTools.createNewConnectionProfile();
        if (connectionName != null) {
            this.connectionModel.setValue((Object)connectionName);
        }
    }

    private SelectionListener buildConnectLinkListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JpaProjectPropertiesPage.this.openConnectionProfile();
            }

            public String toString() {
                return "connect link listener";
            }
        };
    }

    void openConnectionProfile() {
        ConnectionProfile cp = this.getConnectionProfile();
        if (cp != null) {
            cp.connect();
        }
    }

    private void buildPersistentClassManagementGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(JptUiMessages.JpaFacetWizardPage_persistentClassManagementLabel);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        Button discoverClassesRadioButton = this.buildRadioButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_discoverClassesButton);
        SWTTools.bind(this.discoverAnnotatedClassesModel, (Button)discoverClassesRadioButton);
        Button listClassesRadioButton = this.buildRadioButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_listClassesButton);
        SWTTools.bind(this.listAnnotatedClassesModel, (Button)listClassesRadioButton);
    }

    private void buildMetamodelGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(JptUiMessages.JpaFacetWizardPage_metamodelLabel);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        Link metamodelSourceFolderLink = this.buildLink((Composite)group, JptUiMessages.JpaFacetWizardPage_metamodelSourceFolderLink);
        metamodelSourceFolderLink.addSelectionListener(this.buildMetamodelSourceFolderLinkListener());
        Combo metamodelSourceFolderDropDown = this.buildDropDown((Composite)group);
        SWTTools.bind(this.javaSourceFolderChoicesModel, this.metamodelSourceFolderModel, (Combo)metamodelSourceFolderDropDown, SIMPLE_STRING_CONVERTER);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.jpa.ui.properties_canonicalMetamodel");
        SWTTools.controlVisibleState(this.jpa2_0ProjectFlagModel, (Control[])new Control[]{group, metamodelSourceFolderLink, metamodelSourceFolderDropDown});
    }

    private SelectionListener buildMetamodelSourceFolderLinkListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JpaProjectPropertiesPage.this.openJavaBuildPathPage();
            }

            public String toString() {
                return "metamodel source folder link listener";
            }
        };
    }

    void openJavaBuildPathPage() {
        IWorkbenchPreferenceContainer container = this.getWorkbenchPreferenceContainer();
        container.openPage(BUILD_PATHS_PROPERTY_PAGE_ID, null);
    }

    protected boolean projectRebuildRequired() {
        return this.platformIdModel.isBuffering();
    }

    protected void rebuildProject() {
        JptJpaCorePlugin.rebuildJpaProject((IProject)this.getProject());
    }

    protected BufferedWritablePropertyValueModel<?>[] buildBufferedModels() {
        return new BufferedWritablePropertyValueModel[]{this.platformIdModel, this.connectionModel, this.userOverrideDefaultCatalogFlagModel, this.userOverrideDefaultCatalogModel, this.userOverrideDefaultSchemaFlagModel, this.userOverrideDefaultSchemaModel, this.discoverAnnotatedClassesModel, this.metamodelSourceFolderModel};
    }

    protected Model[] buildValidationModels() {
        return new Model[]{this.platformIdModel, this.connectionModel, this.userOverrideDefaultCatalogFlagModel, this.defaultCatalogModel, this.userOverrideDefaultSchemaFlagModel, this.defaultSchemaModel, this.discoverAnnotatedClassesModel};
    }

    protected void performValidation(Map<Integer, ArrayList<IStatus>> statuses) {
        IStatus lpStatus = this.validateLibraryProvider();
        if (lpStatus != null) {
            statuses.get(lpStatus.getSeverity()).add(lpStatus);
        }
        super.performValidation(statuses);
        ConnectionProfile connectionProfile = this.getConnectionProfile();
        String connectionName = this.getConnectionName();
        if (!StringTools.stringIsEmpty((String)connectionName)) {
            if (connectionProfile == null) {
                statuses.get(ERROR_STATUS).add(this.buildErrorStatus(NLS.bind((String)JptCoreMessages.VALIDATE_CONNECTION_INVALID, (Object)connectionName)));
            } else if (!connectionProfile.isActive()) {
                statuses.get(INFO_STATUS).add(this.buildInfoStatus(JptCoreMessages.VALIDATE_CONNECTION_NOT_CONNECTED));
            }
        }
        if (this.userOverrideDefaultCatalogFlagIsSet()) {
            String defaultCatalog = this.getUserOverrideDefaultCatalog();
            if (StringTools.stringIsEmpty((String)defaultCatalog)) {
                statuses.get(ERROR_STATUS).add(this.buildErrorStatus(JptCoreMessages.VALIDATE_DEFAULT_CATALOG_NOT_SPECIFIED));
            } else if (connectionProfile != null && connectionProfile.isConnected() && !CollectionTools.contains((Iterator)this.catalogChoicesModel.iterator(), (Object)defaultCatalog)) {
                statuses.get(WARNING_STATUS).add(this.buildWarningStatus(NLS.bind((String)JptCoreMessages.VALIDATE_CONNECTION_DOESNT_CONTAIN_CATALOG, (Object)defaultCatalog)));
            }
        }
        if (this.userOverrideDefaultSchemaFlagIsSet()) {
            String defaultSchema = this.getUserOverrideDefaultSchema();
            if (StringTools.stringIsEmpty((String)defaultSchema)) {
                statuses.get(ERROR_STATUS).add(this.buildErrorStatus(JptCoreMessages.VALIDATE_DEFAULT_SCHEMA_NOT_SPECIFIED));
            } else if (connectionProfile != null && connectionProfile.isConnected() && !CollectionTools.contains((Iterator)this.schemaChoicesModel.iterator(), (Object)defaultSchema)) {
                statuses.get(WARNING_STATUS).add(this.buildWarningStatus(NLS.bind((String)JptCoreMessages.VALIDATE_CONNECTION_DOESNT_CONTAIN_SCHEMA, (Object)defaultSchema)));
            }
        }
    }

    private IStatus validateLibraryProvider() {
        LibraryInstallDelegate libInstallDelegate = this.getLibraryInstallDelegate();
        if (libInstallDelegate != null) {
            HashMap<String, Object> enablementVariables = new HashMap<String, Object>();
            enablementVariables.put("jpaPlatform", this.platformIdModel.getValue());
            enablementVariables.put("jpaPlatformDescription", ((JpaProject)this.jpaProjectModel.getValue()).getJpaPlatform().getDescription());
            if (!libInstallDelegate.getLibraryProvider().isEnabledFor((IFacetedProjectBase)this.getFacetedProject(), this.getProjectFacetVersion(), enablementVariables)) {
                return this.buildErrorStatus(JptCoreMessages.VALIDATE_LIBRARY_PROVIDER_INVALID);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConnectionChoicesModel
    extends AbstractCollectionValueModel
    implements CollectionValueModel<String> {
        private final ConnectionProfileListener connectionProfileListener = this.buildConnectionProfileListener();

        ConnectionChoicesModel() {
        }

        private ConnectionProfileListener buildConnectionProfileListener() {
            return new ConnectionProfileListener(){

                public void connectionProfileAdded(String name) {
                    ConnectionChoicesModel.this.collectionChanged();
                }

                public void connectionProfileRemoved(String name) {
                    ConnectionChoicesModel.this.collectionChanged();
                }

                public void connectionProfileRenamed(String oldName, String newName) {
                }
            };
        }

        void collectionChanged() {
            this.fireCollectionChanged("values", (Collection)CollectionTools.collection(this.iterator()));
        }

        public Iterator<String> iterator() {
            return this.getConnectionProfileFactory().getConnectionProfileNames().iterator();
        }

        public int size() {
            return CollectionTools.size(this.iterator());
        }

        protected void engageModel() {
            this.getConnectionProfileFactory().addConnectionProfileListener(this.connectionProfileListener);
        }

        protected void disengageModel() {
            this.getConnectionProfileFactory().removeConnectionProfileListener(this.connectionProfileListener);
        }

        private ConnectionProfileFactory getConnectionProfileFactory() {
            return JptJpaDbPlugin.getConnectionProfileFactory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConnectionModel
    extends PropertyAspectAdapter<JpaDataSource, String> {
        ConnectionModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super((PropertyValueModel)new DataSourceModel(jpaProjectModel), new String[]{"connectionProfileName"});
        }

        protected String buildValue_() {
            return ((JpaDataSource)this.subject).getConnectionProfileName();
        }

        public void setValue_(String connection) {
            ((JpaDataSource)this.subject).setConnectionProfileName(connection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ConnectionProfileCollectionAspectAdapter<E>
    extends AspectCollectionValueModelAdapter<ConnectionProfile, E> {
        private final ConnectionListener connectionListener = this.buildConnectionListener();

        ConnectionProfileCollectionAspectAdapter(PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
        }

        private ConnectionListener buildConnectionListener() {
            return new ConnectionAdapter(){

                public void opened(ConnectionProfile profile) {
                    ConnectionProfileCollectionAspectAdapter.this.connectionOpened(profile);
                }
            };
        }

        void connectionOpened(ConnectionProfile profile) {
            if (profile.equals(this.subject)) {
                this.collectionChanged();
            }
        }

        protected void engageSubject_() {
            ((ConnectionProfile)this.subject).addConnectionListener(this.connectionListener);
        }

        protected void disengageSubject_() {
            ((ConnectionProfile)this.subject).removeConnectionListener(this.connectionListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConnectionProfileModel
    extends CachingTransformationPropertyValueModel<String, ConnectionProfile> {
        ConnectionProfileModel(PropertyValueModel<String> connectionModel) {
            super(connectionModel);
        }

        protected ConnectionProfile transform_(String connectionName) {
            return JptJpaDbPlugin.getConnectionProfileFactory().buildConnectionProfile(connectionName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ConnectionProfilePropertyAspectAdapter<V>
    extends AspectPropertyValueModelAdapter<ConnectionProfile, V> {
        private final ConnectionListener connectionListener = this.buildConnectionListener();

        ConnectionProfilePropertyAspectAdapter(PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
        }

        private ConnectionListener buildConnectionListener() {
            return new ConnectionAdapter(){

                public void opened(ConnectionProfile profile) {
                    ConnectionProfilePropertyAspectAdapter.this.connectionOpened(profile);
                }
            };
        }

        void connectionOpened(ConnectionProfile profile) {
            if (profile.equals(this.subject)) {
                this.propertyChanged();
            }
        }

        protected void engageSubject_() {
            ((ConnectionProfile)this.subject).addConnectionListener(this.connectionListener);
        }

        protected void disengageSubject_() {
            ((ConnectionProfile)this.subject).removeConnectionListener(this.connectionListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DataSourceModel
    extends TransformationPropertyValueModel<JpaProject, JpaDataSource> {
        DataSourceModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel);
        }

        protected JpaDataSource transform_(JpaProject value) {
            return value.getDataSource();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DatabaseCatalogChoicesModel
    extends ConnectionProfileCollectionAspectAdapter<String> {
        DatabaseCatalogChoicesModel(PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
        }

        protected Iterable<String> getIterable() {
            Database db = ((ConnectionProfile)this.subject).getDatabase();
            return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DatabaseDefaultCatalogModel
    extends ConnectionProfilePropertyAspectAdapter<String> {
        DatabaseDefaultCatalogModel(PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
        }

        protected String buildValue_() {
            Database db = ((ConnectionProfile)this.subject).getDatabase();
            return db == null ? null : db.getDefaultCatalogIdentifier();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DatabaseDefaultSchemaModel
    extends ConnectionProfilePropertyAspectAdapter<String> {
        private final PropertyValueModel<String> defaultCatalogModel;
        private final PropertyChangeListener catalogListener;

        DatabaseDefaultSchemaModel(PropertyValueModel<ConnectionProfile> connectionProfileModel, PropertyValueModel<String> defaultCatalogModel) {
            super(connectionProfileModel);
            this.defaultCatalogModel = defaultCatalogModel;
            this.catalogListener = this.buildCatalogListener();
        }

        private PropertyChangeListener buildCatalogListener() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    DatabaseDefaultSchemaModel.this.catalogChanged();
                }
            };
        }

        void catalogChanged() {
            this.propertyChanged();
        }

        @Override
        protected void engageSubject_() {
            super.engageSubject_();
            this.defaultCatalogModel.addPropertyChangeListener("value", this.catalogListener);
        }

        @Override
        protected void disengageSubject_() {
            this.defaultCatalogModel.removePropertyChangeListener("value", this.catalogListener);
            super.disengageSubject_();
        }

        protected String buildValue_() {
            SchemaContainer sc = this.getSchemaContainer();
            return sc == null ? null : sc.getDefaultSchemaIdentifier();
        }

        private SchemaContainer getSchemaContainer() {
            return this.databaseSupportsCatalogs() ? this.getCatalog() : this.getDatabase();
        }

        private boolean databaseSupportsCatalogs() {
            Database db = this.getDatabase();
            return db != null && db.supportsCatalogs();
        }

        private Catalog getCatalog() {
            String name = (String)this.defaultCatalogModel.getValue();
            return name == null ? null : this.getDatabase().getCatalogForIdentifier(name);
        }

        private Database getDatabase() {
            return ((ConnectionProfile)this.subject).getDatabase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DatabaseSchemaChoicesModel
    extends ConnectionProfileCollectionAspectAdapter<String> {
        private final PropertyValueModel<String> defaultCatalogModel;
        private final PropertyChangeListener catalogListener;

        DatabaseSchemaChoicesModel(PropertyValueModel<ConnectionProfile> connectionProfileModel, PropertyValueModel<String> defaultCatalogModel) {
            super(connectionProfileModel);
            this.defaultCatalogModel = defaultCatalogModel;
            this.catalogListener = this.buildCatalogListener();
        }

        private PropertyChangeListener buildCatalogListener() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    DatabaseSchemaChoicesModel.this.catalogChanged();
                }
            };
        }

        void catalogChanged() {
            this.collectionChanged();
        }

        @Override
        protected void engageSubject_() {
            super.engageSubject_();
            this.defaultCatalogModel.addPropertyChangeListener("value", this.catalogListener);
        }

        @Override
        protected void disengageSubject_() {
            this.defaultCatalogModel.removePropertyChangeListener("value", this.catalogListener);
            super.disengageSubject_();
        }

        protected Iterable<String> getIterable() {
            SchemaContainer sc = this.getSchemaContainer();
            return sc != null ? sc.getSortedSchemaIdentifiers() : EmptyIterable.instance();
        }

        private SchemaContainer getSchemaContainer() {
            return this.databaseSupportsCatalogs() ? this.getCatalog() : this.getDatabase();
        }

        private boolean databaseSupportsCatalogs() {
            Database db = this.getDatabase();
            return db != null && db.supportsCatalogs();
        }

        private Catalog getCatalog() {
            String name = (String)this.defaultCatalogModel.getValue();
            return name == null ? null : this.getDatabase().getCatalogForIdentifier(name);
        }

        private Database getDatabase() {
            return ((ConnectionProfile)this.subject).getDatabase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultModel
    extends CompositePropertyValueModel<String>
    implements WritablePropertyValueModel<String> {
        private final PropertyValueModel<Boolean> userOverrideDefaultFlagModel;
        private final WritablePropertyValueModel<String> userOverrideDefaultModel;
        private final PropertyValueModel<String> databaseDefaultModel;

        DefaultModel(PropertyValueModel<Boolean> userOverrideDefaultFlagModel, WritablePropertyValueModel<String> userOverrideDefaultModel, PropertyValueModel<String> databaseDefaultModel) {
            super(new PropertyValueModel[]{userOverrideDefaultFlagModel, userOverrideDefaultModel, databaseDefaultModel});
            this.userOverrideDefaultFlagModel = userOverrideDefaultFlagModel;
            this.userOverrideDefaultModel = userOverrideDefaultModel;
            this.databaseDefaultModel = databaseDefaultModel;
        }

        protected void propertyChanged(PropertyChangeEvent event) {
            super.propertyChanged(event);
            if (event.getSource() == this.userOverrideDefaultFlagModel && !this.userOverrideDefaultFlagIsSet()) {
                this.userOverrideDefaultModel.setValue(null);
            }
        }

        protected String buildValue() {
            return this.userOverrideDefaultFlagIsSet() ? (String)this.userOverrideDefaultModel.getValue() : (String)this.databaseDefaultModel.getValue();
        }

        public void setValue(String value) {
            this.userOverrideDefaultModel.setValue((Object)value);
            this.propertyChanged();
        }

        private boolean userOverrideDefaultFlagIsSet() {
            return JpaProjectPropertiesPage.flagIsSet((PropertyValueModel)this.userOverrideDefaultFlagModel);
        }

        public void toString(StringBuilder sb) {
            sb.append((String)this.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DisconnectedModel
    extends ConnectionProfilePropertyAspectAdapter<Boolean> {
        DisconnectedModel(PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
        }

        protected Boolean buildValue_() {
            return this.subject != null && ((ConnectionProfile)this.subject).isDisconnected();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverAnnotatedClassesModel
    extends PropertyAspectAdapter<JpaProject, Boolean> {
        DiscoverAnnotatedClassesModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, new String[]{"discoversAnnotatedClasses"});
        }

        protected Boolean buildValue_() {
            return ((JpaProject)this.subject).discoversAnnotatedClasses();
        }

        protected void setValue_(Boolean value) {
            ((JpaProject)this.subject).setDiscoversAnnotatedClasses(value.booleanValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JavaSourceFolderChoicesModel
    extends AspectCollectionValueModelAdapter<JpaProject, String> {
        private final IElementChangedListener javaElementChangedListener = this.buildJavaElementChangedListener();

        JavaSourceFolderChoicesModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel);
        }

        private IElementChangedListener buildJavaElementChangedListener() {
            return new IElementChangedListener(){

                public void elementChanged(ElementChangedEvent event) {
                    JavaSourceFolderChoicesModel.this.processJavaDelta(event.getDelta());
                }
            };
        }

        void processJavaDelta(IJavaElementDelta delta) {
            switch (delta.getElement().getElementType()) {
                case 1: {
                    this.processJavaDeltaChildren(delta);
                    break;
                }
                case 2: {
                    this.processJavaProjectDelta(delta);
                    break;
                }
            }
        }

        private void processJavaDeltaChildren(IJavaElementDelta delta) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                this.processJavaDelta(child);
                ++n2;
            }
        }

        private void processJavaProjectDelta(IJavaElementDelta delta) {
            IJavaProject javaProject = (IJavaProject)delta.getElement();
            if (javaProject.equals(((JpaProject)this.subject).getJavaProject()) && this.classpathHasChanged(delta)) {
                this.fireCollectionChanged("values", (Collection)CollectionTools.collection((Iterator)this.iterator()));
            }
        }

        private boolean classpathHasChanged(IJavaElementDelta delta) {
            return this.deltaFlagIsSet(delta, 0x200000);
        }

        private boolean deltaFlagIsSet(IJavaElementDelta delta, int flag) {
            return delta.getKind() == 4 && BitTools.flagIsSet((int)delta.getFlags(), (int)flag);
        }

        protected Iterable<String> getIterable() {
            return this.jpaProjectIsJpa2_0() ? ((JpaProject2_0)this.subject).getJavaSourceFolderNames() : EmptyIterable.instance();
        }

        private boolean jpaProjectIsJpa2_0() {
            return JptJpaCorePlugin.nodeIsJpa2_0Compatible((JpaNode)((JpaNode)this.subject));
        }

        protected void engageSubject_() {
            JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangedListener);
        }

        protected void disengageSubject_() {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangedListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaProjectModel
    extends AspectPropertyValueModelAdapter<IProject, JpaProject> {
        private final CollectionChangeListener projectManagerListener = this.buildProjectManagerListener();

        JpaProjectModel(PropertyValueModel<IProject> projectModel) {
            super(projectModel);
        }

        private CollectionChangeListener buildProjectManagerListener() {
            return new CollectionChangeAdapter(){

                public void itemsAdded(CollectionAddEvent event) {
                    JpaProjectModel.this.platformChanged();
                }
            };
        }

        void platformChanged() {
            this.propertyChanged();
        }

        protected void engageSubject_() {
            JptJpaCorePlugin.getJpaProjectManager().addCollectionChangeListener("jpaProjects", this.projectManagerListener);
        }

        protected void disengageSubject_() {
            JptJpaCorePlugin.getJpaProjectManager().removeCollectionChangeListener("jpaProjects", this.projectManagerListener);
        }

        protected JpaProject buildValue_() {
            return JptJpaCorePlugin.getJpaProject((IProject)((IProject)this.subject));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MetamodelSourceFolderModel
    extends PropertyAspectAdapter<JpaProject, String> {
        MetamodelSourceFolderModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, new String[]{"metamodelSourceFolderName"});
        }

        protected String buildValue_() {
            return this.jpaProjectIsJpa2_0() ? ((JpaProject2_0)this.subject).getMetamodelSourceFolderName() : null;
        }

        protected void setValue_(String value) {
            if (this.jpaProjectIsJpa2_0()) {
                ((JpaProject2_0)this.subject).setMetamodelSourceFolderName(value);
            }
        }

        private boolean jpaProjectIsJpa2_0() {
            return JptJpaCorePlugin.nodeIsJpa2_0Compatible((JpaNode)((JpaNode)this.subject));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PlatformIdModel
    extends AspectPropertyValueModelAdapter<JpaProject, String> {
        PlatformIdModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel);
        }

        protected String buildValue_() {
            return JptJpaCorePlugin.getJpaPlatformId((IProject)((JpaProject)this.subject).getProject());
        }

        public void setValue_(String newPlatformId) {
            JptJpaCorePlugin.setJpaPlatformId((IProject)((JpaProject)this.subject).getProject(), (String)newPlatformId);
        }

        protected void engageSubject_() {
        }

        protected void disengageSubject_() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UserOverrideDefaultCatalogFlagModel
    extends UserOverrideDefaultFlagModel {
        UserOverrideDefaultCatalogFlagModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, "userOverrideDefaultCatalog");
        }

        @Override
        public String getUserOverrideDefault() {
            return ((JpaProject)this.subject).getUserOverrideDefaultCatalog();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UserOverrideDefaultCatalogModel
    extends PropertyAspectAdapter<JpaProject, String> {
        UserOverrideDefaultCatalogModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, new String[]{"userOverrideDefaultCatalog"});
        }

        protected String buildValue_() {
            return ((JpaProject)this.subject).getUserOverrideDefaultCatalog();
        }

        public void setValue_(String catalog) {
            ((JpaProject)this.subject).setUserOverrideDefaultCatalog(catalog);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class UserOverrideDefaultFlagModel
    extends PropertyAspectAdapter<JpaProject, Boolean> {
        UserOverrideDefaultFlagModel(PropertyValueModel<JpaProject> jpaProjectModel, String propertyName) {
            super(jpaProjectModel, new String[]{propertyName});
        }

        protected Boolean buildValue_() {
            return this.specifiesUserOverrideDefault();
        }

        boolean specifiesUserOverrideDefault() {
            return !StringTools.stringIsEmpty((String)this.getUserOverrideDefault());
        }

        abstract String getUserOverrideDefault();

        protected void setValue_(Boolean value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UserOverrideDefaultSchemaFlagModel
    extends UserOverrideDefaultFlagModel {
        UserOverrideDefaultSchemaFlagModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, "userOverrideDefaultSchema");
        }

        @Override
        public String getUserOverrideDefault() {
            return ((JpaProject)this.subject).getUserOverrideDefaultSchema();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UserOverrideDefaultSchemaModel
    extends PropertyAspectAdapter<JpaProject, String> {
        UserOverrideDefaultSchemaModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, new String[]{"userOverrideDefaultSchema"});
        }

        protected String buildValue_() {
            return ((JpaProject)this.subject).getUserOverrideDefaultSchema();
        }

        public void setValue_(String schema) {
            ((JpaProject)this.subject).setUserOverrideDefaultSchema(schema);
        }
    }
}

