/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.ReadOnlyObjectReference;
import org.eclipse.jpt.common.utility.internal.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyReadOnlyObjectReference<V>
implements ReadOnlyObjectReference<V>,
Cloneable,
Serializable {
    private volatile V value = null;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getValue() {
        V result = this.value;
        if (result == null) {
            LazyReadOnlyObjectReference lazyReadOnlyObjectReference = this;
            synchronized (lazyReadOnlyObjectReference) {
                result = this.value;
                if (result == null) {
                    this.value = result = this.buildValue();
                }
            }
        }
        return result;
    }

    protected abstract V buildValue();

    @Override
    public boolean valueEquals(Object object) {
        return Tools.valuesAreEqual(this.getValue(), object);
    }

    @Override
    public boolean valueNotEqual(Object object) {
        return Tools.valuesAreDifferent(this.getValue(), object);
    }

    @Override
    public boolean isNull() {
        return this.getValue() == null;
    }

    @Override
    public boolean isNotNull() {
        return this.getValue() != null;
    }

    public LazyReadOnlyObjectReference<V> clone() {
        try {
            LazyReadOnlyObjectReference clone = (LazyReadOnlyObjectReference)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.value) + ']';
    }
}

