/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.ConverterTextRangeResolver;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkConvertValidator
implements JptValidator {
    protected final EclipseLinkConvert convert;
    protected final ConverterTextRangeResolver textRangeResolver;

    public EclipseLinkConvertValidator(EclipseLinkConvert convert, ConverterTextRangeResolver textRangeResolver) {
        this.convert = convert;
        this.textRangeResolver = textRangeResolver;
    }

    protected AttributeMapping getAttributeMapping() {
        return this.convert.getParent();
    }

    protected EclipseLinkPersistenceUnit getPersistenceUnit() {
        return this.convert.getPersistenceUnit();
    }

    public boolean validate(List<IMessage> messages, IReporter reporter) {
        return this.validateConverterName(messages);
    }

    private boolean validateConverterName(List<IMessage> messages) {
        String converterName = this.convert.getConverterName();
        if (converterName == null) {
            return true;
        }
        if (CollectionTools.contains(this.getPersistenceUnit().getUniqueConverterNames(), (Object)converterName)) {
            return true;
        }
        if (ArrayTools.contains((Object[])EclipseLinkConvert.RESERVED_CONVERTER_NAMES, (Object)converterName)) {
            return true;
        }
        messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "ID_MAPPING_UNRESOLVED_CONVERTER_NAME", new String[]{converterName, this.getAttributeMapping().getName()}, this.getAttributeMapping(), this.textRangeResolver.getConverterTextRange()));
        return false;
    }
}

