/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.Association;
import org.eclipse.jpt.common.utility.internal.SimpleAssociation;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaConverter;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.ConverterTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.AbstractJavaConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.EclipseLinkConvertValidator;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConvertAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkNamedConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkConvert
extends AbstractJavaConverter
implements EclipseLinkConvert {
    private final EclipseLinkConvertAnnotation convertAnnotation;
    private String specifiedConverterName;
    private String defaultConverterName;
    private JavaEclipseLinkConverter<?> converter;
    protected static final JavaEclipseLinkConverter.Adapter[] CONVERTER_ADAPTER_ARRAY = new JavaEclipseLinkConverter.Adapter[]{JavaEclipseLinkCustomConverter.Adapter.instance(), JavaEclipseLinkTypeConverter.Adapter.instance(), JavaEclipseLinkObjectTypeConverter.Adapter.instance(), JavaEclipseLinkStructConverter.Adapter.instance()};
    protected static final Iterable<JavaEclipseLinkConverter.Adapter> CONVERTER_ADAPTERS = new ArrayIterable((Object[])CONVERTER_ADAPTER_ARRAY);

    public JavaEclipseLinkConvert(JavaAttributeMapping parent, EclipseLinkConvertAnnotation convertAnnotation, Converter.Owner owner) {
        super(parent, owner);
        this.convertAnnotation = convertAnnotation;
        this.specifiedConverterName = convertAnnotation.getValue();
        this.converter = this.buildConverter();
    }

    public EclipseLinkConvertAnnotation getConverterAnnotation() {
        return this.convertAnnotation;
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedConverterName_(this.convertAnnotation.getValue());
        this.syncConverter();
    }

    public void update() {
        super.update();
        this.setDefaultConverterName(this.buildDefaultConverterName());
        if (this.converter != null) {
            this.converter.update();
        }
    }

    @Override
    public String getConverterName() {
        return this.specifiedConverterName != null ? this.specifiedConverterName : this.defaultConverterName;
    }

    @Override
    public String getSpecifiedConverterName() {
        return this.specifiedConverterName;
    }

    @Override
    public void setSpecifiedConverterName(String name) {
        this.convertAnnotation.setValue(name);
        this.setSpecifiedConverterName_(name);
    }

    protected void setSpecifiedConverterName_(String name) {
        String old = this.specifiedConverterName;
        this.specifiedConverterName = name;
        this.firePropertyChanged("specifiedConverterName", old, name);
    }

    @Override
    public String getDefaultConverterName() {
        return this.defaultConverterName;
    }

    protected void setDefaultConverterName(String name) {
        String old = this.defaultConverterName;
        this.defaultConverterName = name;
        this.firePropertyChanged("defaultConverterName", old, name);
    }

    protected String buildDefaultConverterName() {
        return "none";
    }

    @Override
    public JavaEclipseLinkConverter<?> getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(Class<? extends EclipseLinkConverter> converterType) {
        if (converterType == null) {
            if (this.converter != null) {
                this.setConverter_(null);
                this.retainConverterAnnotation(null);
            }
        } else if (this.converter == null || this.converter.getType() != converterType) {
            JavaEclipseLinkConverter.Adapter converterAdapter = this.getConverterAdapter(converterType);
            this.retainConverterAnnotation(converterAdapter);
            this.setConverter_(converterAdapter.buildNewConverter((JavaResourceMember)this.getResourceAttribute(), (JavaJpaContextNode)this));
        }
    }

    protected void setConverter_(JavaEclipseLinkConverter<?> converter) {
        JavaEclipseLinkConverter<?> old = this.converter;
        this.converter = converter;
        this.firePropertyChanged("converter", old, converter);
    }

    protected JavaEclipseLinkConverter<?> buildConverter() {
        return this.isVirtual() ? null : this.buildConverter_();
    }

    protected JavaEclipseLinkConverter<?> buildConverter_() {
        JavaResourceAttribute resourceAttribute = this.getResourceAttribute();
        for (JavaEclipseLinkConverter.Adapter adapter : this.getConverterAdapters()) {
            JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> javaConverter = adapter.buildConverter((JavaResourceMember)resourceAttribute, (JavaJpaContextNode)this);
            if (javaConverter == null) continue;
            return javaConverter;
        }
        return null;
    }

    protected void retainConverterAnnotation(JavaEclipseLinkConverter.Adapter converterAdapter) {
        JavaResourceAttribute resourceAttribute = this.getResourceAttribute();
        for (JavaEclipseLinkConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter == converterAdapter) continue;
            adapter.removeConverterAnnotation((JavaResourceMember)resourceAttribute);
        }
    }

    protected void syncConverter() {
        if (!this.isVirtual()) {
            this.syncConverter_();
        }
    }

    protected void syncConverter_() {
        Association<JavaEclipseLinkConverter.Adapter, EclipseLinkNamedConverterAnnotation> assoc = this.getEclipseLinkConverterAnnotation();
        if (assoc == null) {
            if (this.converter != null) {
                this.setConverter_(null);
            }
        } else {
            JavaEclipseLinkConverter.Adapter adapter = (JavaEclipseLinkConverter.Adapter)assoc.getKey();
            EclipseLinkNamedConverterAnnotation annotation = (EclipseLinkNamedConverterAnnotation)assoc.getValue();
            if (this.converter != null && this.converter.getType() == adapter.getConverterType() && this.converter.getConverterAnnotation() == annotation) {
                this.converter.synchronizeWithResourceModel();
            } else {
                this.setConverter_(adapter.buildConverter(annotation, (JavaJpaContextNode)this));
            }
        }
    }

    protected Association<JavaEclipseLinkConverter.Adapter, EclipseLinkNamedConverterAnnotation> getEclipseLinkConverterAnnotation() {
        JavaResourceAttribute resourceAttribute = this.getResourceAttribute();
        for (JavaEclipseLinkConverter.Adapter adapter : this.getConverterAdapters()) {
            EclipseLinkNamedConverterAnnotation annotation = adapter.getConverterAnnotation((JavaResourceMember)resourceAttribute);
            if (annotation == null) continue;
            return new SimpleAssociation((Object)adapter, (Object)annotation);
        }
        return null;
    }

    protected JavaEclipseLinkConverter.Adapter getConverterAdapter(Class<? extends EclipseLinkConverter> converterType) {
        for (JavaEclipseLinkConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter.getConverterType() != converterType) continue;
            return adapter;
        }
        throw new IllegalArgumentException("unknown converter type: " + converterType.getName());
    }

    protected Iterable<JavaEclipseLinkConverter.Adapter> getConverterAdapters() {
        return CONVERTER_ADAPTERS;
    }

    public Class<? extends Converter> getType() {
        return EclipseLinkConvert.class;
    }

    protected boolean isVirtual() {
        return this.getAttributeMapping().getPersistentAttribute().isVirtual();
    }

    public void dispose() {
        super.dispose();
        this.setConverter(null);
    }

    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.convertValueTouches(pos, astRoot) && (result = this.getJavaCandidateConverterNames(filter)) != null) {
            return result;
        }
        return null;
    }

    protected boolean convertValueTouches(int pos, CompilationUnit astRoot) {
        return this.convertAnnotation.valueTouches(pos, astRoot);
    }

    protected Iterable<String> getJavaCandidateConverterNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateConverterNames(filter));
    }

    protected Iterable<String> getCandidateConverterNames(Filter<String> filter) {
        return new FilteringIterable(this.getConverterNames(), filter);
    }

    protected Iterable<String> getConverterNames() {
        return this.getPersistenceUnit().getUniqueConverterNames();
    }

    @Override
    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    extends JavaConverter.AbstractAdapter {
        private static final Adapter INSTANCE = new Adapter();

        public static Adapter instance() {
            return INSTANCE;
        }

        private Adapter() {
        }

        public Class<? extends Converter> getConverterType() {
            return EclipseLinkConvert.class;
        }

        protected String getAnnotationName() {
            return "org.eclipse.persistence.annotations.Convert";
        }

        public JavaConverter buildConverter(Annotation converterAnnotation, JavaAttributeMapping parent, JpaFactory factory) {
            return new JavaEclipseLinkConvert(parent, (EclipseLinkConvertAnnotation)converterAnnotation, this.buildOwner());
        }

        protected Converter.Owner buildOwner() {
            return new Converter.Owner(){

                public JptValidator buildValidator(Converter converter, ConverterTextRangeResolver textRangeResolver) {
                    return new EclipseLinkConvertValidator((EclipseLinkConvert)converter, textRangeResolver);
                }
            };
        }
    }
}

