/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkCustomizerAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkCustomizer
extends AbstractJavaJpaContextNode
implements EclipseLinkCustomizer {
    private String specifiedCustomizerClass = this.buildSpecifiedCustomizerClass();
    private String fullyQualifiedCustomizerClass;
    public static final String FULLY_QUALIFIED_CUSTOMIZER_CLASS_PROPERTY = "fullyQualifiedCustomizerClass";

    public JavaEclipseLinkCustomizer(EclipseLinkJavaTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedCustomizerClass_(this.buildSpecifiedCustomizerClass());
    }

    public void update() {
        super.update();
        this.setFullyQualifiedCustomizerClass(this.buildFullyQualifiedCustomizerClass());
    }

    @Override
    public String getCustomizerClass() {
        return this.specifiedCustomizerClass != null ? this.specifiedCustomizerClass : null;
    }

    @Override
    public String getSpecifiedCustomizerClass() {
        return this.specifiedCustomizerClass;
    }

    @Override
    public void setSpecifiedCustomizerClass(String customizerClass) {
        if (this.valuesAreDifferent(customizerClass, this.specifiedCustomizerClass)) {
            EclipseLinkCustomizerAnnotation annotation = this.getCustomizerAnnotation();
            if (customizerClass == null) {
                if (annotation != null) {
                    this.removeCustomizerAnnotation();
                }
            } else {
                if (annotation == null) {
                    annotation = this.addCustomizerAnnotation();
                }
                annotation.setValue(customizerClass);
            }
            this.setSpecifiedCustomizerClass_(customizerClass);
        }
    }

    protected void setSpecifiedCustomizerClass_(String customizerClass) {
        String old = this.specifiedCustomizerClass;
        this.specifiedCustomizerClass = customizerClass;
        this.firePropertyChanged("specifiedCustomizerClass", old, customizerClass);
    }

    protected String buildSpecifiedCustomizerClass() {
        EclipseLinkCustomizerAnnotation annotation = this.getCustomizerAnnotation();
        return annotation == null ? null : annotation.getValue();
    }

    @Override
    public String getDefaultCustomizerClass() {
        return null;
    }

    public String getFullyQualifiedCustomizerClass() {
        return this.fullyQualifiedCustomizerClass;
    }

    protected void setFullyQualifiedCustomizerClass(String customizerClass) {
        String old = this.fullyQualifiedCustomizerClass;
        this.fullyQualifiedCustomizerClass = customizerClass;
        this.firePropertyChanged(FULLY_QUALIFIED_CUSTOMIZER_CLASS_PROPERTY, old, customizerClass);
    }

    protected String buildFullyQualifiedCustomizerClass() {
        EclipseLinkCustomizerAnnotation annotation = this.getCustomizerAnnotation();
        return annotation == null ? null : annotation.getFullyQualifiedCustomizerClassName();
    }

    protected EclipseLinkCustomizerAnnotation getCustomizerAnnotation() {
        return (EclipseLinkCustomizerAnnotation)this.getJavaResourceType().getAnnotation(this.getCustomizerAnnotationName());
    }

    protected EclipseLinkCustomizerAnnotation addCustomizerAnnotation() {
        return (EclipseLinkCustomizerAnnotation)this.getJavaResourceType().addAnnotation(this.getCustomizerAnnotationName());
    }

    protected void removeCustomizerAnnotation() {
        this.getJavaResourceType().removeAnnotation(this.getCustomizerAnnotationName());
    }

    protected String getCustomizerAnnotationName() {
        return "org.eclipse.persistence.annotations.Customizer";
    }

    public EclipseLinkJavaTypeMapping getParent() {
        return (EclipseLinkJavaTypeMapping)super.getParent();
    }

    protected EclipseLinkJavaTypeMapping getTypeMapping() {
        return this.getParent();
    }

    protected JavaResourceType getJavaResourceType() {
        return this.getTypeMapping().getJavaResourceType();
    }

    @Override
    public char getCustomizerClassEnclosingTypeSeparator() {
        return '.';
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateCustomizerClass(messages, astRoot);
    }

    protected void validateCustomizerClass(List<IMessage> messages, CompilationUnit astRoot) {
        IJavaProject javaProject = this.getPersistenceUnit().getJpaProject().getJavaProject();
        EclipseLinkCustomizerAnnotation annotation = this.getCustomizerAnnotation();
        if (annotation != null && annotation.getValue() != null && JDTTools.findType((IJavaProject)javaProject, (String)annotation.getValue()) != null) {
            if (!JDTTools.classHasPublicZeroArgConstructor((IJavaProject)javaProject, (String)this.getFullyQualifiedCustomizerClass())) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "DESCRIPTOR_CUSTOMIZER_CLASS_NOT_VALID", new String[]{this.getFullyQualifiedCustomizerClass()}, this, this.getCustomizerClassTextRange(astRoot)));
            } else if (!annotation.customizerClassImplementsInterface("org.eclipse.persistence.config.DescriptorCustomizer", astRoot)) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "DESCRIPTOR_CUSTOMIZER_CLASS_IMPLEMENTS_DESCRIPTOR_CUSTOMIZER", new String[]{this.getFullyQualifiedCustomizerClass()}, this, this.getCustomizerClassTextRange(astRoot)));
            }
        }
    }

    protected TextRange getCustomizerClassTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getCustomizerAnnotation().getValueTextRange(astRoot), astRoot);
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getCustomizerAnnotation().getTextRange(astRoot);
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange(astRoot);
    }
}

